/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.usecase.pattern.uc3.postprocessing;

import org.eclipse.egf.model.pattern.Node;
import org.eclipse.egf.model.pattern.PatternOutputProcessor;

public class MyPatternProcessor
implements PatternOutputProcessor {
    private static final char[] LETTERS = new char[]{'a', 'e', 'i', 'o', 'u', 'y', 'A', 'E', 'I', 'O', 'U', 'Y'};

    private boolean isVowel(char charAt) {
        char[] cArray = LETTERS;
        int n = LETTERS.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == charAt) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getProcessorId() {
        return "my.processor.id";
    }

    public void applyOnLoopResult(Node.Container node) {
        for (Node childNode : node.getChildren()) {
            Node.DataLeaf leaf;
            String data;
            if (childNode instanceof Node.Container) {
                this.applyOnLoopResult((Node.Container)childNode);
                continue;
            }
            if (!(childNode instanceof Node.DataLeaf) || (data = (leaf = (Node.DataLeaf)childNode).getData()) == null || data.length() == 0 || !this.isVowel(data.charAt(0))) continue;
            leaf.setData("+" + data);
        }
    }

    public void applyOnLoopResult(StringBuilder builder) {
    }

    public void applyOnExecutionResult(Node.Container node) {
        for (Node childNode : node.getChildren()) {
            Node.DataLeaf leaf;
            String data;
            if (childNode instanceof Node.Container) {
                this.applyOnExecutionResult((Node.Container)childNode);
                continue;
            }
            if (!(childNode instanceof Node.DataLeaf) || (data = (leaf = (Node.DataLeaf)childNode).getData()) == null || data.length() == 0) continue;
            if (childNode.getPatternClass() == "org.eclipse.egf.usecase.pattern.uc3.m2treporting.postprocessing.myClassPattern") {
                data = data.replaceFirst("Class", "[Class");
                data = String.valueOf(data) + "]: ";
                leaf.setData(data);
            }
            if (childNode.getPatternClass() != "org.eclipse.egf.usecase.pattern.uc3.m2treporting.postprocessing.myAttributePattern") continue;
            leaf.setData("{" + data + "}");
        }
    }

    public void applyOnExecutionResult(StringBuilder builder) {
        String line = new String("-----------------------------------------------------\n");
        StringBuilder header = new StringBuilder();
        StringBuilder footer = new StringBuilder();
        header.append(line).append("Header\n").append(line);
        footer.append("\n\n").append(line).append("Footer\n").append(line);
        builder.insert(0, header);
        builder.append((CharSequence)footer);
    }
}

