/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.usecase.pattern.uc3.m2treporting.reporter;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.model.pattern.PatternExecutionReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdditionalParametersReporter
implements PatternExecutionReporter {
    protected static final String PROJECT_NAME_CONTRACT = "outputProject";
    protected static final String FOLDER_NAME_CONTRACT = "outputFolder";
    protected static final String FILE_NAME_CONTRACT = "fileName";

    public void executionFinished(String output, PatternContext context) {
        this.writeFile(output, context);
    }

    public void loopFinished(String output, String outputWithCallBack, PatternContext context, Map<String, Object> parameterValues) {
    }

    protected String getProjectName(PatternContext context) {
        return (String)context.getValue(PROJECT_NAME_CONTRACT);
    }

    protected String getFolderName(PatternContext context) {
        return (String)context.getValue(FOLDER_NAME_CONTRACT);
    }

    protected String getFileName(PatternContext context) {
        return (String)context.getValue(FILE_NAME_CONTRACT);
    }

    protected void writeFile(String output, PatternContext context) {
        String projectName = this.getProjectName(context);
        String folderName = this.getFolderName(context);
        String fileName = this.getFileName(context);
        this.writeContentsInFile(projectName, folderName, fileName, output);
    }

    protected void writeContentsInFile(String projectName, String folderName, String fileName, String contents) {
        ByteArrayInputStream contentsStream = new ByteArrayInputStream(contents.getBytes());
        try {
            IFile file = this.getFile(fileName, projectName, folderName);
            if (file.exists()) {
                file.setContents((InputStream)contentsStream, true, false, null);
            } else {
                file.create((InputStream)contentsStream, true, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public IFile getFile(String fileName, String projectName, String folderName) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        Path path = new Path("");
        if (folderName != null && folderName.length() > 0) {
            String[] stringArray = folderName.split("\\.|/|\\\\");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String member = stringArray[n2];
                IFolder folder = project.getFolder((IPath)(path = path.append(member)));
                if (!folder.exists()) {
                    folder.create(true, true, null);
                }
                ++n2;
            }
        }
        path = path.append(fileName);
        return project.getFile((IPath)path);
    }
}

