/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.emf.wrapper;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.egf.core.domain.TargetPlatformResourceSet;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.ftask.producer.invocation.ITaskProduction;
import org.eclipse.egf.model.domain.EMFDomain;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.util.GenModelUtil;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EgfEmfAbstractTask
implements ITaskProduction {
    private Resource _resource;
    private GenModel _genModel;

    public void preExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        this._resource = new TargetPlatformResourceSet().getResource(((EMFDomain)productionContext.getInputValue((Object)"genModelURI", EMFDomain.class)).getUri(), true);
    }

    public void doExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        this._genModel = (GenModel)this._resource.getContents().get(0);
        this._genModel.reconcile();
        this._genModel.setCanGenerate(true);
        this._genModel.setValidateModel(true);
        this._genModel.diagnose();
        this._genModel.validate();
        Generator generator = GenModelUtil.createGenerator((GenModel)this._genModel);
        for (String projectType : this.getProjectTypeList()) {
            Monitor emfMonitor = BasicMonitor.toMonitor((IProgressMonitorWithBlocking)new SubProgressMonitor(monitor, 100));
            generator.generate((Object)this._genModel, (Object)projectType, emfMonitor);
        }
    }

    public void postExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        this._resource.unload();
    }

    protected abstract ArrayList<String> getProjectTypeList();
}

