/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.editors;

import com.ibm.icu.text.NumberFormat;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.conversion.NumberToStringConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egerrit.internal.core.EGerritCorePlugin;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.core.command.AbandonCommand;
import org.eclipse.egerrit.internal.core.command.DeleteDraftChangeCommand;
import org.eclipse.egerrit.internal.core.command.PublishDraftChangeCommand;
import org.eclipse.egerrit.internal.core.command.RestoreCommand;
import org.eclipse.egerrit.internal.core.command.RevertCommand;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.eclipse.egerrit.internal.core.rest.AbandonInput;
import org.eclipse.egerrit.internal.core.rest.RestoreInput;
import org.eclipse.egerrit.internal.core.rest.RevertInput;
import org.eclipse.egerrit.internal.model.ActionConstants;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.ModelPackage;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.process.CherryPickProcess;
import org.eclipse.egerrit.internal.process.RebaseProcess;
import org.eclipse.egerrit.internal.process.ReplyProcess;
import org.eclipse.egerrit.internal.process.SubmitProcess;
import org.eclipse.egerrit.internal.ui.editors.CheckoutRevision;
import org.eclipse.egerrit.internal.ui.editors.CherryPickRevision;
import org.eclipse.egerrit.internal.ui.editors.HideControlObservable;
import org.eclipse.egerrit.internal.ui.editors.ModelLoader;
import org.eclipse.egerrit.internal.ui.editors.NegateBooleanConverter;
import org.eclipse.egerrit.internal.ui.editors.model.ChangeDetailEditorInput;
import org.eclipse.egerrit.internal.ui.table.provider.DeleteDraftRevisionProvider;
import org.eclipse.egerrit.internal.ui.table.provider.PatchSetHandlerProvider;
import org.eclipse.egerrit.internal.ui.tabs.DetailsTabView;
import org.eclipse.egerrit.internal.ui.tabs.HistoryTabView;
import org.eclipse.egerrit.internal.ui.tabs.MessageTabView;
import org.eclipse.egerrit.internal.ui.tabs.ObservableCollector;
import org.eclipse.egerrit.internal.ui.utils.ActiveWorkspaceRevision;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.egerrit.internal.ui.utils.UIUtils;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeDetailEditor
extends EditorPart {
    private static Logger logger = LoggerFactory.getLogger(ChangeDetailEditor.class);
    private final String MARKERS_KEY = "markertip";
    public static final String EDITOR_ID = "org.eclipse.egerrit.ui.editors.ChangeDetailEditor";
    private DetailsTabView detailsTab = null;
    private HistoryTabView historytab = null;
    private MessageTabView messageTab = null;
    private ChangeInfo fChangeInfo;
    private GerritClient fGerritClient = null;
    private Text subjectData;
    private Text statusData;
    private Text shortIdData;
    private Composite headerSection;
    private ModelLoader loader;
    private EContentAdapter subjectListener;
    private DataBindingContext bindingContext = new DataBindingContext();
    private DeleteDraftRevisionProvider deleteDraftRevision = null;
    private PatchSetHandlerProvider patchSetSelector;
    private HideControlObservable hidableRevertButton;
    private HideControlObservable hidableSubmitButton;
    private ObservableCollector observableCollector;

    public void createPartControl(Composite parent) {
        this.loader = ModelLoader.initialize(this.fGerritClient, this.fChangeInfo);
        this.loader.loadBasicInformation();
        parent.setLayout((Layout)new GridLayout(1, false));
        parent.setBackground(parent.getDisplay().getSystemColor(25));
        this.headerSection = this.headerSection(parent);
        this.headerSection.setLayoutData((Object)new GridData(4, 128, true, false));
        TabFolder tabFolder = new TabFolder(parent, 0);
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        tabFolder.setBackground(parent.getBackground());
        this.historytab = new HistoryTabView();
        this.historytab.create(this.fGerritClient, tabFolder, this.fChangeInfo);
        this.messageTab = new MessageTabView();
        this.messageTab.create(this.fGerritClient, (Composite)tabFolder, this.fChangeInfo);
        this.detailsTab = new DetailsTabView();
        this.detailsTab.create(this.fGerritClient, tabFolder, this.fChangeInfo);
        Composite compButton = this.buttonSection(parent);
        compButton.setLayoutData((Object)new GridData(4, 0, true, false));
        this.setPartName(((ChangeDetailEditorInput)this.getEditorInput()).getName());
        this.observableCollector = new ObservableCollector(this.bindingContext);
    }

    private Composite headerSection(Composite parent) {
        Group group_header = new Group(parent, 0);
        group_header.setLayout((Layout)new GridLayout(10, false));
        group_header.setBackground(parent.getBackground());
        Label lblId = new Label((Composite)group_header, 0);
        lblId.setText(Messages.ChangeDetailEditor_2);
        this.shortIdData = new Text((Composite)group_header, 0);
        this.shortIdData.setEditable(false);
        this.shortIdData.setBackground(parent.getBackground());
        this.shortIdData.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.statusData = new Text((Composite)group_header, 16384);
        GridData gd_lblStatus = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.statusData.setLayoutData((Object)gd_lblStatus);
        this.statusData.setEditable(false);
        this.statusData.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                ChangeDetailEditor.this.statusData.getParent().layout();
            }
        });
        Label lblSubject = new Label((Composite)group_header, 0);
        lblSubject.setText(Messages.ChangeDetailEditor_3);
        GridData gd_Subject = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_Subject.horizontalIndent = 10;
        lblSubject.setLayoutData((Object)gd_Subject);
        this.subjectData = new Text((Composite)group_header, 0);
        GridData gd_lblSubjectData = new GridData(16384, 0x1000000, true, false, 1, 1);
        this.subjectData.setLayoutData((Object)gd_lblSubjectData);
        this.subjectData.setEditable(false);
        this.subjectData.setBackground(parent.getBackground());
        this.subjectData.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                ChangeDetailEditor.this.subjectData.getParent().layout();
            }
        });
        final String ACTIVATION_MESSAGE = Messages.ChangeDetailEditor_4;
        final Button activeReview = new Button((Composite)group_header, 32);
        activeReview.setSelection(false);
        activeReview.setText(ACTIVATION_MESSAGE);
        activeReview.setToolTipText(Messages.ChangeDetailEditor_5);
        IObservableValue observeActiveRevisionStateForButtonText = BeanProperties.value((String)"activeRevision").observe((Object)ActiveWorkspaceRevision.getInstance());
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)activeReview), observeActiveRevisionStateForButtonText, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(){

            public Object convert(Object value) {
                if (value == null) {
                    return ACTIVATION_MESSAGE;
                }
                if (((RevisionInfo)value).getChangeInfo().getId().equals(ChangeDetailEditor.this.fChangeInfo.getId())) {
                    ChangeDetailEditor.this.activateMarkers();
                    return String.valueOf(Messages.ChangeDetailEditor_7) + ((RevisionInfo)value).get_number();
                }
                return ACTIVATION_MESSAGE;
            }
        });
        IObservableValue observeActiveRevisionStateForButtonEnablement = BeanProperties.value((String)"activeRevision").observe((Object)ActiveWorkspaceRevision.getInstance());
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)activeReview), observeActiveRevisionStateForButtonEnablement, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(){

            public Object convert(Object value) {
                if (value == null) {
                    return false;
                }
                if (((RevisionInfo)value).getChangeInfo().getId().equals(ChangeDetailEditor.this.fChangeInfo.getId())) {
                    return true;
                }
                return false;
            }
        });
        activeReview.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (activeReview.getSelection()) {
                    ActiveWorkspaceRevision.getInstance().activateCurrentRevision(ChangeDetailEditor.this.fGerritClient, ChangeDetailEditor.this.fChangeInfo.getUserSelectedRevision() != null ? ChangeDetailEditor.this.fChangeInfo.getUserSelectedRevision() : ChangeDetailEditor.this.fChangeInfo.getRevision());
                } else {
                    ActiveWorkspaceRevision.getInstance().deactiveCurrentRevision();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.deleteDraftRevision = new DeleteDraftRevisionProvider();
        this.deleteDraftRevision.create((Composite)group_header, this.fGerritClient, this.fChangeInfo);
        this.patchSetSelector = new PatchSetHandlerProvider();
        this.patchSetSelector.create((Composite)group_header, this.fChangeInfo);
        this.headerSectionDataBindings();
        return group_header;
    }

    private void activateMarkers() {
        if (!this.fGerritClient.getRepository().getServerInfo().isAnonymous()) {
            UIUtils.showDialogTip("markertip", this.headerSection.getShell(), Messages.EGerriTip, Messages.ChangeDetailEditor_EGerriTipValue);
        }
    }

    private Composite buttonSection(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(8, true));
        Button refresh = new Button(c, 8);
        refresh.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        refresh.setText(ActionConstants.REFRESH.getLiteral());
        refresh.setToolTipText(Messages.ChangeDetailEditor_9);
        refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChangeDetailEditor.this.refreshStatus();
            }
        });
        Button submitButton = new Button(c, 8);
        submitButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        submitButton.setText(ActionConstants.SUBMIT.getLiteral());
        submitButton.setEnabled(false);
        final Button revertButton = new Button(c, 8);
        revertButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        revertButton.setText(ActionConstants.REVERT.getLiteral());
        revertButton.setEnabled(false);
        IObservableValue observeSubmitable = EMFProperties.value((EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__USER_SELECTED_REVISION).value((EStructuralFeature)ModelPackage.Literals.REVISION_INFO__SUBMITABLE).observe((Object)this.fChangeInfo);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)submitButton), observeSubmitable, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), null);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.visible().observe((Widget)submitButton), observeSubmitable, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(){

            public Object convert(Object value) {
                if (value == null) {
                    return false;
                }
                boolean state = (Boolean)value;
                if (state) {
                    return true;
                }
                if (revertButton.isVisible()) {
                    return false;
                }
                return true;
            }
        });
        IObservableValue observeRevertable = EMFProperties.value((EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__REVERTABLE).observe((Object)this.fChangeInfo);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)revertButton), observeRevertable, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), null);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.visible().observe((Widget)revertButton), observeRevertable, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), null);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.visible().observe((Widget)submitButton), observeRevertable, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), (UpdateValueStrategy)new NegateBooleanConverter());
        this.hidableSubmitButton = new HideControlObservable((Control)submitButton);
        this.bindingContext.bindValue((IObservableValue)this.hidableSubmitButton, observeRevertable, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), (UpdateValueStrategy)new NegateBooleanConverter());
        this.hidableRevertButton = new HideControlObservable((Control)revertButton);
        this.bindingContext.bindValue((IObservableValue)new HideControlObservable((Control)revertButton), observeRevertable, null, null);
        submitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                SubmitProcess submitProcess = new SubmitProcess();
                submitProcess.handleSubmit(ChangeDetailEditor.this.fChangeInfo, ChangeDetailEditor.this.fGerritClient);
            }
        });
        revertButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean revertSuccessfull = false;
                String revertMsg = NLS.bind((String)Messages.Revert_message, (Object[])new Object[]{ChangeDetailEditor.this.fChangeInfo.getSubject(), ChangeDetailEditor.this.fChangeInfo.getRevision().getCommit().getCommit(), ChangeDetailEditor.this.fChangeInfo.get_number()});
                ChangeInfo revertResult = null;
                String revertErrorMessage = null;
                while (!revertSuccessfull) {
                    final String errorMsg = revertErrorMessage;
                    InputDialog replyDialog = new InputDialog(revertButton.getShell(), Messages.Revert_dialog_title, Messages.Revert_dialog_message, revertMsg, revertErrorMessage == null ? null : new IInputValidator(){
                        private int count = 0;

                        public String isValid(String newText) {
                            if (this.count == 0) {
                                ++this.count;
                                return errorMsg;
                            }
                            return null;
                        }
                    }){

                        protected int getInputTextStyle() {
                            return 2626;
                        }

                        protected Control createDialogArea(Composite parent) {
                            Control res = super.createDialogArea(parent);
                            ((GridData)this.getText().getLayoutData()).heightHint = 100;
                            ((GridData)this.getText().getLayoutData()).widthHint = 500;
                            return res;
                        }
                    };
                    if (replyDialog.open() != 0) {
                        return;
                    }
                    RevertCommand revertCmd = ChangeDetailEditor.this.fGerritClient.revert(ChangeDetailEditor.this.fChangeInfo.getId());
                    RevertInput revertInput = new RevertInput();
                    revertMsg = replyDialog.getValue();
                    revertInput.setMessage(revertMsg);
                    revertCmd.setCommandInput((Object)revertInput);
                    try {
                        revertResult = (ChangeInfo)revertCmd.call();
                        if (revertResult == null) {
                            revertErrorMessage = revertCmd.getFailureReason();
                            continue;
                        }
                        revertSuccessfull = true;
                    }
                    catch (EGerritException e3) {
                        EGerritCorePlugin.logError((String)(String.valueOf(ChangeDetailEditor.this.fGerritClient.getRepository().formatGerritVersion()) + e3.getMessage()));
                        return;
                    }
                }
                UIUtils.openAnotherEditor(revertResult, ChangeDetailEditor.this.fGerritClient);
            }
        });
        final Button fAbandon = new Button(c, 8);
        fAbandon.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        fAbandon.setEnabled(false);
        fAbandon.setText(ActionConstants.ABANDON.getLiteral());
        final Button fRestore = new Button(c, 8);
        fRestore.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        fRestore.setEnabled(false);
        fRestore.setText(ActionConstants.RESTORE.getLiteral());
        IObservableValue observeAbandonable = EMFProperties.value((EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__ABANDONABLE).observe((Object)this.fChangeInfo);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)fAbandon), observeAbandonable, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), null);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.visible().observe((Widget)fAbandon), observeAbandonable, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), null);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.visible().observe((Widget)fAbandon), observeAbandonable, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(){

            public Object convert(Object value) {
                boolean state = (Boolean)value;
                if (state) {
                    return true;
                }
                if (fRestore.isVisible()) {
                    return false;
                }
                return true;
            }
        });
        IObservableValue observeRestorable = EMFProperties.value((EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__RESTOREABLE).observe((Object)this.fChangeInfo);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)fRestore), observeRestorable, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), null);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.visible().observe((Widget)fRestore), observeRestorable, null, (UpdateValueStrategy)new NegateBooleanConverter());
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.visible().observe((Widget)fAbandon), observeRestorable, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), (UpdateValueStrategy)new NegateBooleanConverter());
        this.bindingContext.bindValue((IObservableValue)new HideControlObservable((Control)fAbandon), observeRestorable, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), (UpdateValueStrategy)new NegateBooleanConverter());
        this.bindingContext.bindValue((IObservableValue)new HideControlObservable((Control)fRestore), observeRestorable, null, null);
        fAbandon.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                InputDialog inputDialog = new InputDialog(fAbandon.getParent().getShell(), Messages.ChangeDetailEditor_13, Messages.ChangeDetailEditor_14, "", null);
                if (inputDialog.open() != 0) {
                    return;
                }
                AbandonCommand abandonCmd = ChangeDetailEditor.this.fGerritClient.abandon(ChangeDetailEditor.this.fChangeInfo.getId());
                AbandonInput abandonInput = new AbandonInput();
                abandonInput.setMessage(inputDialog.getValue());
                abandonCmd.setCommandInput((Object)abandonInput);
                try {
                    abandonCmd.call();
                }
                catch (EGerritException e3) {
                    EGerritCorePlugin.logError((String)(String.valueOf(ChangeDetailEditor.this.fGerritClient.getRepository().formatGerritVersion()) + e3.getMessage()));
                }
                ChangeDetailEditor.this.refreshStatus();
            }
        });
        fRestore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                InputDialog inputDialog = new InputDialog(fAbandon.getParent().getShell(), Messages.ChangeDetailEditor_16, Messages.ChangeDetailEditor_17, "", null);
                if (inputDialog.open() != 0) {
                    return;
                }
                RestoreCommand restoreCmd = ChangeDetailEditor.this.fGerritClient.restore(ChangeDetailEditor.this.fChangeInfo.getId());
                RestoreInput restoreInput = new RestoreInput();
                restoreInput.setMessage(inputDialog.getValue());
                restoreCmd.setCommandInput((Object)restoreInput);
                try {
                    restoreCmd.call();
                }
                catch (EGerritException e3) {
                    EGerritCorePlugin.logError((String)(String.valueOf(ChangeDetailEditor.this.fGerritClient.getRepository().formatGerritVersion()) + e3.getMessage()));
                }
                ChangeDetailEditor.this.refreshStatus();
            }
        });
        final Button rebaseButton = new Button(c, 8);
        rebaseButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        rebaseButton.setText(ActionConstants.REBASE.getLiteral());
        rebaseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RebaseProcess rebaseProcess = new RebaseProcess();
                rebaseProcess.handleRebase(rebaseButton.getShell(), ChangeDetailEditor.this.fChangeInfo, ChangeDetailEditor.this.fChangeInfo.getUserSelectedRevision(), ChangeDetailEditor.this.fGerritClient);
            }
        });
        Button download = new Button(c, 8);
        download.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        download.setText(Messages.ChangeDetailEditor_24);
        download.addSelectionListener(this.downloadButtonListener(parent));
        final Button cherryPickToRemoteBranch = new Button(c, 8);
        cherryPickToRemoteBranch.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        cherryPickToRemoteBranch.setText(ActionConstants.CHERRYPICK.getLiteral());
        cherryPickToRemoteBranch.setToolTipText(Messages.ChangeDetailEditor_cherryPickBranch);
        IObservableValue cherryPickAble = EMFProperties.value((EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__USER_SELECTED_REVISION).value((EStructuralFeature)ModelPackage.Literals.REVISION_INFO__CHERRYPICKABLE).observe((Object)this.fChangeInfo);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)cherryPickToRemoteBranch), cherryPickAble, null, null);
        cherryPickToRemoteBranch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CherryPickProcess cherryPickProcess = new CherryPickProcess();
                cherryPickProcess.handleCherryPick(cherryPickToRemoteBranch.getShell(), ChangeDetailEditor.this.fGerritClient, ChangeDetailEditor.this.fChangeInfo, ChangeDetailEditor.this.fChangeInfo.getUserSelectedRevision());
            }
        });
        final Button replyButton = new Button(c, 0x100000E);
        replyButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        replyButton.setText(ActionConstants.REPLY.getLiteral());
        if (this.fGerritClient.getRepository().getServerInfo().isAnonymous()) {
            replyButton.setEnabled(false);
        }
        replyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                Menu menu = new Menu((Decorations)shell, 8);
                final ReplyProcess replyProcess = new ReplyProcess();
                MenuItem itemReply = new MenuItem(menu, 8);
                itemReply.setText(ActionConstants.REPLY.getLiteral());
                itemReply.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        replyProcess.handleReplyDialog(replyButton.getShell(), ChangeDetailEditor.this.fChangeInfo, ChangeDetailEditor.this.fGerritClient, ChangeDetailEditor.this.fChangeInfo.getUserSelectedRevision());
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                MenuItem itemCRPlus2 = new MenuItem(menu, 8);
                itemCRPlus2.setText(Messages.ChangeDetailEditor_25);
                itemCRPlus2.setEnabled(replyProcess.isCRPlusTwoAllowed(ChangeDetailEditor.this.fChangeInfo, ChangeDetailEditor.this.fGerritClient, ChangeDetailEditor.this.fChangeInfo.getUserSelectedRevision()));
                if (itemCRPlus2.isEnabled()) {
                    itemCRPlus2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            super.widgetSelected(e);
                            replyProcess.handleReplyPlus2(ChangeDetailEditor.this.fChangeInfo.getUserSelectedRevision());
                        }
                    });
                }
                Point loc = replyButton.getLocation();
                Rectangle rect = replyButton.getBounds();
                Point mLoc = new Point(loc.x - 1, loc.y + rect.height);
                menu.setLocation(shell.getDisplay().map((Control)replyButton.getParent(), null, mLoc));
                menu.setVisible(true);
            }
        });
        final Button draftButton = new Button(c, 0x100000E);
        draftButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        draftButton.setText(ActionConstants.DRAFT.getLiteral());
        IObservableValue observeDeleteable = EMFProperties.value((EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__DELETEABLE).observe((Object)this.fChangeInfo);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)draftButton), observeDeleteable, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), null);
        draftButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Menu menu = new Menu((Decorations)draftButton.getShell(), 8);
                MenuItem itemPublish = new MenuItem(menu, 8);
                itemPublish.setText(ActionConstants.PUBLISH.getLiteral());
                itemPublish.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        PublishDraftChangeCommand publishCommand = ChangeDetailEditor.this.fGerritClient.publishDraftChange(ChangeDetailEditor.this.fChangeInfo.getId());
                        try {
                            publishCommand.call();
                            ChangeDetailEditor.this.refreshStatus();
                        }
                        catch (EGerritException e1) {
                            EGerritCorePlugin.logError((String)(String.valueOf(ChangeDetailEditor.this.fGerritClient.getRepository().formatGerritVersion()) + e1.getMessage()));
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                MenuItem itemDeleteDraftChange = new MenuItem(menu, 8);
                itemDeleteDraftChange.setText(Messages.ChangeDetailEditor_27);
                itemDeleteDraftChange.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        super.widgetSelected(e);
                        if (!MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)Messages.ChangeDetailEditor_28, (String)NLS.bind((String)Messages.ChangeDetailEditor_29, (Object)ChangeDetailEditor.this.fChangeInfo.getSubject()))) {
                            return;
                        }
                        DeleteDraftChangeCommand deleteDraftChangeCmd = ChangeDetailEditor.this.fGerritClient.deleteDraftChange(ChangeDetailEditor.this.fChangeInfo.getId());
                        try {
                            deleteDraftChangeCmd.call();
                            IWorkbench workbench = PlatformUI.getWorkbench();
                            IWorkbenchPage activePage = workbench.getActiveWorkbenchWindow().getActivePage();
                            IEditorPart editor = activePage.getActiveEditor();
                            activePage.closeEditor(editor, false);
                        }
                        catch (EGerritException e1) {
                            EGerritCorePlugin.logError((String)(String.valueOf(ChangeDetailEditor.this.fGerritClient.getRepository().formatGerritVersion()) + e1.getMessage()));
                        }
                    }
                });
                Point loc = draftButton.getLocation();
                Rectangle rect = draftButton.getBounds();
                Point mLoc = new Point(loc.x - 1, loc.y + rect.height);
                menu.setLocation(draftButton.getDisplay().map((Control)draftButton.getParent(), null, mLoc));
                menu.setVisible(true);
            }
        });
        c.setSize(c.computeSize(-1, -1));
        return c;
    }

    private SelectionListener downloadButtonListener(final Composite parent) {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MenuManager mgr = new MenuManager();
                mgr.add((IAction)new CherryPickRevision(ChangeDetailEditor.this.fChangeInfo.getUserSelectedRevision(), ChangeDetailEditor.this.fGerritClient));
                mgr.add((IAction)new CheckoutRevision(ChangeDetailEditor.this.fChangeInfo.getUserSelectedRevision(), ChangeDetailEditor.this.fGerritClient));
                mgr.createContextMenu((Control)parent).setVisible(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    public void setFocus() {
        this.headerSection.setFocus();
    }

    private void setChangeInfo(GerritClient gerritClient, ChangeInfo element) {
        this.fGerritClient = gerritClient;
        if (this.fChangeInfo == null) {
            this.fChangeInfo = element;
            this.fChangeInfo.setUserSelectedRevision((RevisionInfo)element.getRevisions().get((Object)element.getCurrent_revision()));
        } else {
            this.fChangeInfo.set_number(element.get_number());
            this.fChangeInfo.setChange_id(element.getChange_id());
            this.fChangeInfo.setStatus(element.getStatus());
            this.fChangeInfo.setStarred(element.isStarred());
            this.fChangeInfo.setCreated(element.getCreated());
            this.fChangeInfo.setUpdated(element.getUpdated());
            this.fChangeInfo.setReviewed(element.isReviewed());
            this.fChangeInfo.setMergeable(element.isMergeable());
            this.fChangeInfo.setInsertions(element.getInsertions());
            this.fChangeInfo.setDeletions(element.getDeletions());
            this.fChangeInfo.setCurrent_revision(element.getCurrent_revision());
        }
    }

    public void refreshStatus() {
        this.loader.reload();
    }

    protected void headerSectionDataBindings() {
        IObservableValue idObservable = EMFProperties.value((EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__NUMBER).observe((Object)this.fChangeInfo);
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setGroupingUsed(false);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.shortIdData), idObservable, null, new UpdateValueStrategy().setConverter((IConverter)NumberToStringConverter.fromInteger((NumberFormat)numberFormat, (boolean)true)));
        IObservableValue subjectObservable = EMFProperties.value((EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__SUBJECT).observe((Object)this.fChangeInfo);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.subjectData), subjectObservable, null, null);
        this.fChangeInfo.eAdapters().add((Object)this.getSubjectListener());
        IObservableValue statusObserveValue = EMFProperties.value((EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__STATUS).observe((Object)this.fChangeInfo);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.statusData), statusObserveValue, null, null);
    }

    private EContentAdapter getSubjectListener() {
        this.subjectListener = new EContentAdapter(){

            public void notifyChanged(Notification msg) {
                if (msg.getFeature() == null) {
                    return;
                }
                if (msg.getFeature().equals(ModelPackage.Literals.CHANGE_INFO__SUBJECT)) {
                    Display.getDefault().asyncExec(() -> ChangeDetailEditor.this.setPartName(ChangeDetailEditor.this.fChangeInfo.getSubject()));
                }
            }
        };
        return this.subjectListener;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof ChangeDetailEditorInput)) {
            logger.debug("Input is not a ChangeDetailEditorInput");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setChangeInfo(((ChangeDetailEditorInput)input).getClient(), ((ChangeDetailEditorInput)input).getChange());
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void dispose() {
        this.loader.dispose();
        this.fChangeInfo.eAdapters().remove((Object)this.subjectListener);
        this.observableCollector.dispose();
        this.bindingContext.dispose();
        this.deleteDraftRevision.dispose();
        this.patchSetSelector.dispose();
        this.hidableRevertButton.dispose();
        this.hidableSubmitButton.dispose();
        this.historytab.dispose();
        this.messageTab.dispose();
        this.detailsTab.dispose();
    }
}

