/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.pde.ui.e4.project.media.tpl.parts;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fx.ide.rrobot.model.task.CompilationUnit;
import org.eclipse.fx.ide.rrobot.model.task.DynamicFile;
import org.eclipse.fx.ide.rrobot.model.task.Generator;
import org.eclipse.xtend2.lib.StringConcatenation;

public class MediaPartTpl
implements Generator<DynamicFile> {
    public InputStream generate(DynamicFile file, Map<String, Object> data) {
        EObject _eContainer = file.eContainer();
        CompilationUnit cu = (CompilationUnit)_eContainer;
        String _substring = cu.getPackagename().substring(0, cu.getPackagename().lastIndexOf("."));
        String modelPackage = String.valueOf(_substring) + ".model";
        String _substring_1 = cu.getPackagename().substring(0, cu.getPackagename().lastIndexOf("."));
        String handlersPackage = String.valueOf(_substring_1) + ".handlers";
        byte[] _bytes = this.generate(cu.getPackagename(), modelPackage, handlersPackage).toString().getBytes();
        return new ByteArrayInputStream(_bytes);
    }

    public CharSequence generate(String packageName, String modelPackage, String handlersPackage) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        _builder.append(packageName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.io.File;");
        _builder.newLine();
        _builder.append("import java.io.FileOutputStream;");
        _builder.newLine();
        _builder.append("import java.io.IOException;");
        _builder.newLine();
        _builder.append("import java.io.InputStream;");
        _builder.newLine();
        _builder.append("import java.net.MalformedURLException;");
        _builder.newLine();
        _builder.append("import java.net.URL;");
        _builder.newLine();
        _builder.append("import java.util.concurrent.atomic.AtomicReference;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import javafx.event.EventHandler;");
        _builder.newLine();
        _builder.append("import javafx.scene.Node;");
        _builder.newLine();
        _builder.append("import javafx.scene.image.ImageView;");
        _builder.newLine();
        _builder.append("import javafx.scene.input.MouseEvent;");
        _builder.newLine();
        _builder.append("import javafx.scene.input.ScrollEvent;");
        _builder.newLine();
        _builder.append("import javafx.scene.layout.AnchorPane;");
        _builder.newLine();
        _builder.append("import javafx.scene.layout.BorderPane;");
        _builder.newLine();
        _builder.append("import javafx.scene.media.MediaPlayer;");
        _builder.newLine();
        _builder.append("import javafx.scene.media.MediaView;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import javax.annotation.PostConstruct;");
        _builder.newLine();
        _builder.append("import javax.inject.Inject;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import org.eclipse.e4.core.di.annotations.Optional;");
        _builder.newLine();
        _builder.append("import org.eclipse.e4.ui.di.Focus;");
        _builder.newLine();
        _builder.append("import org.eclipse.e4.ui.di.UIEventTopic;");
        _builder.newLine();
        _builder.append("import org.eclipse.e4.ui.model.application.ui.basic.MPart;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import ");
        _builder.append(handlersPackage);
        _builder.append(".RefreshHandler;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(modelPackage);
        _builder.append(".Media;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(modelPackage);
        _builder.append(".MediaType;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("@SuppressWarnings(\"restriction\")");
        _builder.newLine();
        _builder.append("public class MediaPart {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public static final String MEDIA_OBJECT_KEY = \"MediaObject\";");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private static final String KEY_TRANSLATE_X = \"translateX\";");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private static final String KEY_TRANSLATE_Y = \"translateY\";");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private static final String KEY_SCALE_FACTOR = \"scale\";");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Inject");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("MPart part;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private MediaPlayer mediaPlayer;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private Node focusNode;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@PostConstruct");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("void init(BorderPane p) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Media m = Media.deserialize(part.getPersistedState().get(MEDIA_OBJECT_KEY));");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if( m.getType() == MediaType.PICTURE ) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("initPicture(p, m);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("} else if( m.getType() == MediaType.MOVIE ) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("initMovie(p, m);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("initSound(p, m);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private void initPicture(BorderPane p, Media m) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("final AnchorPane transformStack = new AnchorPane();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("String scaleFactor = part.getPersistedState().get(KEY_SCALE_FACTOR);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("String translateX = part.getPersistedState().get(KEY_TRANSLATE_X);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("String translateY = part.getPersistedState().get(KEY_TRANSLATE_Y);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if( scaleFactor != null ) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("transformStack.setScaleX(Double.parseDouble(scaleFactor));");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("transformStack.setScaleY(Double.parseDouble(scaleFactor));");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if( translateX != null ) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("transformStack.setTranslateX(Double.parseDouble(translateX));");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if( translateY != null ) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("transformStack.setTranslateY(Double.parseDouble(translateY));");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("final ImageView v = new ImageView(m.getUrl());");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("focusNode = v;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("transformStack.getChildren().add(v);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("p.setCenter(transformStack);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("p.setOnScroll(new EventHandler<ScrollEvent>() {");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("public void handle(ScrollEvent event) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("int direction = event.getDeltaY() < 0 || event.isShiftDown() ? -1 : 1;");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("double val = Math.max(transformStack.getScaleX() + 0.05 * direction,0.1);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("transformStack.setScaleX(val);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("transformStack.setScaleY(val);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("part.getPersistedState().put(KEY_SCALE_FACTOR, val+\"\");");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("});");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("final AtomicReference<MouseEvent> deltaEvent = new AtomicReference<MouseEvent>();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("p.setOnMousePressed(new EventHandler<MouseEvent>() {");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("public void handle(MouseEvent event) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("deltaEvent.set(event);\t");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("});");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("p.setOnMouseDragged(new EventHandler<MouseEvent>() {");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("public void handle(MouseEvent event) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("double deltaX = event.getX() - deltaEvent.get().getX();");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("double deltaY = event.getY() - deltaEvent.get().getY();");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("double targetX = transformStack.getTranslateX() + deltaX;");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("double targetY = transformStack.getTranslateY() + deltaY;");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("transformStack.setTranslateX(targetX);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("transformStack.setTranslateY(targetY);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("part.getPersistedState().put(KEY_TRANSLATE_X, targetX+\"\");");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("part.getPersistedState().put(KEY_TRANSLATE_Y, targetY+\"\");");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("deltaEvent.set(event);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("});");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private void initMovie(BorderPane p, Media m) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("mediaPlayer = new MediaPlayer(new javafx.scene.media.Media(platformUriFix(m.getUrl())));");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("mediaPlayer.setAutoPlay(true);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("final MediaView mediaView = new MediaView(mediaPlayer);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("focusNode = mediaView;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("p.setCenter(mediaView);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("p.setOnScroll(new EventHandler<ScrollEvent>() {");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("public void handle(ScrollEvent event) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("int direction = event.getDeltaY() < 0 || event.isShiftDown() ? -1 : 1; ");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("double val = Math.max(mediaView.getScaleX() + 0.05 * direction,0.1);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("mediaView.setScaleX(val);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("mediaView.setScaleY(val);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("part.getPersistedState().put(KEY_SCALE_FACTOR, val+\"\");");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("});");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Inject");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Optional");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("void refresh(@UIEventTopic(RefreshHandler.REFRESH_EVENT) String event) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if( part.getParent().getSelectedElement() == part ) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if( mediaPlayer != null ) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("mediaPlayer.seek(mediaPlayer.getStartTime());");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}\t\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Focus");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("void focus() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if( focusNode != null ) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("focusNode.requestFocus();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private String platformUriFix(String uri) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if( uri.startsWith(\"platform:\") ) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("URL url = new URL(uri);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("InputStream in = url.openStream();");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("byte[] buf = new byte[1024];");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("int l;");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("File f = File.createTempFile(\"movie\", \"\");");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("FileOutputStream out = new FileOutputStream(f);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("while( (l = in.read(buf)) != -1 ) {");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("out.write(buf, 0, l);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("out.close();");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("return f.toURI().toURL().toExternalForm();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("} catch (MalformedURLException e) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("// TODO Auto-generated catch block");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("e.printStackTrace();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("} catch (IOException e) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("// TODO Auto-generated catch block");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("e.printStackTrace();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return uri;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return uri;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private void initSound(BorderPane p, Media m) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }
}

