/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.rrobot.impl.generators;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fx.ide.rrobot.model.bundle.Cardinality;
import org.eclipse.fx.ide.rrobot.model.bundle.ComponentDefinitionFile;
import org.eclipse.fx.ide.rrobot.model.bundle.ComponentReference;
import org.eclipse.fx.ide.rrobot.model.bundle.Policy;
import org.eclipse.fx.ide.rrobot.model.task.Generator;
import org.eclipse.xtend2.lib.StringConcatenation;

public class DSComponentGenerator
implements Generator<ComponentDefinitionFile> {
    public InputStream generate(ComponentDefinitionFile file, Map<String, Object> data) {
        CharSequence _generateContent = this.generateContent(file);
        String _string = _generateContent.toString();
        byte[] _bytes = _string.getBytes();
        return new ByteArrayInputStream(_bytes);
    }

    public CharSequence generateContent(ComponentDefinitionFile file) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        _builder.newLine();
        _builder.append((Object)"<scr:component xmlns:scr=\"http://www.osgi.org/xmlns/scr/v1.1.0\" name=\"");
        String _id = file.getId();
        _builder.append((Object)_id, "");
        _builder.append((Object)"\">");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"<implementation class=\"");
        String _componentClass = file.getComponentClass();
        _builder.append((Object)_componentClass, "\t");
        _builder.append((Object)"\"/>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"<service>");
        _builder.newLine();
        EList _serviceInterfaceList = file.getServiceInterfaceList();
        for (String s : _serviceInterfaceList) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"<provide interface=\"");
            _builder.append((Object)s, "\t\t");
            _builder.append((Object)"\"/>");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"</service>");
        _builder.newLine();
        EList _referenceList = file.getReferenceList();
        for (ComponentReference r : _referenceList) {
            _builder.append((Object)"\t");
            _builder.append((Object)"<reference bind=\"");
            String _bind = r.getBind();
            _builder.append((Object)_bind, "\t");
            _builder.append((Object)"\" cardinality=\"");
            Cardinality _cardinality = r.getCardinality();
            String _cardinality_1 = this.cardinality(_cardinality);
            _builder.append((Object)_cardinality_1, "\t");
            _builder.append((Object)"\" interface=\"");
            String _typeName = r.getTypeName();
            _builder.append((Object)_typeName, "\t");
            _builder.append((Object)"\" name=\"");
            String _name = r.getName();
            _builder.append((Object)_name, "\t");
            _builder.append((Object)"\" policy=\"");
            Policy _policy = r.getPolicy();
            String _policy_1 = this.policy(_policy);
            _builder.append((Object)_policy_1, "\t");
            _builder.append((Object)"\" unbind=\"");
            String _unbind = r.getUnbind();
            _builder.append((Object)_unbind, "\t");
            _builder.append((Object)"\"/>");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"</scr:component>");
        _builder.newLine();
        return _builder;
    }

    public String cardinality(Cardinality c) {
        if (c != null) {
            switch (c) {
                case SINGLE_OPTIONAL: {
                    return "0..1";
                }
                case SINGLE_REQUIRED: {
                    return "1..1";
                }
                case MULTI_OPTIONAL: {
                    return "0..n";
                }
            }
            return "1..n";
        }
        return "1..n";
    }

    public String policy(Policy p) {
        if (p != null) {
            switch (p) {
                case DYNAMIC: {
                    return "dynamic";
                }
            }
            return "static";
        }
        return "static";
    }
}

