/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.base.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.fx.core.ExceptionHandler;
import org.eclipse.jdt.annotation.NonNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true)
public class UncaughtExceptionSupport {
    private List<ExceptionHandler> handlers = new ArrayList<ExceptionHandler>();

    public UncaughtExceptionSupport() {
        Thread.setDefaultUncaughtExceptionHandler(this::handleException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleException(Thread t, Throwable e) {
        ExceptionHandler[] handlers;
        List<ExceptionHandler> list = this.handlers;
        synchronized (list) {
            handlers = this.handlers.toArray(new ExceptionHandler[0]);
        }
        ExceptionDataImpl d = new ExceptionDataImpl(e);
        ExceptionHandler[] exceptionHandlerArray = handlers;
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            ExceptionHandler h = exceptionHandlerArray[n2];
            h.handleException((ExceptionHandler.ExceptionData)d);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void registerExceptionHandler(ExceptionHandler handler) {
        List<ExceptionHandler> list = this.handlers;
        synchronized (list) {
            this.handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterExceptionHandler(ExceptionHandler handler) {
        List<ExceptionHandler> list = this.handlers;
        synchronized (list) {
            this.handlers.remove(handler);
        }
    }

    static class ExceptionDataImpl
    implements ExceptionHandler.ExceptionData {
        private final @NonNull Throwable e;

        public ExceptionDataImpl(@NonNull Throwable e) {
            this.e = e;
        }

        public @NonNull String sourceClass() {
            return this.e.getStackTrace()[0].getClassName();
        }

        public @NonNull Throwable throwable() {
            return this.e;
        }
    }
}

