/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.eclipse.fx.core.OSGiUtil;
import org.eclipse.fx.core.RankedService;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.framework.FrameworkUtil;

public class Util {
    private static Boolean isOSGi;
    private static Map<Class<?>, ServiceLoader<?>> LOADER_CACHE;

    static {
        LOADER_CACHE = new HashMap();
    }

    public static boolean isFX2() {
        return System.getProperty("javafx.version") != null && System.getProperty("javafx.version").startsWith("2");
    }

    public static @NonNull String notNull(@Nullable String value, @NonNull String defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static boolean isOsgiEnv() {
        if (isOSGi == null) {
            isOSGi = Boolean.FALSE;
            try {
                Class.forName("org.osgi.framework.FrameworkUtil");
                if (FrameworkUtil.getBundle(Util.class) != null) {
                    isOSGi = Boolean.TRUE;
                }
            }
            catch (Throwable throwable) {}
        }
        return isOSGi;
    }

    private static <S> @Nullable S _lookupService(@Nullable Class<?> requestor, @NonNull Class<S> serviceClass) {
        List<@NonNull S> _lookupServiceList = Util._lookupServiceList(requestor, serviceClass);
        if (!_lookupServiceList.isEmpty()) {
            return _lookupServiceList.get(0);
        }
        return null;
    }

    private static <S> ServiceLoader<S> getLoader(Class<S> clazz) {
        ServiceLoader<Object> l = LOADER_CACHE.get(clazz);
        if (l == null) {
            l = ServiceLoader.load(clazz);
            LOADER_CACHE.put(clazz, l);
        }
        return l;
    }

    private static <S> @NonNull List<@NonNull S> _lookupServiceList(@Nullable Class<?> requestor, @NonNull Class<S> serviceClass) {
        if (Util.isOsgiEnv()) {
            return OSGiUtil.lookupServiceList(requestor, serviceClass);
        }
        ServiceLoader<S> serviceLoader = Util.getLoader(serviceClass);
        Iterator<S> iterator = serviceLoader.iterator();
        ArrayList<S> rv = new ArrayList<S>();
        while (iterator.hasNext()) {
            rv.add(iterator.next());
        }
        Collections.sort(rv, (o1, o2) -> {
            if (o1 instanceof RankedService && o2 instanceof RankedService) {
                return -1 * Integer.compare(((RankedService)o1).getRanking(), ((RankedService)o2).getRanking());
            }
            return 0;
        });
        return rv;
    }

    public static <S> @Nullable S lookupService(@NonNull Class<?> requestor, @NonNull Class<S> serviceClass) {
        return Util._lookupService(requestor, serviceClass);
    }

    public static <S> @Nullable S lookupService(@NonNull Class<S> serviceClass) {
        return Util._lookupService(null, serviceClass);
    }

    public static <S> @NonNull List<@NonNull S> lookupServiceList(@NonNull Class<?> requestor, @NonNull Class<S> serviceClass) {
        return Util._lookupServiceList(requestor, serviceClass);
    }

    public static <S> @NonNull List<@NonNull S> lookupServiceList(@NonNull Class<S> serviceClass) {
        return Util._lookupServiceList(null, serviceClass);
    }

    public static String slurpFileContent(Path path) throws IOException {
        byte[] buf = new byte[(int)Files.size(path)];
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            in.read(buf);
            return new String(buf);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String readToString(InputStream in, Charset charset) {
        return Util.readToString(in, 1024, charset);
    }

    public static String readToString(InputStream in, int bufferLength, Charset charset) {
        StringBuilder b = new StringBuilder();
        char[] buf = new char[bufferLength];
        InputStreamReader r = new InputStreamReader(in, charset);
        try {
            int l;
            while ((l = r.read(buf, 0, bufferLength)) != -1) {
                b.append(buf, 0, l);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return b.toString();
    }
}

