/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.impl;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.resource.IResourceDescriptions;

public class ResourceDescriptionsProvider {
    public static final String NAMED_BUILDER_SCOPE = "org.eclipse.xtext.scoping.namespaces.DefaultGlobalScopeProvider.BUILDER_SCOPE";
    public static final String LIVE_SCOPE = "org.eclipse.xtext.scoping.LIVE_SCOPE";
    public static final String PERSISTED_DESCRIPTIONS = "org.eclipse.xtext.builder.impl.PersistentDataAwareDirtyResource.PERSISTED_DESCRIPTIONS";
    @Inject
    @Named(value="org.eclipse.xtext.scoping.namespaces.DefaultGlobalScopeProvider.BUILDER_SCOPE")
    private Provider<IResourceDescriptions> builderScopeResourceDescriptions;
    @Inject
    @Named(value="org.eclipse.xtext.scoping.LIVE_SCOPE")
    private Provider<IResourceDescriptions> liveScopeResourceDescriptions;
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.builder.impl.PersistentDataAwareDirtyResource.PERSISTED_DESCRIPTIONS")
    private Provider<IResourceDescriptions> persistedResourceDescriptions;
    @Inject
    private Provider<IResourceDescriptions> resourceDescriptions;

    public IResourceDescriptions getResourceDescriptions(Resource resource) {
        return this.getResourceDescriptions(resource.getResourceSet());
    }

    public IResourceDescriptions getResourceDescriptions(ResourceSet resourceSet) {
        String flag = this.getFlagFromLoadOptions(resourceSet);
        IResourceDescriptions result = NAMED_BUILDER_SCOPE.equals(flag) ? this.createBuilderScopeResourceDescriptions() : (LIVE_SCOPE.equals(flag) ? this.createLiveScopeResourceDescriptions() : (PERSISTED_DESCRIPTIONS.equals(flag) ? this.createPersistedResourceDescriptions() : this.createResourceDescriptions()));
        if (result instanceof IResourceDescriptions.IContextAware) {
            ((IResourceDescriptions.IContextAware)result).setContext((Notifier)resourceSet);
        }
        return result;
    }

    private String getFlagFromLoadOptions(ResourceSet resourceSet) {
        Map loadOptions = resourceSet.getLoadOptions();
        String[] mutualExclusiveFlags = new String[]{NAMED_BUILDER_SCOPE, LIVE_SCOPE, PERSISTED_DESCRIPTIONS};
        String result = null;
        int i = 0;
        while (i < mutualExclusiveFlags.length) {
            String candidate = mutualExclusiveFlags[i];
            if (loadOptions.containsKey(candidate)) {
                if (result == null) {
                    result = candidate;
                } else {
                    String msg = "Ambiguous scope for the resource set. Can't combine " + result + " and " + candidate;
                    throw new IllegalStateException(msg);
                }
            }
            ++i;
        }
        return result;
    }

    public IResourceDescriptions createLiveScopeResourceDescriptions() {
        return (IResourceDescriptions)this.liveScopeResourceDescriptions.get();
    }

    public IResourceDescriptions createBuilderScopeResourceDescriptions() {
        return (IResourceDescriptions)this.builderScopeResourceDescriptions.get();
    }

    public IResourceDescriptions createResourceDescriptions() {
        return (IResourceDescriptions)this.resourceDescriptions.get();
    }

    public IResourceDescriptions createPersistedResourceDescriptions() {
        if (this.persistedResourceDescriptions == null) {
            throw new IllegalStateException("Language does not provide persisted descriptions.");
        }
        return (IResourceDescriptions)this.persistedResourceDescriptions.get();
    }

    public void setBuilderScopeResourceDescriptions(Provider<IResourceDescriptions> resourceDescriptions) {
        this.builderScopeResourceDescriptions = resourceDescriptions;
    }

    public void setResourceDescriptions(Provider<IResourceDescriptions> resourceDescriptions) {
        this.resourceDescriptions = resourceDescriptions;
    }

    public void setLiveScopeResourceDescriptions(Provider<IResourceDescriptions> liveScopeResourceDescriptions) {
        this.liveScopeResourceDescriptions = liveScopeResourceDescriptions;
    }

    public void setPersistedResourceDescriptions(Provider<IResourceDescriptions> persistedResourceDescriptions) {
        this.persistedResourceDescriptions = persistedResourceDescriptions;
    }
}

