/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.servlet;

import java.io.IOException;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.servlet.internal.context.DispatchTargets;
import org.eclipse.equinox.http.servlet.internal.servlet.HttpServletRequestBuilder;
import org.eclipse.equinox.http.servlet.internal.servlet.HttpServletResponseWrapperImpl;
import org.eclipse.equinox.http.servlet.internal.servlet.ResponseStateHandler;

public class NamedDispatcherAdaptor
implements RequestDispatcher {
    private final DispatchTargets dispatchTargets;

    public NamedDispatcherAdaptor(DispatchTargets dispatchTargets) {
        this.dispatchTargets = dispatchTargets;
    }

    public void forward(ServletRequest req, ServletResponse resp) throws IOException, ServletException {
        if (req instanceof HttpServletRequestBuilder.RequestGetter) {
            req = ((HttpServletRequestBuilder.RequestGetter)req).getOriginalRequest();
        }
        this.doDispatch((HttpServletRequest)req, (HttpServletResponse)resp);
    }

    public void include(ServletRequest req, ServletResponse resp) throws IOException, ServletException {
        if (req instanceof HttpServletRequestBuilder.RequestGetter) {
            req = ((HttpServletRequestBuilder.RequestGetter)req).getOriginalRequest();
        }
        this.doDispatch((HttpServletRequest)req, (HttpServletResponse)resp);
    }

    private void doDispatch(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        DispatcherType dispatcherType = DispatcherType.REQUEST;
        if (request.getAttribute("javax.servlet.include.request_uri") != null) {
            request.setAttribute("javax.servlet.include.request_uri", (Object)request.getRequestURI());
            request.setAttribute("javax.servlet.include.context_path", (Object)this.dispatchTargets.getContextController().getContextPath());
            request.setAttribute("javax.servlet.include.servlet_path", (Object)this.dispatchTargets.getServletPath());
            request.setAttribute("javax.servlet.include.path_info", (Object)this.dispatchTargets.getPathInfo());
            dispatcherType = DispatcherType.INCLUDE;
        }
        HttpServletRequest wrappedRequest = new HttpServletRequestBuilder(request, this.dispatchTargets).build();
        HttpServletResponseWrapperImpl wrapperResponse = new HttpServletResponseWrapperImpl(response);
        ResponseStateHandler responseStateHandler = new ResponseStateHandler(wrappedRequest, (HttpServletResponse)wrapperResponse, this.dispatchTargets, dispatcherType);
        responseStateHandler.processRequest();
    }
}

