/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.internal.transfer.gles;

import com.sun.prism.Texture;
import org.eclipse.fx.drift.Vec2i;
import org.eclipse.fx.drift.internal.GL;
import org.eclipse.fx.drift.internal.GraphicsPipelineUtil;
import org.eclipse.fx.drift.internal.SYS;
import org.eclipse.fx.drift.internal.transfer.SharedTexture;

public class GLESMainMemorySharedTexture
extends SharedTexture {
    private Vec2i size;
    int glTexture;
    long memPointer;
    int memSize;
    private long pointer;

    public GLESMainMemorySharedTexture(Vec2i size) {
        this.size = size;
        this.pointer = this.nCreate();
    }

    @Override
    protected void allocate() {
        this.glTexture = GL.glGenTexture();
        GL.glBindTexture(3553, this.glTexture);
        GL.glTexImage2D(3553, 0, 6408, this.size.x, this.size.y, 0, 32993, 5121, 0L);
        GL.glBindTexture(3553, 0);
        this.memSize = this.size.x * this.size.y * 4;
        this.memPointer = SYS.malloc(this.memSize);
    }

    @Override
    protected void release() {
        GL.glDeleteTexture(this.glTexture);
        SYS.free(this.memPointer);
    }

    @Override
    protected void onAcquire() {
    }

    @Override
    protected void onPresent() {
        this.downloadToMemoryBuf(this.glTexture, this.memSize, this.memPointer);
    }

    private void downloadToMemorySimple(int tex, long pPixels) {
        int format = 6408;
        GL.glBindTexture(3553, this.glTexture);
        GL.glGetTexImage(3553, 0, format, 33639, this.memPointer);
        GL.glBindTexture(3553, 0);
    }

    private void downloadToMemoryBuf(int tex, int size, long pPixels) {
        int buf = GL.glGenBuffer();
        GL.glBindBuffer(35051, buf);
        GL.glBufferData(35051, size, 0L, 35045);
        int format = 6408;
        GL.glBindTexture(3553, tex);
        GL.glGetTexImage(3553, 0, format, 33639, 0L);
        GL.glBindTexture(3553, 0);
        long glBuf = GL.glMapBuffer(35051, 35000);
        SYS.memcpy(pPixels, glBuf, size);
        GL.glUnmapBuffer(35051);
        GL.glBindBuffer(35051, 0);
        GL.glDeleteBuffer(buf);
    }

    @Override
    protected void OnTextureCreated(Texture texture) {
        int targetTex = GraphicsPipelineUtil.ES2.getTextureName(texture);
        this.uploadTexture(targetTex, this.width, this.height, this.memPointer, this.memSize);
    }

    private void uploadTexture(int targetTex, int width, int height, long pPixels, int size) {
        GL.glBindTexture(3553, targetTex);
        GL.glTexImage2D(3553, 0, 32856, width, height, 0, 6408, 33639, pPixels);
        GL.glBindTexture(3553, 0);
    }

    private native long nCreate();

    private native void nDispose(long var1);
}

