/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.spec.application.lifecycle;

import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class InnerEndpoint
extends Endpoint
implements MessageHandler.Whole<String> {
    protected String receivedMessage = "";
    protected CountDownLatch latch;
    private Session session;

    public InnerEndpoint(CountDownLatch latch) {
        this.latch = latch;
    }

    public void onOpen(Session session, EndpointConfig config) {
        session.addMessageHandler((MessageHandler)this);
        this.session = session;
    }

    public void onMessage(String message) {
        this.receivedMessage = this.receivedMessage + message;
        this.latch.countDown();
    }

    public String getReceivedMessage() {
        return this.receivedMessage;
    }

    public void sendMessage(String message) {
        try {
            this.session.getBasicRemote().sendText(message);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void await(long seconds) {
        try {
            this.latch.await(seconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

