/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.server;

import com.sun.ts.tests.websocket.common.stringbean.StringBeanBinaryDecoder;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanBinaryStreamDecoder;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanTextDecoder;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanTextStreamDecoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.common.LinkedListHashSetTextDecoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.common.StringListTextDecoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.common.TypeEnum;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.server.WSCServerEndpoint;
import jakarta.websocket.Decoder;
import jakarta.websocket.Endpoint;
import jakarta.websocket.server.ServerApplicationConfig;
import jakarta.websocket.server.ServerEndpointConfig;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class AppConfig
implements ServerApplicationConfig {
    public Set<ServerEndpointConfig> getEndpointConfigs(Set<Class<? extends Endpoint>> endpointClasses) {
        HashSet<ServerEndpointConfig> set = new HashSet<ServerEndpointConfig>();
        this.addServerEndpoint(set, LinkedListHashSetTextDecoder.class, TypeEnum.LINKEDLIST_HASHSET_TEXT);
        this.addServerEndpoint(set, StringListTextDecoder.class, TypeEnum.LIST_TEXT);
        this.addServerEndpoint(set, StringBeanTextDecoder.class, TypeEnum.STRINGBEAN);
        this.addServerEndpoint(set, StringBeanTextStreamDecoder.class, TypeEnum.STRINGBEANSTREAM);
        this.addServerEndpoint(set, StringBeanBinaryDecoder.class, TypeEnum.STRINGBEANBINARY);
        this.addServerEndpoint(set, StringBeanBinaryStreamDecoder.class, TypeEnum.STRINGBEANBINARYSTREAM);
        this.addServerEndpoint(set, null, TypeEnum.STRING_WHOLE);
        this.addServerEndpoint(set, null, TypeEnum.STRING_PARTIAL);
        this.addServerEndpoint(set, null, TypeEnum.PONG);
        this.addServerEndpoint(set, null, TypeEnum.BYTEBUFFER_WHOLE);
        this.addServerEndpoint(set, null, TypeEnum.BYTEARRAY_WHOLE);
        this.addServerEndpoint(set, null, TypeEnum.BYTEBUFFER_PARTIAL);
        this.addServerEndpoint(set, null, TypeEnum.BYTEARRAY_PARTIAL);
        this.addServerEndpoint(set, null, TypeEnum.INPUTSTREAM);
        this.addServerEndpoint(set, null, TypeEnum.READER);
        return set;
    }

    private Set<ServerEndpointConfig> addServerEndpoint(Set<ServerEndpointConfig> set, Class<? extends Decoder> decoder, final TypeEnum typeEnum) {
        LinkedList<Class<? extends Decoder>> decoders = new LinkedList<Class<? extends Decoder>>();
        decoders.add(decoder);
        ServerEndpointConfig.Configurator configurator = new ServerEndpointConfig.Configurator(){

            public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
                return (T)((Object)new WSCServerEndpoint(typeEnum));
            }
        };
        ServerEndpointConfig.Builder builder = ServerEndpointConfig.Builder.create(WSCServerEndpoint.class, (String)("/" + typeEnum.name().toLowerCase()));
        if (decoder != null) {
            builder = builder.decoders(decoders);
        }
        ServerEndpointConfig config = builder.configurator(configurator).build();
        set.add(config);
        return set;
    }

    public Set<Class<?>> getAnnotatedEndpointClasses(Set<Class<?>> scanned) {
        return scanned;
    }
}

