/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.api.jakarta_servlet.jsp.tagext.jspidconsumer;

import ee.jakarta.tck.pages.api.jakarta_servlet.jsp.tagext.jspidconsumer.MultiOneTag;
import ee.jakarta.tck.pages.api.jakarta_servlet.jsp.tagext.jspidconsumer.MultiThreeTag;
import ee.jakarta.tck.pages.api.jakarta_servlet.jsp.tagext.jspidconsumer.MultiTwoTag;
import ee.jakarta.tck.pages.api.jakarta_servlet.jsp.tagext.jspidconsumer.SameJspIdTag;
import ee.jakarta.tck.pages.api.jakarta_servlet.jsp.tagext.jspidconsumer.SetJspIdTag;
import ee.jakarta.tck.pages.common.client.AbstractUrlClient;
import ee.jakarta.tck.pages.common.util.JspTestUtil;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends AbstractUrlClient {
    public URLClientIT() throws Exception {
        this.setContextRoot("/jsp_jspidconsumer_web");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        String packagePath = URLClientIT.class.getPackageName().replace(".", "/");
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_jspidconsumer_web.war");
        archive.addClasses(new Class[]{MultiOneTag.class, MultiTwoTag.class, MultiThreeTag.class, SameJspIdTag.class, SetJspIdTag.class, JspTestUtil.class});
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_jspidconsumer_web.xml"));
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/jspidconsumer.tld", "jspidconsumer.tld");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/SetJspIdTest.jsp")), "SetJspIdTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/MultipleJspIdTest.jsp")), "MultipleJspIdTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/SameJspIdTest.jsp")), "SameJspIdTest.jsp");
        return archive;
    }

    @Test
    public void setJspIdTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_jspidconsumer_web/SetJspIdTest.jsp HTTP 1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
    }

    @Test
    public void multipleJspIdTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_jspidconsumer_web/MultipleJspIdTest.jsp HTTP 1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
    }

    @Test
    public void sameJspIdTest() throws Exception {
        for (int i = 1; i < 5; ++i) {
            TEST_PROPS.setProperty("request", "GET /jsp_jspidconsumer_web/SameJspIdTest.jsp HTTP 1.1");
            TEST_PROPS.setProperty("ignore_status_code", "true");
            TEST_PROPS.setProperty("ignore_body", "true");
            this.invoke();
        }
        TEST_PROPS.setProperty("request", "GET /jsp_jspidconsumer_web/SameJspIdTest.jsp HTTP 1.1");
        TEST_PROPS.setProperty("ignore_status_code", "false");
        TEST_PROPS.setProperty("ignore_body", "false");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
    }
}

