/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.api.jakarta_servlet.jsp.jspwriter;

import ee.jakarta.tck.pages.api.jakarta_servlet.jsp.jspwriter.JspWriterValidator;
import ee.jakarta.tck.pages.common.client.AbstractUrlClient;
import ee.jakarta.tck.pages.common.util.JspTestUtil;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends AbstractUrlClient {
    private static final char[] CHARS = new char[89];
    private static final String EOL = "#eol#";
    private static final String JSP_WRITER_VALIDATOR = "ee.jakarta.tck.pages.api.jakarta_servlet.jsp.jspwriter.JspWriterValidator";

    public URLClientIT() throws Exception {
        int i = 33;
        int idx = 0;
        while (i < 90) {
            URLClientIT.CHARS[idx] = (char)i;
            i = (short)(i + 1);
            idx = (short)(idx + 1);
        }
        this.setContextRoot("/jsp_jspwriter_web");
        this.setTestJsp("JspWriterTest");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        String packagePath = URLClientIT.class.getPackageName().replace(".", "/");
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_jspwriter_web.war");
        archive.addClasses(new Class[]{JspWriterValidator.class, JspTestUtil.class});
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_jspwriter_web.xml"));
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspWriterTest.jsp")), "JspWriterTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/CloseValidator.jsp")), "CloseValidator.jsp");
        return archive;
    }

    @Test
    public void jspWriterNewLineTest() throws Exception {
        TEST_PROPS.setProperty("apitest1", "jspWriterNewLineTest");
        TEST_PROPS.setProperty("strategy", JSP_WRITER_VALIDATOR);
        TEST_PROPS.setProperty("search_string", "new line#eol#");
        this.invoke();
    }

    @Test
    public void jspWriterPrintBooleanTest() throws Exception {
        TEST_PROPS.setProperty("apitest1", "jspWriterPrintBooleanTest");
        TEST_PROPS.setProperty("search_string", "truefalse");
        this.invoke();
    }

    @Test
    public void jspWriterPrintCharTest() throws Exception {
        TEST_PROPS.setProperty("apitest1", "jspWriterPrintCharTest");
        TEST_PROPS.setProperty("search_string", "cb");
        this.invoke();
    }

    @Test
    public void jspWriterPrintIntTest() throws Exception {
        String result = new StringBuffer().append(Integer.MIN_VALUE).append(Integer.MAX_VALUE).toString();
        TEST_PROPS.setProperty("apitest1", "jspWriterPrintIntTest");
        TEST_PROPS.setProperty("search_string", result);
        this.invoke();
    }

    @Test
    public void jspWriterPrintLongTest() throws Exception {
        String result = new StringBuffer().append(Long.MIN_VALUE).append(Long.MAX_VALUE).toString();
        TEST_PROPS.setProperty("apitest1", "jspWriterPrintLongTest");
        TEST_PROPS.setProperty("search_string", result);
        this.invoke();
    }

    @Test
    public void jspWriterPrintFloatTest() throws Exception {
        String result = new StringBuffer().append(Float.MIN_VALUE).append(Float.MAX_VALUE).toString();
        TEST_PROPS.setProperty("apitest1", "jspWriterPrintFloatTest");
        TEST_PROPS.setProperty("search_string", result);
        this.invoke();
    }

    @Test
    public void jspWriterPrintDoubleTest() throws Exception {
        String result = new StringBuffer().append((double)Double.MIN_VALUE).append((double)Double.MAX_VALUE).toString();
        TEST_PROPS.setProperty("apitest1", "jspWriterPrintDoubleTest");
        TEST_PROPS.setProperty("search_string", result);
        this.invoke();
    }

    @Test
    public void jspWriterPrintCharArrayTest() throws Exception {
        String result = new StringBuffer().append(CHARS).append(CHARS).toString();
        TEST_PROPS.setProperty("apitest1", "jspWriterPrintCharArrayTest");
        TEST_PROPS.setProperty("search_string", result);
        this.invoke();
    }

    @Test
    public void jspWriterPrintStringTest() throws Exception {
        TEST_PROPS.setProperty("apitest1", "jspWriterPrintStringTest");
        TEST_PROPS.setProperty("search_string", "Test Passed");
        this.invoke();
    }

    @Test
    public void jspWriterPrintNullStringTest() throws Exception {
        TEST_PROPS.setProperty("apitest1", "jspWriterPrintNullStringTest");
        TEST_PROPS.setProperty("search_string", "null");
        this.invoke();
    }

    @Test
    public void jspWriterPrintObjectTest() throws Exception {
        TEST_PROPS.setProperty("apitest1", "jspWriterPrintObjectTest");
        TEST_PROPS.setProperty("search_string", "Test Passed");
        this.invoke();
    }

    @Test
    public void jspWriterPrintlnTest() throws Exception {
        TEST_PROPS.setProperty("apitest1", "jspWriterPrintlnTest");
        TEST_PROPS.setProperty("strategy", JSP_WRITER_VALIDATOR);
        TEST_PROPS.setProperty("search_string", "Test Passed#eol#");
        this.invoke();
    }

    @Test
    public void jspWriterPrintlnBooleanTest() throws Exception {
        TEST_PROPS.setProperty("apitest1", "jspWriterPrintlnBooleanTest");
        TEST_PROPS.setProperty("strategy", JSP_WRITER_VALIDATOR);
        TEST_PROPS.setProperty("search_string", "true#eol#false#eol#");
        this.invoke();
    }

    @Test
    public void jspWriterPrintlnCharTest() throws Exception {
        TEST_PROPS.setProperty("apitest1", "jspWriterPrintlnCharTest");
        TEST_PROPS.setProperty("strategy", JSP_WRITER_VALIDATOR);
        TEST_PROPS.setProperty("search_string", "a#eol#B#eol#");
        this.invoke();
    }

    @Test
    public void jspWriterPrintlnIntTest() throws Exception {
        String result = new StringBuffer().append(Integer.MIN_VALUE).append(EOL).append(Integer.MAX_VALUE).append(EOL).toString();
        TEST_PROPS.setProperty("strategy", JSP_WRITER_VALIDATOR);
        TEST_PROPS.setProperty("apitest1", "jspWriterPrintlnIntTest");
        TEST_PROPS.setProperty("search_string", result);
        this.invoke();
    }

    @Test
    public void jspWriterPrintlnLongTest() throws Exception {
        String result = new StringBuffer().append(Long.MIN_VALUE).append(EOL).append(Long.MAX_VALUE).append(EOL).toString();
        TEST_PROPS.setProperty("apitest1", "jspWriterPrintlnLongTest");
        TEST_PROPS.setProperty("strategy", JSP_WRITER_VALIDATOR);
        TEST_PROPS.setProperty("search_string", result);
        this.invoke();
    }

    @Test
    public void jspWriterPrintlnFloatTest() throws Exception {
        String result = new StringBuffer().append(Float.MIN_VALUE).append(EOL).append(Float.MAX_VALUE).append(EOL).toString();
        TEST_PROPS.setProperty("apitest1", "jspWriterPrintlnFloatTest");
        TEST_PROPS.setProperty("strategy", JSP_WRITER_VALIDATOR);
        TEST_PROPS.setProperty("search_string", result);
        this.invoke();
    }

    @Test
    public void jspWriterPrintlnDoubleTest() throws Exception {
        String result = new StringBuffer().append((double)Double.MIN_VALUE).append(EOL).append((double)Double.MAX_VALUE).append(EOL).toString();
        TEST_PROPS.setProperty("apitest1", "jspWriterPrintlnDoubleTest");
        TEST_PROPS.setProperty("strategy", JSP_WRITER_VALIDATOR);
        TEST_PROPS.setProperty("search_string", result);
        this.invoke();
    }

    @Test
    public void jspWriterPrintlnCharArrayTest() throws Exception {
        String result = new StringBuffer().append(CHARS).append(EOL).append(CHARS).append(EOL).toString();
        TEST_PROPS.setProperty("apitest1", "jspWriterPrintlnCharArrayTest");
        TEST_PROPS.setProperty("strategy", JSP_WRITER_VALIDATOR);
        TEST_PROPS.setProperty("search_string", result);
        this.invoke();
    }

    @Test
    public void jspWriterPrintlnStringTest() throws Exception {
        String result = new StringBuffer().append("Test ").append(EOL).append("Passed").append(EOL).toString();
        TEST_PROPS.setProperty("apitest1", "jspWriterPrintlnStringTest");
        TEST_PROPS.setProperty("strategy", JSP_WRITER_VALIDATOR);
        TEST_PROPS.setProperty("search_string", result);
        this.invoke();
    }

    @Test
    public void jspWriterPrintlnNullStringTest() throws Exception {
        TEST_PROPS.setProperty("apitest1", "jspWriterPrintlnNullStringTest");
        TEST_PROPS.setProperty("search_string", "null");
        this.invoke();
    }

    @Test
    public void jspWriterPrintlnObjectTest() throws Exception {
        String result = new StringBuffer().append("Test ").append(EOL).append("Passed").append(EOL).toString();
        TEST_PROPS.setProperty("apitest1", "jspWriterPrintlnObjectTest");
        TEST_PROPS.setProperty("strategy", JSP_WRITER_VALIDATOR);
        TEST_PROPS.setProperty("search_string", result);
        this.invoke();
    }

    @Test
    public void jspWriterClearTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "jspWriterClearTest");
        this.invoke();
    }

    @Test
    public void jspWriterClearIOExceptionTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "jspWriterClearIOExceptionTest");
        this.invoke();
    }

    @Test
    public void jspWriterClearBufferTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "jspWriterClearBufferTest");
        this.invoke();
    }

    @Test
    public void jspWriterFlushTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "jspWriterFlushTest");
        this.invoke();
    }

    @Test
    public void jspWriterCloseTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_jspwriter_web/JspWriterTest.jsp?testname=jspWriterCloseTest HTTP/1.1");
        TEST_PROPS.setProperty("ignore_status_code", "true");
        TEST_PROPS.setProperty("unexpected_response_match", "Test FAILED");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_jspwriter_web/CloseValidator.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
    }

    @Test
    public void jspWriterGetBufferSizeTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "jspWriterGetBufferSizeTest");
        this.invoke();
    }

    @Test
    public void jspWriterGetRemainingTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "jspWriterGetRemainingTest");
        this.invoke();
    }

    @Test
    public void jspWriterIsAutoFlushTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "jspWriterIsAutoFlushTest");
        this.invoke();
    }
}

