/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.common.schema30;

import com.sun.ts.tests.jpa.common.schema30.ShelfLife;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.SecondaryTable;
import jakarta.persistence.SecondaryTables;
import jakarta.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name="PRODUCT_TABLE")
@SecondaryTables(value={@SecondaryTable(name="PRODUCT_DETAILS", pkJoinColumns={@PrimaryKeyJoinColumn(name="ID")})})
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="PRODUCT_TYPE", discriminatorType=DiscriminatorType.STRING)
@DiscriminatorValue(value="Product")
public class Product
implements Serializable,
Comparable<Product> {
    private String id;
    private String name;
    private double price;
    private int quantity;
    private long partNumber;
    private String wareHouse;
    private ShelfLife shelfLife;

    public Product() {
    }

    public Product(String id, String name, double price, int quantity, long partNumber) {
        this.id = id;
        this.name = name;
        this.price = price;
        this.quantity = quantity;
        this.partNumber = partNumber;
    }

    @Id
    @Column(name="ID")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Column(name="NAME")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="PRICE")
    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    @Column(name="QUANTITY")
    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int v) {
        this.quantity = v;
    }

    @Column(name="PNUM")
    public long getPartNumber() {
        return this.partNumber;
    }

    public void setPartNumber(long v) {
        this.partNumber = v;
    }

    @Column(name="WHOUSE", nullable=true, table="PRODUCT_DETAILS")
    public String getWareHouse() {
        return this.wareHouse;
    }

    public void setWareHouse(String v) {
        this.wareHouse = v;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="inceptionDate", column=@Column(name="INCEPTION", nullable=true)), @AttributeOverride(name="soldDate", column=@Column(name="SOLD", nullable=true))})
    public ShelfLife getShelfLife() {
        return this.shelfLife;
    }

    public void setShelfLife(ShelfLife v) {
        this.shelfLife = v;
    }

    public boolean equals(Object o) {
        boolean same = true;
        if (!(o instanceof Product)) {
            return false;
        }
        Product other = (Product)o;
        return same &= this.id.equals(other.id);
    }

    public int hashCode() {
        int myHash = this.id.hashCode();
        return myHash;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("id: " + this.getId());
        result.append(", name: " + this.getName());
        result.append(", price: " + this.getPrice());
        result.append(", quantity: " + this.getQuantity());
        result.append(", partNumber: " + this.getPartNumber());
        result.append(", wareHouse: " + this.getWareHouse());
        result.append("]");
        return result.toString();
    }

    @Override
    public int compareTo(Product p) {
        int lastCmp = Integer.valueOf(this.getId()).compareTo(Integer.valueOf(p.getId()));
        return lastCmp != 0 ? lastCmp : Integer.valueOf(this.getId()).compareTo(Integer.valueOf(p.getId()));
    }
}

