/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.config.serverbeans.JaccProvider;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.SecurityLoggerInfo;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.security.auth.Policy;
import org.glassfish.hk2.api.IterableProvider;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.Property;

@Service
@Singleton
public class PolicyLoader {
    @Inject
    @Named(value="default-instance-name")
    private SecurityService securityService;
    @Inject
    private IterableProvider<JaccProvider> jaccProviders;
    private static Logger _logger = null;
    private static StringManager sm;
    private static final String POLICY_PROVIDER_14 = "javax.security.jacc.policy.provider";
    private static final String POLICY_PROVIDER_13 = "javax.security.jacc.auth.policy.provider";
    private static final String POLICY_CONF_FACTORY = "javax.security.jacc.PolicyConfigurationFactory.provider";
    private static final String POLICY_PROP_PREFIX = "com.sun.enterprise.jaccprovider.property.";
    private boolean isPolicyInstalled = false;

    public void loadPolicy() {
        if (this.isPolicyInstalled) {
            _logger.log(Level.FINE, "Policy already installed. Will not re-install.");
            return;
        }
        JaccProvider jacc = this.getConfiguredJaccProvider();
        this.setPolicyConfigurationFactory(jacc);
        boolean j2ee13 = false;
        String javaPolicy = System.getProperty(POLICY_PROVIDER_14);
        if (javaPolicy != null) {
            _logger.log(Level.INFO, "NCLS-SECURITY-01140", new String[]{POLICY_PROVIDER_14, javaPolicy});
        } else if (jacc != null) {
            javaPolicy = jacc.getPolicyProvider();
        }
        if (javaPolicy == null && (javaPolicy = System.getProperty(POLICY_PROVIDER_13)) != null) {
            j2ee13 = true;
            _logger.log(Level.WARNING, "NCLS-SECURITY-01149", new String[]{POLICY_PROVIDER_13, javaPolicy});
        }
        if (javaPolicy != null) {
            try {
                _logger.log(Level.INFO, "NCLS-SECURITY-01143", javaPolicy);
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> javaPolicyClass = loader.loadClass(javaPolicy);
                Object obj = javaPolicyClass.newInstance();
                if (j2ee13) {
                    if (!(obj instanceof Policy)) {
                        String msg = sm.getString("enterprise.security.plcyload.not13");
                        throw new RuntimeException(msg);
                    }
                    Policy policy = (Policy)obj;
                    Policy.setPolicy((Policy)policy);
                    policy.refresh();
                } else {
                    if (!(obj instanceof java.security.Policy)) {
                        String msg = sm.getString("enterprise.security.plcyload.not14");
                        throw new RuntimeException(msg);
                    }
                    java.security.Policy policy = (java.security.Policy)obj;
                    java.security.Policy.setPolicy(policy);
                    if (System.getSecurityManager() == null) {
                        policy.refresh();
                    }
                }
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "NCLS-SECURITY-01144", e.getLocalizedMessage());
                throw new RuntimeException(e);
            }
            _logger.fine("Policy set to: " + javaPolicy);
            this.isPolicyInstalled = true;
        } else {
            _logger.warning("NCLS-SECURITY-01145");
        }
    }

    private JaccProvider getConfiguredJaccProvider() {
        JaccProvider jacc = null;
        try {
            String name = this.securityService.getJacc();
            jacc = this.getJaccProviderByName(name);
            if (jacc == null) {
                _logger.log(Level.WARNING, "NCLS-SECURITY-01141", name);
            }
        }
        catch (Exception e) {
            _logger.warning("NCLS-SECURITY-01142");
            jacc = null;
        }
        return jacc;
    }

    private JaccProvider getJaccProviderByName(String name) {
        if (this.jaccProviders == null || name == null) {
            return null;
        }
        for (JaccProvider jaccProvider : this.jaccProviders) {
            if (!jaccProvider.getName().equals(name)) continue;
            return jaccProvider;
        }
        return null;
    }

    private void setPolicyConfigurationFactory(JaccProvider jacc) {
        if (jacc == null) {
            return;
        }
        String prop = System.getProperty(POLICY_CONF_FACTORY);
        if (prop != null) {
            _logger.log(Level.WARNING, "NCLS-SECURITY-01146", new String[]{POLICY_CONF_FACTORY, prop});
        } else {
            String factory = jacc.getPolicyConfigurationFactoryProvider();
            if (factory == null) {
                _logger.log(Level.WARNING, "NCLS-SECURITY-01147");
            } else {
                System.setProperty(POLICY_CONF_FACTORY, factory);
            }
        }
        List props = jacc.getProperty();
        for (Property p : props) {
            String name = POLICY_PROP_PREFIX + p.getName();
            String value = p.getValue();
            _logger.finest("PolicyLoader set [" + name + "] to [" + value + "]");
            System.setProperty(name, value);
        }
    }

    static {
        _logger = SecurityLoggerInfo.getLogger();
        sm = StringManager.getManager(PolicyLoader.class);
    }
}

