/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleLifecycleListener;
import com.sun.enterprise.module.ModuleState;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.common_impl.CompositeEnumeration;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.kernel.KernelLoggerInfo;
import org.jvnet.hk2.annotations.Service;

@Service
public class APIClassLoaderServiceImpl
implements PostConstruct {
    private ClassLoader theAPIClassLoader;
    @Inject
    ModulesRegistry mr;
    private static final String APIExporterModuleName = "GlassFish-Application-Common-Module";
    private static final String MAILCAP = "META-INF/mailcap";
    private static final String META_INF_SERVICES = "META-INF/services/";
    private static final String PUNCHIN_MODULE_STATE_PROP = "glassfish.kernel.apicl.punchin.module.state";
    public final ModuleState PUNCHIN_MODULE_STATE_DEFAULT_VALUE = ModuleState.NEW;
    private static final Enumeration<URL> EMPTY_URLS = new Enumeration<URL>(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public URL nextElement() {
            throw new NoSuchElementException();
        }
    };
    static final Logger logger = KernelLoggerInfo.getLogger();
    private Module APIModule;

    public void postConstruct() {
        try {
            this.createAPIClassLoader();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void createAPIClassLoader() throws IOException {
        this.APIModule = (Module)this.mr.getModules(APIExporterModuleName).iterator().next();
        assert (this.APIModule != null);
        ClassLoader apiModuleLoader = this.APIModule.getClassLoader();
        this.theAPIClassLoader = new APIClassLoader(apiModuleLoader, this.getExtensionClassLoader());
        logger.logp(Level.FINE, "APIClassLoaderService", "createAPIClassLoader", "APIClassLoader = {0}", new Object[]{this.theAPIClassLoader});
    }

    private ClassLoader getExtensionClassLoader() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return ClassLoader.getSystemClassLoader().getParent();
                }
            });
        }
        return ClassLoader.getSystemClassLoader().getParent();
    }

    public ClassLoader getAPIClassLoader() {
        return this.theAPIClassLoader;
    }

    private class APIClassLoader
    extends ClassLoader {
        private Set<String> blacklist;
        private final ClassLoader apiModuleLoader;
        private ModuleState punchInModuleState;

        public APIClassLoader(ClassLoader apiModuleLoader, ClassLoader parent) {
            super(parent);
            this.punchInModuleState = ModuleState.valueOf((String)System.getProperty(APIClassLoaderServiceImpl.PUNCHIN_MODULE_STATE_PROP, APIClassLoaderServiceImpl.this.PUNCHIN_MODULE_STATE_DEFAULT_VALUE.toString()));
            this.apiModuleLoader = apiModuleLoader;
            this.blacklist = new HashSet<String>();
            APIClassLoaderServiceImpl.this.mr.register(new ModuleLifecycleListener(){

                public void moduleInstalled(Module module) {
                    APIClassLoader.this.clearBlackList();
                }

                public void moduleResolved(Module module) {
                }

                public void moduleStarted(Module module) {
                }

                public void moduleStopped(Module module) {
                }

                public void moduleUpdated(Module module) {
                    APIClassLoader.this.clearBlackList();
                }
            });
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            return this.loadClass(name, false);
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            String resourceName = this.convertToResourceName(name);
            if (this.isBlackListed(resourceName)) {
                throw new ClassNotFoundException(name);
            }
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                block9: {
                    if (!name.startsWith("java.")) {
                        try {
                            c = this.apiModuleLoader.loadClass(name);
                        }
                        catch (ClassNotFoundException cnfe) {
                            Module m = APIClassLoaderServiceImpl.this.mr.getProvidingModule(name);
                            if (m == null) break block9;
                            if (this.select(m)) {
                                return m.getClassLoader().loadClass(name);
                            }
                            logger.logp(Level.FINE, "APIClassLoaderServiceImpl$APIClassLoader", "loadClass", "Skipping loading {0} from module {1} as this module is not yet resolved.", new Object[]{name, m});
                        }
                    }
                }
                if (c == null) {
                    try {
                        c = super.loadClass(name, resolve);
                    }
                    catch (ClassNotFoundException e) {
                        this.addToBlackList(resourceName);
                        throw e;
                    }
                }
            }
            return c;
        }

        private boolean select(Module m) {
            ModuleState state = m.getState();
            return state.compareTo((Enum)this.punchInModuleState) >= 0 && state != ModuleState.ERROR;
        }

        @Override
        public URL getResource(String name) {
            if (this.isBlackListed(name)) {
                return null;
            }
            URL url = null;
            if (!name.startsWith("java/")) {
                url = this.apiModuleLoader.getResource(name);
                if (url != null) {
                    return url;
                }
                if (name.equals(APIClassLoaderServiceImpl.MAILCAP)) {
                    for (Module m : APIClassLoaderServiceImpl.this.mr.getModules()) {
                        if (!this.select(m) || (url = m.getClassLoader().getResource(name)) == null) continue;
                        return url;
                    }
                } else if (name.startsWith(APIClassLoaderServiceImpl.META_INF_SERVICES)) {
                    String serviceName = name.substring(APIClassLoaderServiceImpl.META_INF_SERVICES.length());
                    for (Module m : APIClassLoaderServiceImpl.this.mr.getModules()) {
                        List list;
                        if (!this.select(m) || (list = m.getMetadata().getDescriptors(serviceName)).isEmpty()) continue;
                        return (URL)list.get(0);
                    }
                }
            }
            if ((url = super.getResource(name)) == null) {
                this.addToBlackList(name);
            }
            return url;
        }

        private ClassLoader getParent_() {
            if (System.getSecurityManager() != null) {
                return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return APIClassLoader.this.getParent();
                    }
                });
            }
            return this.getParent();
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            ArrayList<Enumeration<URL>> enumerators = new ArrayList<Enumeration<URL>>();
            enumerators.add(this.findResources(name));
            if (this.getParent_() != null) {
                enumerators.add(this.getParent_().getResources(name));
            }
            return new CompositeEnumeration(enumerators);
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            if (!name.startsWith("java/")) {
                ArrayList enumerations = new ArrayList();
                Enumeration<URL> apiResources = this.apiModuleLoader.getResources(name);
                if (apiResources.hasMoreElements()) {
                    enumerations.add(apiResources);
                }
                if (name.equals(APIClassLoaderServiceImpl.MAILCAP)) {
                    for (Module m : APIClassLoaderServiceImpl.this.mr.getModules()) {
                        if (!this.select(m) || m == APIClassLoaderServiceImpl.this.APIModule) continue;
                        enumerations.add(m.getClassLoader().getResources(name));
                    }
                } else if (name.startsWith(APIClassLoaderServiceImpl.META_INF_SERVICES)) {
                    String serviceName = name.substring(APIClassLoaderServiceImpl.META_INF_SERVICES.length());
                    ArrayList punchedInURLs = new ArrayList();
                    for (Module m : APIClassLoaderServiceImpl.this.mr.getModules()) {
                        if (!this.select(m) || m == APIClassLoaderServiceImpl.this.APIModule) continue;
                        punchedInURLs.addAll(m.getMetadata().getDescriptors(serviceName));
                    }
                    if (!punchedInURLs.isEmpty()) {
                        enumerations.add(Collections.enumeration(punchedInURLs));
                    }
                }
                switch (enumerations.size()) {
                    case 0: {
                        return EMPTY_URLS;
                    }
                    case 1: {
                        return (Enumeration)enumerations.get(0);
                    }
                }
                return new CompositeEnumeration(enumerations);
            }
            return EMPTY_URLS;
        }

        public String toString() {
            return "APIClassLoader";
        }

        private String convertToResourceName(String className) {
            return className.replace('.', '/').concat(".class");
        }

        private synchronized boolean isBlackListed(String name) {
            return this.blacklist.contains(name);
        }

        private synchronized void addToBlackList(String name) {
            this.blacklist.add(name);
        }

        private synchronized void clearBlackList() {
            this.blacklist.clear();
        }
    }
}

