/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.servlet.SessionCookieConfig;
import org.apache.catalina.LogFacade;
import org.apache.catalina.core.StandardContext;

public class SessionCookieConfigImpl
implements SessionCookieConfig {
    private String name;
    private String domain;
    private String path;
    private String comment;
    private boolean httpOnly = true;
    private boolean secure;
    private StandardContext ctx;
    private int maxAge = -1;
    private static final ResourceBundle rb = LogFacade.getLogger().getResourceBundle();

    public SessionCookieConfigImpl(StandardContext ctx) {
        this.ctx = ctx;
    }

    public void setName(String name) {
        if (this.ctx.isContextInitializedCalled()) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00129"), "name", this.ctx.getName());
            throw new IllegalStateException(msg);
        }
        this.name = name;
        this.ctx.setSessionCookieName(name);
    }

    public String getName() {
        return this.name;
    }

    public void setDomain(String domain) {
        if (this.ctx.isContextInitializedCalled()) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00129"), "dnmain", this.ctx.getName());
            throw new IllegalStateException(msg);
        }
        this.domain = domain;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setPath(String path) {
        if (this.ctx.isContextInitializedCalled()) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00129"), "path", this.ctx.getName());
            throw new IllegalStateException(msg);
        }
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setComment(String comment) {
        if (this.ctx.isContextInitializedCalled()) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00129"), "comment", this.ctx.getName());
            throw new IllegalStateException(msg);
        }
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public void setHttpOnly(boolean httpOnly) {
        if (this.ctx.isContextInitializedCalled()) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00129"), "httpOnly", this.ctx.getName());
            throw new IllegalStateException(msg);
        }
        this.httpOnly = httpOnly;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public void setSecure(boolean secure) {
        if (this.ctx.isContextInitializedCalled()) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00129"), "secure", this.ctx.getName());
            throw new IllegalStateException(msg);
        }
        this.secure = secure;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setMaxAge(int maxAge) {
        if (this.ctx.isContextInitializedCalled()) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00129"), "maxAge", this.ctx.getName());
            throw new IllegalStateException(msg);
        }
        this.maxAge = maxAge;
    }

    public int getMaxAge() {
        return this.maxAge;
    }
}

