/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.LogFacade;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ApplicationDispatcher;
import org.apache.catalina.core.RequestFacadeHelper;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.util.ResponseUtil;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ErrorReportValve;
import org.glassfish.web.util.HtmlEntityEncoder;

class ApplicationDispatcherForward {
    private static final Logger log = LogFacade.getLogger();
    private static final ResourceBundle rb = log.getResourceBundle();
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.valves");

    ApplicationDispatcherForward() {
    }

    static void commit(ServletRequest request, ServletResponse response, Context context, Wrapper wrapper) throws IOException, ServletException {
        boolean matchFound;
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            ApplicationDispatcherForward.closeResponse(response);
            return;
        }
        HttpServletRequest hreq = (HttpServletRequest)request;
        HttpServletResponse hres = (HttpServletResponse)response;
        int statusCode = hres.getStatus();
        Object exception = hreq.getAttribute("javax.servlet.error.exception");
        String errorReportValveClass = ((StandardHost)context.getParent()).getErrorReportValveClass();
        boolean hasErrorReportValve = errorReportValveClass != null && errorReportValveClass.length() > 0;
        RequestFacadeHelper reqFacHelper = RequestFacadeHelper.getInstance(request);
        if (hasErrorReportValve && reqFacHelper != null && reqFacHelper.isResponseError() && statusCode >= 400 && exception == null && !(matchFound = ApplicationDispatcherForward.status(hreq, hres, context, wrapper, statusCode))) {
            String initParam;
            boolean isDefaultErrorPageEnabled = true;
            if (wrapper != null && (initParam = wrapper.findInitParameter("org.glassfish.web.isDefaultErrorPageEnabled")) != null) {
                isDefaultErrorPageEnabled = Boolean.parseBoolean(initParam);
            }
            if (isDefaultErrorPageEnabled) {
                ApplicationDispatcherForward.serveDefaultErrorPage(hreq, hres, statusCode);
            }
        }
        if (statusCode < 400 || exception == null && hasErrorReportValve) {
            ApplicationDispatcherForward.closeResponse(response);
        }
    }

    private static boolean status(HttpServletRequest request, HttpServletResponse response, Context context, Wrapper wrapper, int statusCode) {
        RequestFacadeHelper reqFacHelper = RequestFacadeHelper.getInstance((ServletRequest)request);
        if (reqFacHelper == null || !reqFacHelper.isResponseError()) {
            return false;
        }
        boolean matchFound = false;
        ErrorPage errorPage = context.findErrorPage(statusCode);
        if (errorPage != null) {
            matchFound = true;
            String requestPath = (String)request.getAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH");
            if (requestPath == null || !requestPath.equals(errorPage.getLocation())) {
                String message = reqFacHelper.getResponseMessage();
                message = message == null ? "" : HtmlEntityEncoder.encodeXSS((String)message);
                ApplicationDispatcherForward.prepareRequestForDispatch(request, wrapper, errorPage.getLocation(), statusCode, message);
                ApplicationDispatcherForward.custom(request, response, errorPage, context);
            }
        } else {
            errorPage = ((StandardHost)context.getParent()).findErrorPage(statusCode);
            if (errorPage != null) {
                matchFound = true;
                try {
                    ApplicationDispatcherForward.serveErrorPage(response, errorPage, statusCode);
                }
                catch (Exception e) {
                    String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00095"), errorPage);
                    log.log(Level.WARNING, msg, e);
                }
            }
        }
        return matchFound;
    }

    private static void custom(HttpServletRequest request, HttpServletResponse response, ErrorPage errorPage, Context context) {
        try {
            RequestFacadeHelper reqFacHelper;
            if (response.isCommitted() && (reqFacHelper = RequestFacadeHelper.getInstance((ServletRequest)request)) != null) {
                reqFacHelper.resetResponse();
            }
            ServletContext servletContext = context.getServletContext();
            ApplicationDispatcher dispatcher = (ApplicationDispatcher)servletContext.getRequestDispatcher(errorPage.getLocation());
            dispatcher.dispatch((ServletRequest)request, (ServletResponse)response, DispatcherType.ERROR);
        }
        catch (IllegalStateException ise) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00095"), errorPage);
            log.log(Level.WARNING, msg, ise);
        }
        catch (Throwable t) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00095"), errorPage);
            log.log(Level.WARNING, msg, t);
        }
    }

    private static void prepareRequestForDispatch(HttpServletRequest request, Wrapper errorServlet, String errorPageLocation, int errorCode, String errorMessage) {
        request.setAttribute("javax.servlet.error.request_uri", (Object)request.getRequestURI());
        if (errorServlet != null) {
            request.setAttribute("javax.servlet.error.servlet_name", (Object)errorServlet.getName());
        }
        request.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", (Object)errorPageLocation);
        request.setAttribute("javax.servlet.error.status_code", (Object)errorCode);
        request.setAttribute("javax.servlet.error.message", (Object)errorMessage);
    }

    private static void serveErrorPage(HttpServletResponse response, ErrorPage errorPage, int statusCode) throws Exception {
        ServletOutputStream ostream = null;
        PrintWriter writer = null;
        FileReader reader = null;
        BufferedInputStream istream = null;
        IOException ioe = null;
        String message = errorPage.getReason();
        if (message != null && !response.isCommitted()) {
            response.reset();
            response.setStatus(statusCode, message);
        }
        try {
            ostream = response.getOutputStream();
        }
        catch (IllegalStateException e) {
            writer = response.getWriter();
        }
        if (writer != null) {
            reader = new FileReader(errorPage.getLocation());
            ioe = ResponseUtil.copy(reader, writer);
            try {
                reader.close();
            }
            catch (Throwable throwable) {}
        } else {
            istream = new BufferedInputStream(new FileInputStream(errorPage.getLocation()));
            ioe = ResponseUtil.copy(istream, ostream);
            try {
                istream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    private static void serveDefaultErrorPage(HttpServletRequest request, HttpServletResponse response, int statusCode) throws IOException, ServletException {
        RequestFacadeHelper reqFacHelper = RequestFacadeHelper.getInstance((ServletRequest)request);
        if (response.isCommitted() || statusCode < 400 || reqFacHelper != null && reqFacHelper.getResponseContentCount() > 0 || Boolean.TRUE.equals(request.getAttribute("org.glassfish.jsp.error_handled"))) {
            return;
        }
        String message = null;
        if (reqFacHelper != null) {
            message = reqFacHelper.getResponseMessage();
        }
        message = message == null ? "" : HtmlEntityEncoder.encodeXSS((String)message);
        String report = null;
        try {
            report = sm.getString("http." + statusCode, message);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (report == null) {
            return;
        }
        String responseContents = ErrorReportValve.makeErrorPage(statusCode, message, null, null, report, response);
        response.setLocale(sm.getResourceBundleLocale(response.getLocale()));
        try {
            response.setContentType("text/html");
            response.getWriter().write(responseContents);
        }
        catch (Throwable t) {
            log.log(Level.WARNING, "AS-WEB-CORE-00096", t);
        }
    }

    private static void closeResponse(ServletResponse response) {
        try {
            PrintWriter writer = response.getWriter();
            writer.flush();
            writer.close();
        }
        catch (IllegalStateException e) {
            try {
                ServletOutputStream stream = response.getOutputStream();
                stream.flush();
                stream.close();
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (IOException iOException) {}
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

