/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.util.LocalStringManagerImpl;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.container.Sniffer;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.deployment.SnifferManager;
import org.jvnet.hk2.annotations.Service;

@Service(name="_is-sniffer-user-visible")
@ExecuteOn(value={RuntimeType.DAS})
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=Application.class, opType=RestEndpoint.OpType.GET, path="is-sniffer-user-visible", description="Is Sniffer User Visible")})
@AccessRequired(resource={"domain/sniffers/$sniffername"}, action={"read"})
public class IsSnifferUserVisibleCommand
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(IsSnifferUserVisibleCommand.class);
    @Param(primary=true)
    public String sniffername = null;
    @Inject
    SnifferManager snifferManager;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        ActionReport.MessagePart part = report.getTopMessagePart();
        Sniffer sniffer = this.snifferManager.getSniffer(this.sniffername);
        if (sniffer != null) {
            String isVisible = String.valueOf(sniffer.isUserVisible());
            part.addProperty("isSnifferUserVisible", isVisible);
            part.setMessage(isVisible);
        }
    }
}

