/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.servlet.api.javax_servlet.sessiontrackingmode;

import com.sun.ts.tests.servlet.common.servlets.GenericTCKServlet;
import com.sun.ts.tests.servlet.common.util.ServletTestUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SessionTrackingMode;

public class TestServlet
extends GenericTCKServlet {
    public void setSessionTrackingModes(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = true;
        PrintWriter pw = response.getWriter();
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        pw.println((String)context.getAttribute("LOG"));
        HashSet<SessionTrackingMode> expected_modes = new HashSet<SessionTrackingMode>();
        String expected = (String)context.getAttribute("MODES");
        StringTokenizer str = new StringTokenizer(expected, ";");
        while (str.hasMoreTokens()) {
            String mode = str.nextToken();
            pw.println("Expected SessionTrackingMode =" + mode);
            if (mode.equals(SessionTrackingMode.COOKIE.toString())) {
                expected_modes.add(SessionTrackingMode.COOKIE);
                continue;
            }
            if (mode.equals(SessionTrackingMode.SSL.toString())) continue;
            if (mode.equals(SessionTrackingMode.URL.toString())) {
                expected_modes.add(SessionTrackingMode.URL);
                continue;
            }
            passed = false;
            pw.println("Unrecogized SessionTrackingMode expected: " + mode);
        }
        Set results = null;
        results = expected_modes.isEmpty() ? context.getDefaultSessionTrackingModes() : context.getEffectiveSessionTrackingModes();
        if (!results.containsAll(expected_modes)) {
            passed = false;
            pw.append("setSessionTrackingModes and getEffectiveSessionTrackingModes retuns different set of SessionTrackingModes");
            pw.append("getEffectiveSessionTrackingModes =");
            for (SessionTrackingMode tmp : results) {
                pw.append("           " + tmp);
            }
        }
        ServletTestUtil.printResult(pw, passed);
    }
}

