/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.servlet.api.javax_servlet.requestdispatcher;

import com.sun.ts.tests.servlet.common.servlets.GenericTCKServlet;
import com.sun.ts.tests.servlet.common.util.ServletTestUtil;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class TestServlet
extends GenericTCKServlet {
    public void forwardTest(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        String path = "/ForwardedServlet";
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
        rd.forward(request, response);
    }

    public void forward_1Test(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = false;
        PrintWriter pw = response.getWriter();
        pw.println("Committing some content to buffer");
        pw.flush();
        String path = "/ForwardedServlet";
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
        try {
            rd.forward(request, response);
            passed = false;
            pw.println("IllegalStateException should have been generated");
        }
        catch (Throwable t) {
            if (t instanceof IllegalStateException) {
                passed = true;
            }
            passed = false;
            pw.println("Exception thrown, but was not an instance of IllegalStateException.");
            pw.println("instead received: " + t.getClass().getName());
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void includeTest(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        String path = "/ForwardedServlet";
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
        rd.include(request, response);
    }

    public void include_1Test(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        response.setContentType("text/sgml");
        String path = "/IncludedServlet";
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
        rd.include(request, response);
    }

    public void include_2Test(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = false;
        PrintWriter pw = response.getWriter();
        String path = "/ForwardedServlet2";
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
        try {
            rd.include(request, response);
            passed = false;
            pw.println("ServletException should have been generated");
        }
        catch (Throwable t) {
            if (t instanceof ServletException) {
                passed = true;
            }
            passed = false;
            pw.println("Exception thrown, but was not an instance of ServletException.");
            pw.println("instead received: " + t.getClass().getName());
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void include_3Test(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = false;
        PrintWriter pw = response.getWriter();
        String path = "/ForwardedServlet3";
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
        try {
            rd.include(request, response);
            passed = false;
            pw.println("IOException should have been generated");
        }
        catch (Throwable t) {
            if (t instanceof IOException) {
                passed = true;
            }
            passed = false;
            pw.println("Exception thrown, but was not an instance of IOException.");
            pw.println("instead received: " + t.getClass().getName());
        }
        ServletTestUtil.printResult(pw, passed);
    }
}

