/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.servlet.api.javax_servlet.servletconfig;

import com.sun.ts.tests.servlet.common.servlets.GenericTCKServlet;
import com.sun.ts.tests.servlet.common.util.ServletTestUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class TestServlet
extends GenericTCKServlet {
    public void getServletConfigInitParameterNames(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = true;
        PrintWriter pw = response.getWriter();
        ServletConfig config = this.getServletConfig();
        Enumeration initP = config.getInitParameterNames();
        String expectedResult1 = "Team";
        boolean expectedResult1Found = false;
        String expectedResult2 = "org";
        boolean expectedResult2Found = false;
        if (initP.hasMoreElements()) {
            while (initP.hasMoreElements()) {
                String name = (String)initP.nextElement();
                pw.println("Initialization Parameter: " + name);
                if (name.equals(expectedResult1)) {
                    if (!expectedResult1Found) {
                        expectedResult1Found = true;
                        continue;
                    }
                    passed = false;
                    pw.println("getInitParameterNames() method return an attribute name twice");
                    pw.println("The attribute already specified was " + expectedResult1);
                    continue;
                }
                if (!name.equals(expectedResult2)) continue;
                if (!expectedResult2Found) {
                    expectedResult2Found = true;
                    continue;
                }
                passed = false;
                pw.println("getInitParameterNames() method return an attribute name twice");
                pw.println("The attribute already specified was " + expectedResult2);
            }
            if (!expectedResult1Found && expectedResult2Found) {
                passed = false;
                pw.println("At least one InitParameter is not returned");
            }
        } else {
            passed = false;
            pw.println("HttpServletRequest.getInitParameterNames() an empty enumeration");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void getServletConfigInitParameter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = false;
        PrintWriter pw = response.getWriter();
        ServletConfig config = this.getServletConfig();
        String initParam = config.getInitParameter("Team");
        if (initParam != null) {
            if (initParam.equals("WebAccess")) {
                passed = true;
            } else {
                passed = false;
                pw.println("getInitParameter(String) gives incorrect results");
                pw.println("getInitParameter(String) != 'WebAccess' as specified in web.xml for GetServletConfigInitParameterTest servlet");
            }
        } else {
            passed = false;
            pw.println("getInitParameter(String) is null");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void getServletConfigInitParameterNull(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = false;
        PrintWriter pw = response.getWriter();
        ServletConfig config = this.getServletConfig();
        String initParam = config.getInitParameter("Nothing_is_set_for_Negative_compatibility_test_only");
        if (initParam != null) {
            pw.println("getInitParameter(String) gives incorrect results");
            pw.println("Expecting null; got " + initParam);
        } else {
            passed = true;
            pw.println("getInitParameter(String) is null");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void getServletName(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = false;
        PrintWriter pw = response.getWriter();
        ServletConfig config = this.getServletConfig();
        String expected = "TestServlet";
        String servletName = config.getServletName();
        if (servletName.indexOf(expected) > -1) {
            passed = true;
        } else {
            passed = false;
            pw.println("getServletName() did not return the correct result:");
            pw.println("Expected Result=" + expected);
            pw.println("Actual Result -> " + servletName);
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void getServletContext(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = false;
        PrintWriter pw = response.getWriter();
        String anotherServlet = "/servlet_js_servletconfig_web/TestServlet";
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        ServletContext context2 = context.getContext(anotherServlet);
        if (context2 == context) {
            passed = true;
        } else {
            passed = true;
            pw.println("getServletContext() returned incorrect result");
        }
        ServletTestUtil.printResult(pw, passed);
    }
}

