/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.extras.addons;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.config.ConfigAwareElement;
import org.glassfish.grizzly.config.dom.Http;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.http.ajp.AjpAddOn;
import org.glassfish.grizzly.http.server.AddOn;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.annotations.Service;

@Service(name="ajp")
@ContractsProvided(value={AjpAddOnProvider.class, AddOn.class})
public class AjpAddOnProvider
extends AjpAddOn
implements ConfigAwareElement<Http> {
    protected static final Logger _logger = Logger.getLogger("javax.enterprise.web");

    public void configure(ServiceLocator habitat, NetworkListener networkListener, Http http) {
        boolean jkSupportEnabled;
        boolean bl = jkSupportEnabled = http.getJkEnabled() != null ? Boolean.parseBoolean(http.getJkEnabled()) : Boolean.parseBoolean(networkListener.getJkEnabled());
        if (jkSupportEnabled) {
            String jkPropertiesFilename = Boolean.parseBoolean(http.getJkEnabled()) ? http.getJkConfigurationFile() : networkListener.getJkConfigurationFile();
            File propertiesFile = null;
            if (jkPropertiesFilename != null) {
                propertiesFile = new File(jkPropertiesFilename);
            }
            String systemPropertyFilename = System.getProperty("com.sun.enterprise.web.connector.enableJK.propertyFile");
            if (!(propertiesFile != null && propertiesFile.exists() || systemPropertyFilename == null)) {
                propertiesFile = new File(systemPropertyFilename);
            }
            if (propertiesFile == null) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("jk properties configuration file not defined");
                }
                return;
            }
            if (!propertiesFile.exists()) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "jk properties configuration file ''{0}'' doesn't exist", propertiesFile.getAbsoluteFile());
                }
                return;
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "Loading glassfish-jk.properties from {0}", propertiesFile.getAbsolutePath());
            }
            Properties properties = null;
            InputStream is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(propertiesFile));
                properties = new Properties();
                properties.load(is);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.configure(properties);
        }
    }
}

