/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.utils.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.utils.properties.ConfigurationHandler;
import org.apache.felix.utils.properties.InterpolationHelper;
import org.apache.felix.utils.properties.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedProperties
extends AbstractMap<String, Object> {
    public static final String ENV_PREFIX = "env:";
    private final Properties storage = new Properties(false);
    private final SubstitutionCallback callback;
    private final boolean substitute;

    public TypedProperties() {
        this(null, true);
    }

    public TypedProperties(boolean substitute) {
        this(null, substitute);
    }

    public TypedProperties(SubstitutionCallback callback) {
        this(callback, true);
    }

    public TypedProperties(SubstitutionCallback callback, boolean substitute) {
        this.callback = callback;
        this.substitute = substitute;
    }

    public void load(File location) throws IOException {
        FileInputStream is = new FileInputStream(location);
        try {
            this.load(is);
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public void load(URL location) throws IOException {
        InputStream is = location.openStream();
        try {
            this.load(is);
        }
        finally {
            is.close();
        }
    }

    public void load(InputStream is) throws IOException {
        this.load(new InputStreamReader(is, "ISO-8859-1"));
    }

    public void load(Reader reader) throws IOException {
        this.storage.loadLayout(reader, true);
        this.substitute(this.callback);
    }

    public void save(File location) throws IOException {
        this.storage.save(location);
    }

    public void save(OutputStream os) throws IOException {
        this.storage.save(os);
    }

    public void save(Writer writer) throws IOException {
        this.storage.save(writer);
    }

    public void store(OutputStream os, String comment) throws IOException {
        this.storage.store(os, comment);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return new AbstractSet<Map.Entry<String, Object>>(){

            @Override
            public Iterator<Map.Entry<String, Object>> iterator() {
                return new Iterator<Map.Entry<String, Object>>(){
                    final Iterator<String> keyIterator;
                    {
                        this.keyIterator = TypedProperties.this.storage.keySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.keyIterator.hasNext();
                    }

                    @Override
                    public Map.Entry<String, Object> next() {
                        final String key = this.keyIterator.next();
                        return new Map.Entry<String, Object>(){

                            @Override
                            public String getKey() {
                                return key;
                            }

                            @Override
                            public Object getValue() {
                                return TypedProperties.this.get(key);
                            }

                            @Override
                            public Object setValue(Object value) {
                                return TypedProperties.this.put(key, value);
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        this.keyIterator.remove();
                    }
                };
            }

            @Override
            public int size() {
                return TypedProperties.this.storage.size();
            }
        };
    }

    @Override
    public Object put(String key, Object value) {
        if (value instanceof String && !this.storage.typed) {
            return this.storage.put(key, (String)value);
        }
        this.ensureTyped();
        String old = this.storage.put(key, TypedProperties.convertToString(value));
        return old != null ? TypedProperties.convertFromString(old) : null;
    }

    @Override
    public Object get(Object key) {
        String v = (String)this.storage.get(key);
        return this.storage.typed && v != null ? TypedProperties.convertFromString(v) : v;
    }

    public Object put(String key, List<String> commentLines, Object value) {
        if (value instanceof String && !this.storage.typed) {
            return this.storage.put(key, commentLines, (String)value);
        }
        this.ensureTyped();
        return this.put(key, commentLines, Arrays.asList(TypedProperties.convertToString(value).split("\n")));
    }

    public Object put(String key, String comment, Object value) {
        return this.put(key, Collections.singletonList(comment), value);
    }

    public Object put(String key, List<String> commentLines, List<String> valueLines) {
        String old = this.storage.put(key, commentLines, valueLines);
        return old != null ? (this.storage.typed ? TypedProperties.convertFromString(old) : old) : null;
    }

    private void ensureTyped() {
        if (!this.storage.typed) {
            this.storage.typed = true;
            HashSet keys = new HashSet(this.storage.keySet());
            for (String key : keys) {
                this.storage.put(key, this.storage.getComments(key), Arrays.asList(TypedProperties.convertToString(this.storage.get(key)).split("\n")));
            }
        }
    }

    public boolean update(Map<String, Object> props) {
        TypedProperties properties;
        if (props instanceof TypedProperties) {
            properties = (TypedProperties)props;
        } else {
            properties = new TypedProperties();
            for (Map.Entry<String, Object> e : props.entrySet()) {
                properties.put(e.getKey(), e.getValue());
            }
        }
        return this.update(properties);
    }

    public boolean update(TypedProperties properties) {
        return this.storage.update(properties.storage);
    }

    public List<String> getRaw(String key) {
        return this.storage.getRaw(key);
    }

    public List<String> getComments(String key) {
        return this.storage.getComments(key);
    }

    @Override
    public Object remove(Object key) {
        return this.storage.remove(key);
    }

    @Override
    public void clear() {
        this.storage.clear();
    }

    public List<String> getHeader() {
        return this.storage.getHeader();
    }

    public void setHeader(List<String> header) {
        this.storage.setHeader(header);
    }

    public List<String> getFooter() {
        return this.storage.getFooter();
    }

    public void setFooter(List<String> footer) {
        this.storage.setFooter(footer);
    }

    public void substitute(SubstitutionCallback cb) {
        if (!this.substitute) {
            return;
        }
        SubstitutionCallback callback = cb != null ? cb : new SubstitutionCallback(){

            public String getValue(String name, String key, String value) {
                if (value.startsWith(TypedProperties.ENV_PREFIX)) {
                    return System.getenv(value.substring(TypedProperties.ENV_PREFIX.length()));
                }
                return System.getProperty(value);
            }
        };
        Map<String, TypedProperties> props = Collections.singletonMap("root", this);
        TypedProperties.substitute(props, TypedProperties.prepare(props), callback, true);
    }

    private static SubstitutionCallback wrap(final InterpolationHelper.SubstitutionCallback cb) {
        return new SubstitutionCallback(){

            public String getValue(String name, String key, String value) {
                return cb.getValue(value);
            }
        };
    }

    public static Map<String, Map<String, String>> prepare(Map<String, TypedProperties> properties) {
        HashMap<String, Map<String, String>> dynamic = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, TypedProperties> entry : properties.entrySet()) {
            String name = entry.getKey();
            dynamic.put(name, new DynamicMap(name, entry.getValue().storage));
        }
        return dynamic;
    }

    public static void substitute(Map<String, TypedProperties> properties, Map<String, Map<String, String>> dynamic, SubstitutionCallback callback, boolean finalSubstitution) {
        for (Map<String, String> map : dynamic.values()) {
            ((DynamicMap)map).init(callback, finalSubstitution);
        }
        for (Map.Entry entry : properties.entrySet()) {
            ((TypedProperties)entry.getValue()).storage.putAllSubstituted(dynamic.get(entry.getKey()));
        }
    }

    private static String convertToString(Object value) {
        try {
            return ConfigurationHandler.write(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Object convertFromString(String value) {
        try {
            return ConfigurationHandler.read(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DynamicMap
    extends AbstractMap<String, String> {
        private final String name;
        private final Properties storage;
        private final Map<String, String> computed;
        private final Map<String, String> cycles;
        private SubstitutionCallback callback;
        private boolean finalSubstitution;

        public DynamicMap(String name, Properties storage) {
            this.name = name;
            this.storage = storage;
            this.computed = new HashMap<String, String>();
            this.cycles = new HashMap<String, String>();
        }

        public void init(SubstitutionCallback callback, boolean finalSubstitution) {
            this.callback = callback;
            this.finalSubstitution = finalSubstitution;
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return new AbstractSet<Map.Entry<String, String>>(){

                @Override
                public Iterator<Map.Entry<String, String>> iterator() {
                    final Iterator iterator = DynamicMap.this.storage.keySet().iterator();
                    return new Iterator<Map.Entry<String, String>>(){

                        @Override
                        public boolean hasNext() {
                            return iterator.hasNext();
                        }

                        @Override
                        public Map.Entry<String, String> next() {
                            final String key = (String)iterator.next();
                            return new Map.Entry<String, String>(){

                                @Override
                                public String getKey() {
                                    return key;
                                }

                                @Override
                                public String getValue() {
                                    String v = (String)DynamicMap.this.computed.get(key);
                                    if (v == null) {
                                        v = DynamicMap.this.compute(key);
                                    }
                                    return v;
                                }

                                @Override
                                public String setValue(String value) {
                                    throw new UnsupportedOperationException();
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return DynamicMap.this.storage.size();
                }
            };
        }

        private String compute(final String key) {
            InterpolationHelper.SubstitutionCallback wrapper = new InterpolationHelper.SubstitutionCallback(){

                public String getValue(String value) {
                    String str;
                    if (DynamicMap.this.finalSubstitution && (str = (String)DynamicMap.this.get(value)) != null) {
                        if (((DynamicMap)DynamicMap.this).storage.typed) {
                            boolean hasType;
                            boolean mult;
                            char t = str.charAt(0);
                            if (t == '[' || t == '(') {
                                mult = true;
                                hasType = false;
                            } else if (t == '\"') {
                                mult = false;
                                hasType = false;
                            } else {
                                t = str.charAt(1);
                                mult = t == '[' || t == '(';
                                hasType = true;
                            }
                            if (mult) {
                                throw new IllegalArgumentException("Can't substitute from a collection/array value: " + value);
                            }
                            return (String)TypedProperties.convertFromString(hasType ? str.substring(1) : str);
                        }
                        return str;
                    }
                    return DynamicMap.this.callback.getValue(DynamicMap.this.name, key, value);
                }
            };
            String value = (String)this.storage.get(key);
            String v = InterpolationHelper.substVars(value, key, this.cycles, this, wrapper, false, this.finalSubstitution, this.finalSubstitution);
            return v;
        }
    }

    public static interface SubstitutionCallback {
        public String getValue(String var1, String var2, String var3);
    }
}

