/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.cli;

import com.sun.enterprise.config.serverbeans.ModuleMonitoringLevels;
import com.sun.enterprise.config.serverbeans.MonitoringService;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glassfish.api.ActionReport;
import org.glassfish.api.monitoring.ContainerMonitoring;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="monitoring-config")
public class MonitoringConfig {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(MonitoringConfig.class);
    private static AtomicBoolean valueUpdated = new AtomicBoolean(false);

    static void setMonitoringEnabled(MonitoringService ms, final String enabled, ActionReport report) {
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<MonitoringService>(){

                public Object run(MonitoringService param) throws PropertyVetoException, TransactionFailure {
                    param.setMonitoringEnabled(enabled);
                    return param;
                }
            }, (ConfigBeanProxy)ms);
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("disable.monitoring.exception", "Encountered exception while setting monitoring-enabled to false {0}", new Object[]{tfe.getMessage()}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }

    static void setMBeanEnabled(MonitoringService ms, final String enabled, ActionReport report) {
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<MonitoringService>(){

                public Object run(MonitoringService param) throws PropertyVetoException, TransactionFailure {
                    param.setMbeanEnabled(enabled);
                    return param;
                }
            }, (ConfigBeanProxy)ms);
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("disable.monitoring.exception", "Encountered exception while setting mbean-enabled to false {0}", new Object[]{tfe.getMessage()}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }

    static void setDTraceEnabled(MonitoringService ms, final String enabled, ActionReport report) {
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<MonitoringService>(){

                public Object run(MonitoringService param) throws PropertyVetoException, TransactionFailure {
                    param.setDtraceEnabled(enabled);
                    return param;
                }
            }, (ConfigBeanProxy)ms);
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("disable.monitoring.exception", "Encountered exception while setting dtrace-enabled to false {0}", new Object[]{tfe.getMessage()}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }

    static void setMonitoringLevel(MonitoringService ms, final String moduleName, final String level, ActionReport report) {
        if (ms.getMonitoringLevel(moduleName) == null) {
            report.setMessage(localStrings.getLocalString("invalid.module", "Invalid module name {0}", new Object[]{moduleName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<MonitoringService>(){

                public Object run(MonitoringService param) throws PropertyVetoException, TransactionFailure {
                    param.setMonitoringLevel(moduleName, level);
                    return null;
                }
            }, (ConfigBeanProxy)ms);
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("monitoring.config.exception", "Encountered exception {0} while setting monitoring level to {1} for {2}", new Object[]{tfe.getMessage(), level, moduleName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }

    static void setMonitoringLevelX(MonitoringService ms, final String moduleName, final String level, ActionReport report) {
        ModuleMonitoringLevels mmls = ms.getModuleMonitoringLevels();
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ModuleMonitoringLevels>(){

                public Object run(ModuleMonitoringLevels param) throws PropertyVetoException, TransactionFailure {
                    Dom dom = Dom.unwrap((ConfigBeanProxy)param);
                    String currentVal = dom.attribute(moduleName);
                    if (currentVal == null) {
                        valueUpdated.set(false);
                        return null;
                    }
                    dom.attribute(moduleName, level);
                    return param;
                }
            }, (ConfigBeanProxy)mmls);
        }
        catch (TransactionFailure tfe) {
            valueUpdated.set(false);
            report.setMessage(localStrings.getLocalString("disable.monitoring.level", "Encountered exception {0} while setting monitoring level to OFF for {1}", new Object[]{tfe.getMessage(), moduleName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        if (!valueUpdated.get()) {
            MonitoringConfig.setContainerMonitoringLevel(ms, moduleName, level, report);
        }
    }

    static boolean setContainerMonitoringLevel(MonitoringService ms, String moduleName, final String level, ActionReport report) {
        ContainerMonitoring cm = ms.getContainerMonitoring(moduleName);
        if (cm == null) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            ActionReport.MessagePart part = report.getTopMessagePart().addChild();
            part.setMessage(localStrings.getLocalString("invalid.module", "Invalid module name {0}", new Object[]{moduleName}));
            return false;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ContainerMonitoring>(){

                public Object run(ContainerMonitoring param) throws PropertyVetoException, TransactionFailure {
                    param.setLevel(level);
                    return param;
                }
            }, (ConfigBeanProxy)cm);
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("disable.monitoring.level", "Encountered exception {0} while setting monitoring level to OFF for {1}", new Object[]{tfe.getMessage(), moduleName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        return true;
    }
}

