/*
 * Decompiled with CFR 0.152.
 */
package com.sun.data.provider.impl;

import com.sun.data.provider.DataProviderException;
import com.sun.data.provider.FilterCriteria;
import com.sun.data.provider.RowKey;
import com.sun.data.provider.TableDataProvider;

public class NestedFilterCriteria
extends FilterCriteria {
    protected FilterCriteria[] filterCriteria;
    protected boolean matchAll = true;

    public NestedFilterCriteria() {
    }

    public NestedFilterCriteria(String displayName) {
        super(displayName);
    }

    public NestedFilterCriteria(String displayName, boolean include) {
        super(displayName, include);
    }

    public NestedFilterCriteria(String displayName, boolean include, FilterCriteria[] nested) {
        super(displayName, include);
        this.filterCriteria = nested;
    }

    public void setFilterCriteria(FilterCriteria[] filterCriteria) {
        this.filterCriteria = filterCriteria;
    }

    public FilterCriteria[] getFilterCriteria() {
        return this.filterCriteria;
    }

    public void setMatchAllCriteria(boolean matchAll) {
        this.matchAll = matchAll;
    }

    public boolean isMatchAllCriteria() {
        return this.matchAll;
    }

    public boolean match(TableDataProvider provider, RowKey row) throws DataProviderException {
        if (this.filterCriteria == null || this.filterCriteria.length == 0) {
            return true;
        }
        boolean anyAccepted = false;
        for (int i = 0; i < this.filterCriteria.length; ++i) {
            boolean accept;
            boolean match = this.filterCriteria[i].match(provider, row);
            boolean bl = this.filterCriteria[i].isInclude() ? match : (accept = !match);
            if (accept) {
                anyAccepted = true;
            }
            if (this.matchAll && !accept) {
                return false;
            }
            if (this.matchAll || !accept) continue;
            return true;
        }
        return anyAccepted;
    }
}

