/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.metamodelapi.attribute;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.metamodelapi.attribute.Order;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import java.lang.reflect.Member;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void getName() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeOrder = metaModel.managedType(Order.class);
            if (mTypeOrder != null) {
                this.logTrace("Obtained Non-null ManagedType");
                Attribute attrib = mTypeOrder.getDeclaredAttribute("total");
                if (attrib != null) {
                    this.logTrace("attribute Name = " + attrib.getName());
                    if (attrib.getName() != null) {
                        if (attrib.getName().equals("total")) {
                            this.logTrace("Received expected result:" + attrib.getName());
                            pass = true;
                        } else {
                            this.logErr("Expected: " + Attribute.PersistentAttributeType.BASIC.toString() + ", actual:" + attrib.getName());
                        }
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getName Test  failed");
        }
    }

    public void getPersistentAttributeType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeOrder = metaModel.managedType(Order.class);
            if (mTypeOrder != null) {
                this.logTrace("Obtained Non-null ManagedType");
                Attribute attrib = mTypeOrder.getDeclaredAttribute("total");
                if (attrib != null) {
                    this.logTrace("attribute Name = " + attrib.getName());
                    Attribute.PersistentAttributeType pAttribType = attrib.getPersistentAttributeType();
                    if (pAttribType == Attribute.PersistentAttributeType.BASIC) {
                        this.logTrace("Received expected result:" + String.valueOf(pAttribType));
                        pass = true;
                    } else {
                        this.logErr("Expected: " + Attribute.PersistentAttributeType.BASIC.toString() + ", actual:" + String.valueOf(pAttribType));
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getPersistentAttributeType Test  failed");
        }
    }

    public void getDeclaringType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeOrder = metaModel.managedType(Order.class);
            if (mTypeOrder != null) {
                this.logTrace("Obtained Non-null ManagedType");
                Attribute attrib = mTypeOrder.getDeclaredAttribute("total");
                if (attrib != null) {
                    this.logTrace("attribute Name = " + attrib.getName());
                    ManagedType newTypeOrder = attrib.getDeclaringType();
                    if (newTypeOrder != null) {
                        Class javaType = newTypeOrder.getJavaType();
                        if (javaType.getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.attribute.Order")) {
                            this.logTrace("Received expected result:" + javaType.getName());
                            pass = true;
                        } else {
                            this.logErr("Expected: ee.jakarta.tck.persistence.core.metamodelapi.attribute.Order, actual:" + javaType.getName());
                        }
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaringType Test  failed");
        }
    }

    public void getJavaType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeOrder = metaModel.managedType(Order.class);
            if (mTypeOrder != null) {
                this.logTrace("Obtained Non-null ManagedType");
                Attribute attrib = mTypeOrder.getDeclaredAttribute("total");
                if (attrib != null) {
                    this.logTrace("attribute JavaType = " + String.valueOf(attrib.getJavaType()));
                    Class pAttribJavaType = attrib.getJavaType();
                    if (pAttribJavaType.getName().equals("int")) {
                        this.logTrace("Received expected result:" + String.valueOf(pAttribJavaType));
                        pass = true;
                    } else {
                        this.logErr("Expected: int, actual:" + String.valueOf(pAttribJavaType));
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getJavaType Test  failed");
        }
    }

    public void getJavaMember() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeOrder = metaModel.managedType(Order.class);
            if (mTypeOrder != null) {
                this.logTrace("Obtained Non-null ManagedType");
                Attribute attrib = mTypeOrder.getDeclaredAttribute("total");
                if (attrib != null) {
                    this.logTrace("attribute JavaMember = " + attrib.getJavaMember().getName());
                    Member javaMember = attrib.getJavaMember();
                    if (javaMember.getName().equals("getTotal")) {
                        this.logTrace("Received expected result:" + javaMember.getName());
                        pass = true;
                    } else {
                        this.logErr("Expected: getTotal, actual:" + javaMember.getName());
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getJavaMember Test  failed");
        }
    }

    public void isAssociation() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeOrder = metaModel.managedType(Order.class);
            if (mTypeOrder != null) {
                this.logTrace("Obtained Non-null ManagedType");
                Attribute attrib = mTypeOrder.getDeclaredAttribute("total");
                if (attrib != null) {
                    this.logTrace("attribute IsAssociation = " + attrib.isAssociation());
                    if (!attrib.isAssociation()) {
                        this.logTrace("Received expected result:" + attrib.isAssociation());
                        pass = true;
                    } else {
                        this.logErr("Received unexpected result: " + attrib.isAssociation());
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("isAssociation Test  failed");
        }
    }

    public void isCollection() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeOrder = metaModel.managedType(Order.class);
            if (mTypeOrder != null) {
                this.logTrace("Obtained Non-null ManagedType");
                Attribute attrib = mTypeOrder.getDeclaredAttribute("total");
                if (attrib != null) {
                    this.logTrace("attribute IsCollection = " + attrib.isCollection());
                    if (!attrib.isCollection()) {
                        this.logTrace("Received expected result:" + attrib.isCollection());
                        pass = true;
                    } else {
                        this.logErr("Received unexpected result: " + attrib.isCollection());
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("isCollection Test  failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
    }
}

