/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.ee.packaging.web.standalone;

import com.sun.ts.lib.util.TSNamingContext;
import ee.jakarta.tck.persistence.ee.common.Account;
import ee.jakarta.tck.persistence.ee.util.HttpTCKServlet;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.transaction.UserTransaction;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class ServletTest
extends HttpTCKServlet {
    private static final int ACCOUNT = 1075;
    private static final int[] ACCOUNTS = new int[]{1000, 1075, 40, 30564, 387};
    private static final double[] BALANCES = new double[]{50000.0, 10490.75, 200.5, 25000.0, 1000000.0};
    private static final String emfRef = "java:comp/env/persistence/MyPersistenceUnit";
    private EntityManager entityManager;
    private EntityManagerFactory entityManagerFactory;
    private UserTransaction ut;
    private Account accountRef;
    private Map myMap = new HashMap();

    public UserTransaction getTx() {
        try {
            TSNamingContext nctx = new TSNamingContext();
            this.ut = (UserTransaction)nctx.lookup("java:comp/UserTransaction");
        }
        catch (Exception e) {
            System.out.println("Naming service exception: " + e.getMessage());
            e.printStackTrace();
        }
        return this.ut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test1(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        PrintWriter pw = res.getWriter();
        Double EXPECTED_BALANCE = 10540.75;
        try {
            this.ut = this.getTx();
            TSNamingContext nctx = new TSNamingContext();
            System.out.println("Lookup EntityManagerFactory: java:comp/env/persistence/MyPersistenceUnit");
            this.entityManagerFactory = (EntityManagerFactory)nctx.lookup(emfRef);
            System.out.println("createEntityManager with Map of Props");
            this.entityManager = this.entityManagerFactory.createEntityManager(this.myMap);
            System.out.println("Begin TX to create Entities");
            this.ut.begin();
            this.entityManager.joinTransaction();
            System.out.println("Create 5 Account Entities");
            for (int i = 0; i < ACCOUNTS.length; ++i) {
                System.out.println("Creating account=" + ACCOUNTS[i] + ", balance=" + BALANCES[i]);
                this.accountRef = new Account(ACCOUNTS[i], BALANCES[i]);
                this.entityManager.persist((Object)this.accountRef);
            }
            System.out.println("Commit TX to persist Entities");
            this.ut.commit();
            System.out.println("In next TX,  modify entity and commit");
            this.ut.begin();
            this.entityManager.joinTransaction();
            this.accountRef = (Account)this.entityManager.find(Account.class, (Object)1075);
            System.out.println("Operating on account: 1075");
            Double balance = this.accountRef.balance();
            System.out.println("Balance Before Deposit: " + balance);
            balance = this.accountRef.deposit(100.0);
            System.out.println("Balance After Deposit: " + balance);
            balance = this.accountRef.withdraw(50.0);
            System.out.println("Balance After Withdraw: " + balance);
            this.ut.commit();
            System.out.println("Retrieve Entity after commit and check balance");
            Account updatedAccount = (Account)this.entityManager.find(Account.class, (Object)1075);
            balance = updatedAccount.balance();
            if (EXPECTED_BALANCE.compareTo(balance) == 0) {
                System.out.println(" TEST PASSED. BALANCE IS: " + balance);
                pw.println("Test PASSED.  Balance of account as expected");
            } else {
                System.out.println(" TEST FAILED - Account balance is not correct.  Expected: " + EXPECTED_BALANCE + "got: " + balance);
                pw.println("Test FAILED.  ERROR: Account balance is not correct.  Expected: " + EXPECTED_BALANCE + "got: " + balance);
            }
        }
        catch (Exception e) {
            System.out.println("Unexpected exception caught in test1");
            pw.println("Test FAILED.  ERROR: Unexpected Exception caught in test1");
            e.printStackTrace();
            try {
                if (this.ut.getStatus() != 6) {
                    this.ut.rollback();
                }
            }
            catch (Exception se) {
                System.out.println("Unexpected exception caught in test1 while checking TX status ");
                se.printStackTrace();
            }
        }
        finally {
            try {
                this.ut.begin();
                this.entityManager.joinTransaction();
                for (int i = 0; i < ACCOUNTS.length; ++i) {
                    System.out.println("Removing Account Entities");
                    this.accountRef = (Account)this.entityManager.find(Account.class, (Object)ACCOUNTS[i]);
                    if (this.accountRef == null) continue;
                    this.entityManager.remove((Object)this.accountRef);
                }
                this.entityManager.close();
                this.ut.commit();
            }
            catch (Exception e) {
                System.out.println("Unexpected exception caught in test1 while cleaning up test data");
                e.printStackTrace();
                try {
                    if (this.ut.getStatus() != 6) {
                        this.ut.rollback();
                    }
                }
                catch (Exception se) {
                    System.out.println("Unexpected exception caught in test1 while checking TX status ");
                    se.printStackTrace();
                }
            }
        }
        System.out.println("Clearing cache");
        this.entityManagerFactory.getCache().evictAll();
    }
}

