/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.common.schema30;

import ee.jakarta.tck.persistence.common.schema30.Phone;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

@Entity
@Table(name="ADDRESS")
public class Address
implements Serializable {
    private String id;
    private String street;
    private String city;
    private String state;
    private String zip;
    private Collection<Phone> phones = new ArrayList<Phone>();

    public Address() {
    }

    public Address(String id, String street, String city, String state, String zip) {
        this.id = id;
        this.street = street;
        this.city = city;
        this.state = state;
        this.zip = zip;
    }

    public Address(String id, String street, String city, String state, String zip, Collection<Phone> phones) {
        this.id = id;
        this.street = street;
        this.city = city;
        this.state = state;
        this.zip = zip;
        this.phones = phones;
    }

    @Id
    @Column(name="ID")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Column(name="STREET")
    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    @Column(name="CITY")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    @Column(name="STATE")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @Column(name="ZIP")
    public String getZip() {
        return this.zip;
    }

    public void setZip(String zip) {
        this.zip = zip;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="address")
    public Collection<Phone> getPhones() {
        return this.phones;
    }

    public void setPhones(Collection<Phone> phones) {
        this.phones = phones;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("id: " + this.getId());
        result.append(", street: " + this.getStreet());
        result.append(", city: " + this.getCity());
        result.append(", state: " + this.getState());
        result.append(", zip: " + this.getZip());
        result.append("]");
        return result.toString();
    }
}

