/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.callStmt.callStmt8;

import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.csSchema;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Properties;
import javax.sql.DataSource;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class callStmtClient8
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.callStmt.callStmt8";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private DataSource ds1 = null;
    private rsSchema rsSch = null;
    private csSchema csSch = null;
    private JDBCTestMsg msg = null;
    private String drManager = null;
    private Properties sqlp = null;
    private CallableStatement cstmt = null;
    private transient DatabaseMetaData dbmd = null;
    private Statement stmt = null;

    public static void main(String[] args) {
        callStmtClient8 theTests = new callStmtClient8();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                this.sqlp = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.rsSch = new rsSchema();
                this.csSch = new csSchema();
                this.msg = new JDBCTestMsg();
                this.stmt = this.conn.createStatement();
                this.dbmd = this.conn.getMetaData();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject01() throws Exception {
        ResultSet rs = null;
        String oRetVal = null;
        try {
            this.rsSch.createTab("Char_Tab", this.sqlp, this.conn);
            String sCoffeeName = this.rsSch.extractVal("Char_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Char_In_Null(?)}");
            this.cstmt.setObject(1, (Object)sCoffeeName);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            String Null_Val_Query = this.sqlp.getProperty("Char_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            rs = this.stmt.executeQuery(Null_Val_Query);
            rs.next();
            oRetVal = (String)rs.getObject(1);
            this.msg.addOutputMsg(sCoffeeName, oRetVal);
            if (oRetVal.trim().equals(sCoffeeName.trim())) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject method is Failed!");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Char_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject02() throws Exception {
        ResultSet rs = null;
        String oRetVal = null;
        try {
            this.rsSch.createTab("Varchar_Tab", this.sqlp, this.conn);
            String sCoffeeName = this.rsSch.extractVal("Varchar_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Varchar_In_Null(?)}");
            this.cstmt.setObject(1, (Object)sCoffeeName);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            String Null_Val_Query = this.sqlp.getProperty("Varchar_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            rs = this.stmt.executeQuery(Null_Val_Query);
            rs.next();
            oRetVal = (String)rs.getObject(1);
            this.msg.addOutputMsg(sCoffeeName, oRetVal);
            if (oRetVal.trim().equals(sCoffeeName.trim())) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject method is Failed!");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Varchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject03() throws Exception {
        ResultSet rs = null;
        String oRetVal = null;
        try {
            this.rsSch.createTab("Longvarcharnull_Tab", this.sqlp, this.conn);
            String sCoffeeName = this.rsSch.extractVal("Longvarchar_Tab", 1, this.sqlp, this.conn);
            sCoffeeName = sCoffeeName.trim();
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Lvarchar_In_Null(?)}");
            this.cstmt.setObject(1, (Object)sCoffeeName);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            String Null_Val_Query = this.sqlp.getProperty("Longvarchar_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            rs = this.stmt.executeQuery(Null_Val_Query);
            rs.next();
            oRetVal = (String)rs.getObject(1);
            oRetVal = oRetVal.trim();
            this.msg.addOutputMsg(sCoffeeName, oRetVal);
            if (oRetVal.equals(sCoffeeName)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject method is Failed!");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Longvarcharnull_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject04() throws Exception {
        ResultSet rs = null;
        BigDecimal oRetVal = null;
        try {
            this.rsSch.createTab("Numeric_Tab", this.sqlp, this.conn);
            String sMaxBigDecimalVal = this.rsSch.extractVal("Numeric_Tab", 2, this.sqlp, this.conn);
            BigDecimal maxBigDecimal = new BigDecimal(sMaxBigDecimalVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Numeric_In_Max(?)}");
            this.cstmt.setObject(1, (Object)maxBigDecimal);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            String Min_Val_Query = this.sqlp.getProperty("Numeric_Query_Max", "");
            this.msg.setMsg(Min_Val_Query);
            rs = this.stmt.executeQuery(Min_Val_Query);
            rs.next();
            oRetVal = (BigDecimal)rs.getObject(1);
            this.msg.addOutputMsg("" + maxBigDecimal, "" + oRetVal);
            if (oRetVal.compareTo(maxBigDecimal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject method is Failed!");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Numeric_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject05() throws Exception {
        ResultSet rs = null;
        BigDecimal oRetVal = null;
        try {
            this.rsSch.createTab("Numeric_Tab", this.sqlp, this.conn);
            String sMinBigDecimalVal = this.rsSch.extractVal("Numeric_Tab", 2, this.sqlp, this.conn);
            BigDecimal minBigDecimal = new BigDecimal(sMinBigDecimalVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Numeric_In_Null(?)}");
            this.cstmt.setObject(1, (Object)minBigDecimal);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            String Null_Val_Query = this.sqlp.getProperty("Numeric_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            rs = this.stmt.executeQuery(Null_Val_Query);
            rs.next();
            oRetVal = (BigDecimal)rs.getObject(1);
            this.msg.addOutputMsg("" + minBigDecimal, "" + oRetVal);
            if (oRetVal.compareTo(minBigDecimal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject method is Failed!");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Numeric_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject06() throws Exception {
        ResultSet rs = null;
        BigDecimal oRetVal = null;
        try {
            this.rsSch.createTab("Decimal_Tab", this.sqlp, this.conn);
            String sMaxBigDecimalVal = this.rsSch.extractVal("Decimal_Tab", 2, this.sqlp, this.conn);
            BigDecimal maxBigDecimal = new BigDecimal(sMaxBigDecimalVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Decimal_In_Max(?)}");
            this.cstmt.setObject(1, (Object)maxBigDecimal);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            String Min_Val_Query = this.sqlp.getProperty("Decimal_Query_Max", "");
            this.msg.setMsg(Min_Val_Query);
            rs = this.stmt.executeQuery(Min_Val_Query);
            rs.next();
            oRetVal = (BigDecimal)rs.getObject(1);
            this.msg.addOutputMsg("" + maxBigDecimal, "" + oRetVal);
            if (oRetVal.compareTo(maxBigDecimal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject method is Failed!");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Decimal_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject07() throws Exception {
        ResultSet rs = null;
        BigDecimal oRetVal = null;
        try {
            this.rsSch.createTab("Decimal_Tab", this.sqlp, this.conn);
            String sMinBigDecimalVal = this.rsSch.extractVal("Decimal_Tab", 2, this.sqlp, this.conn);
            BigDecimal minBigDecimal = new BigDecimal(sMinBigDecimalVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Decimal_In_Null(?)}");
            this.cstmt.setObject(1, (Object)minBigDecimal);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            String Null_Val_Query = this.sqlp.getProperty("Decimal_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            rs = this.stmt.executeQuery(Null_Val_Query);
            rs.next();
            oRetVal = (BigDecimal)rs.getObject(1);
            this.msg.addOutputMsg("" + minBigDecimal, "" + oRetVal);
            if (oRetVal.compareTo(minBigDecimal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject method is Failed!");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Decimal_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject08() throws Exception {
        ResultSet rs = null;
        Boolean oRetVal = null;
        try {
            this.rsSch.createTab("Bit_Tab", this.sqlp, this.conn);
            Boolean maxBoolean = this.rsSch.extractValAsBoolObj("Bit_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Bit_In_Min(?)}");
            this.cstmt.setObject(1, (Object)maxBoolean);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            String Min_Val_Query = this.sqlp.getProperty("Bit_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            rs = this.stmt.executeQuery(Min_Val_Query);
            rs.next();
            oRetVal = rs.getBoolean(1);
            this.msg.addOutputMsg("" + maxBoolean, "" + oRetVal);
            if (oRetVal.equals(maxBoolean)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject method is Failed!");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Bit_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject09() throws Exception {
        ResultSet rs = null;
        Boolean oRetVal = null;
        Boolean minBoolean = null;
        try {
            this.rsSch.createTab("Bit_Tab", this.sqlp, this.conn);
            minBoolean = this.rsSch.extractValAsBoolObj("Bit_Tab", 2, this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Bit_In_Null(?)}");
            this.cstmt.setObject(1, (Object)minBoolean);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            String Null_Val_Query = this.sqlp.getProperty("Bit_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            rs = this.stmt.executeQuery(Null_Val_Query);
            rs.next();
            oRetVal = rs.getBoolean(1);
            this.msg.addOutputMsg("" + minBoolean, "" + oRetVal);
            if (oRetVal.equals(minBoolean)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject method is Failed!");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Bit_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject10() throws Exception {
        ResultSet rs = null;
        Integer oRetVal = null;
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            String sMaxIntegerVal = this.rsSch.extractVal("Integer_Tab", 1, this.sqlp, this.conn);
            Integer maxInteger = new Integer(sMaxIntegerVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Integer_In_Min(?)}");
            this.cstmt.setObject(1, (Object)maxInteger);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            String Min_Val_Query = this.sqlp.getProperty("Integer_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            rs = this.stmt.executeQuery(Min_Val_Query);
            rs.next();
            Object objRetVal = rs.getObject(1);
            oRetVal = new Integer(objRetVal.toString());
            this.msg.addOutputMsg("" + maxInteger, "" + oRetVal);
            if (oRetVal.compareTo(maxInteger) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject method is Failed!");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject11() throws Exception {
        ResultSet rs = null;
        Integer oRetVal = null;
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            String sMinIntegerVal = this.rsSch.extractVal("Integer_Tab", 2, this.sqlp, this.conn);
            Integer minInteger = new Integer(sMinIntegerVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Integer_In_Null(?)}");
            this.cstmt.setObject(1, (Object)minInteger);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            String Null_Val_Query = this.sqlp.getProperty("Integer_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            rs = this.stmt.executeQuery(Null_Val_Query);
            rs.next();
            Object objRetVal = rs.getObject(1);
            oRetVal = new Integer(objRetVal.toString());
            this.msg.addOutputMsg("" + minInteger, "" + oRetVal);
            if (oRetVal.compareTo(minInteger) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject method is Failed!");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject12() throws Exception {
        ResultSet rs = null;
        Long oRetVal = null;
        try {
            this.rsSch.createTab("Bigint_Tab", this.sqlp, this.conn);
            String sMaxLongVal = this.rsSch.extractVal("Bigint_Tab", 1, this.sqlp, this.conn);
            Long maxLong = new Long(sMaxLongVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Bigint_In_Min(?)}");
            this.cstmt.setObject(1, (Object)maxLong);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            String Min_Val_Query = this.sqlp.getProperty("Bigint_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            rs = this.stmt.executeQuery(Min_Val_Query);
            rs.next();
            Object objRetVal = rs.getObject(1);
            oRetVal = new Long(objRetVal.toString());
            this.msg.addOutputMsg("" + maxLong, "" + oRetVal);
            if (oRetVal.compareTo(maxLong) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject method is Failed!");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Bigint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject13() throws Exception {
        ResultSet rs = null;
        Long oRetVal = null;
        try {
            this.rsSch.createTab("Bigint_Tab", this.sqlp, this.conn);
            String sMinLongVal = this.rsSch.extractVal("Bigint_Tab", 2, this.sqlp, this.conn);
            Long minLong = new Long(sMinLongVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Bigint_In_Null(?)}");
            this.cstmt.setObject(1, (Object)minLong);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            String Null_Val_Query = this.sqlp.getProperty("Bigint_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            rs = this.stmt.executeQuery(Null_Val_Query);
            rs.next();
            Object objRetVal = rs.getObject(1);
            oRetVal = new Long(objRetVal.toString());
            this.msg.addOutputMsg("" + minLong, "" + oRetVal);
            if (oRetVal.compareTo(minLong) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject method is Failed!");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Bigint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject14() throws Exception {
        ResultSet rs = null;
        Double oRetVal = null;
        try {
            this.rsSch.createTab("Double_Tab", this.sqlp, this.conn);
            String sMaxDoubleVal = this.rsSch.extractVal("Double_Tab", 1, this.sqlp, this.conn);
            Double maxDouble = new Double(sMaxDoubleVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Double_In_Min(?)}");
            this.cstmt.setObject(1, (Object)maxDouble);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            String Min_Val_Query = this.sqlp.getProperty("Double_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            rs = this.stmt.executeQuery(Min_Val_Query);
            rs.next();
            oRetVal = (Double)rs.getObject(1);
            this.msg.addOutputMsg("" + maxDouble, "" + oRetVal);
            if (oRetVal.equals(maxDouble)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject method is Failed!");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Double_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject15() throws Exception {
        ResultSet rs = null;
        Double oRetVal = null;
        try {
            this.rsSch.createTab("Double_Tab", this.sqlp, this.conn);
            String sMinDoubleVal = this.rsSch.extractVal("Double_Tab", 2, this.sqlp, this.conn);
            Double minDouble = new Double(sMinDoubleVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Double_In_Null(?)}");
            this.cstmt.setObject(1, (Object)minDouble);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            String Null_Val_Query = this.sqlp.getProperty("Double_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            rs = this.stmt.executeQuery(Null_Val_Query);
            rs.next();
            oRetVal = (Double)rs.getObject(1);
            this.msg.addOutputMsg("" + minDouble, "" + oRetVal);
            if (oRetVal.equals(minDouble)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject method is Failed!");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Double_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject16() throws Exception {
        ResultSet rs = null;
        Float oRetVal = null;
        try {
            this.rsSch.createTab("Float_Tab", this.sqlp, this.conn);
            String sMaxFloatVal = this.rsSch.extractVal("Float_Tab", 1, this.sqlp, this.conn);
            Float maxFloat = new Float(sMaxFloatVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Float_In_Min(?)}");
            this.cstmt.setObject(1, (Object)maxFloat);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            String Min_Val_Query = this.sqlp.getProperty("Float_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            rs = this.stmt.executeQuery(Min_Val_Query);
            rs.next();
            Object objRetVal = rs.getObject(1);
            oRetVal = new Float(objRetVal.toString());
            this.msg.addOutputMsg("" + maxFloat, "" + oRetVal);
            if (oRetVal.compareTo(maxFloat) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject method is Failed!");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Float_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject17() throws Exception {
        ResultSet rs = null;
        Float oRetVal = null;
        try {
            this.rsSch.createTab("Float_Tab", this.sqlp, this.conn);
            String sMinFloatVal = this.rsSch.extractVal("Float_Tab", 2, this.sqlp, this.conn);
            Float minFloat = new Float(sMinFloatVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Float_In_Null(?)}");
            this.cstmt.setObject(1, (Object)minFloat);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            String Null_Val_Query = this.sqlp.getProperty("Float_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            rs = this.stmt.executeQuery(Null_Val_Query);
            rs.next();
            Object objRetVal = rs.getObject(1);
            oRetVal = new Float(objRetVal.toString());
            this.msg.addOutputMsg("" + minFloat, "" + oRetVal);
            if (oRetVal.compareTo(minFloat) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject method is Failed!");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Float_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject18() throws Exception {
        ResultSet rs = null;
        Date oRetVal = null;
        Date mfgDateVal = null;
        try {
            this.rsSch.createTab("Date_Tab", this.sqlp, this.conn);
            String sMfgDateVal = this.rsSch.extractVal("Date_Tab", 1, this.sqlp, this.conn);
            sMfgDateVal = sMfgDateVal.substring(sMfgDateVal.indexOf(39) + 1, sMfgDateVal.lastIndexOf(39));
            mfgDateVal = Date.valueOf(sMfgDateVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Date_In_Null(?)}");
            this.cstmt.setObject(1, (Object)mfgDateVal);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            String Null_Val_Query = this.sqlp.getProperty("Date_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            rs = this.stmt.executeQuery(Null_Val_Query);
            rs.next();
            java.util.Date objRetVal = (java.util.Date)rs.getObject(1);
            long lDate = objRetVal.getTime();
            oRetVal = new Date(lDate);
            this.msg.addOutputMsg("" + mfgDateVal, "" + oRetVal);
            if (oRetVal.compareTo(mfgDateVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject method is Failed!");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Date_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject19() throws Exception {
        ResultSet rs = null;
        Time oRetVal = null;
        Time brkTimeVal = null;
        try {
            this.rsSch.createTab("Time_Tab", this.sqlp, this.conn);
            String sBrkTimeVal = this.rsSch.extractVal("Time_Tab", 1, this.sqlp, this.conn);
            sBrkTimeVal = sBrkTimeVal.substring(sBrkTimeVal.indexOf(39) + 1, sBrkTimeVal.lastIndexOf(39));
            brkTimeVal = Time.valueOf(sBrkTimeVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Time_In_Null(?)}");
            this.cstmt.setObject(1, (Object)brkTimeVal);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            String Null_Val_Query = this.sqlp.getProperty("Time_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            Thread.sleep(5000L);
            rs = this.stmt.executeQuery(Null_Val_Query);
            rs.next();
            java.util.Date objRetVal = (java.util.Date)rs.getObject(1);
            long lDate = objRetVal.getTime();
            oRetVal = new Time(lDate);
            this.msg.addOutputMsg(brkTimeVal.toString(), oRetVal.toString());
            if (oRetVal.toString().trim().equals(brkTimeVal.toString().trim())) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject method is Failed!");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Time_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject20() throws Exception {
        ResultSet rs = null;
        Timestamp oRetVal = null;
        Timestamp inTimeVal = null;
        try {
            this.rsSch.createTab("Timestamp_Tab", this.sqlp, this.conn);
            this.msg.setMsg("to extract the Value of Timestamp to be Updated");
            String sInTimeVal = this.rsSch.extractVal("Timestamp_Tab", 1, this.sqlp, this.conn);
            sInTimeVal = sInTimeVal.substring(sInTimeVal.indexOf(39) + 1, sInTimeVal.lastIndexOf(39));
            this.msg.setMsg("Timestamp Value :" + sInTimeVal);
            inTimeVal = Timestamp.valueOf(sInTimeVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Timestamp_In_Null(?)}");
            this.cstmt.setObject(1, (Object)inTimeVal);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            String Null_Val_Query = this.sqlp.getProperty("Timestamp_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            rs = this.stmt.executeQuery(Null_Val_Query);
            rs.next();
            oRetVal = (Timestamp)rs.getObject(1);
            this.msg.addOutputMsg("" + inTimeVal, "" + oRetVal);
            if (oRetVal.equals(inTimeVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject method is Failed!");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Timestamp_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void cleanup() throws Exception {
        try {
            this.rsSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

