/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee20.cditests.mdb;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.ee20.cditests.mdb.EjbClientIF;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.logging.Logger;

@Dependent
public class Client {
    private static Logger log = Logger.getLogger(Client.class.getName());
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM = 8000;
    private Properties props = null;
    private String hostname = "localhost";
    private int portnum = 8000;
    private URL url = null;
    private URLConnection urlConn = null;
    private String SERVLET = "/cditestsmdb_web/ServletTest";
    @Dependent
    @Inject
    Instance<EjbClientIF> ejbclientInstance;
    EjbClientIF ejbclient;
    private static final long serialVersionUID = 1L;
    long timeout;
    String user;
    String password;
    String mode;

    @PostConstruct
    public void setup(String[] args, Properties p) throws Exception {
        this.props = p;
        boolean pass = true;
        try {
            this.timeout = Integer.parseInt(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            this.hostname = p.getProperty("webServerHost");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must not be null ");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must not be null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
            if (this.hostname == null) {
                throw new Exception("'webServerHost' in ts.jte must not be null");
            }
            try {
                this.portnum = Integer.parseInt(p.getProperty("webServerPort"));
            }
            catch (Exception e) {
                throw new Exception("'webServerPort' in ts.jte must be a number");
            }
            log.info("AppClient DEBUG: ejbclient: " + this.ejbclient);
            this.ejbclient = (EjbClientIF)this.ejbclientInstance.get();
            if (this.ejbclient == null) {
                throw new Exception("setup failed: ejbclient injection failure");
            }
            this.ejbclient.init(p);
        }
        catch (Exception e) {
            throw new Exception("setup failed:", e);
        }
        this.ejbclient.init(p);
        TestUtil.logMsg((String)"setup ok");
    }

    public void cleanup() throws Exception {
        TestUtil.logMsg((String)"cleanup ok");
    }

    public void testCDIInjectionOfMDBWithQueueReplyFromEjb() throws Exception {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"------------------------------------------");
            TestUtil.logMsg((String)"testCDIInjectionOfMDBWithQueueReplyFromEjb");
            TestUtil.logMsg((String)"------------------------------------------");
            boolean passEjb = this.ejbclient.echo("testCDIInjectionOfMDBWithQueueReplyFromEjb");
            if (!passEjb) {
                pass = false;
                TestUtil.logErr((String)"CDI injection test failed from Ejb");
            } else {
                TestUtil.logMsg((String)"CDI injection test passed from Ejb");
            }
            passEjb = this.ejbclient.echo("testCDIInjectionOfMDBWithQueueReplyFromEjb");
            if (!passEjb) {
                pass = false;
                TestUtil.logErr((String)"CDI injection test failed from Ejb");
            } else {
                TestUtil.logMsg((String)"CDI injection test passed from Ejb");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"CDI injection test failed from Ejb");
            pass = false;
        }
        if (!pass) {
            throw new Exception("testCDIInjectionOfMDBWithQueueReplyFromEjb failed");
        }
    }

    public void testCDIInjectionOfMDBWithTopicReplyFromEjb() throws Exception {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"------------------------------------------");
            TestUtil.logMsg((String)"testCDIInjectionOfMDBWithTopicReplyFromEjb");
            TestUtil.logMsg((String)"------------------------------------------");
            boolean passEjb = this.ejbclient.echo("testCDIInjectionOfMDBWithTopicReplyFromEjb");
            if (!passEjb) {
                pass = false;
                TestUtil.logErr((String)"CDI injection test failed from Ejb");
            } else {
                TestUtil.logMsg((String)"CDI injection test passed from Ejb");
            }
            passEjb = this.ejbclient.echo("testCDIInjectionOfMDBWithTopicReplyFromEjb");
            if (!passEjb) {
                pass = false;
                TestUtil.logErr((String)"CDI injection test failed from Ejb");
            } else {
                TestUtil.logMsg((String)"CDI injection test passed from Ejb");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"CDI injection test failed from Ejb");
            pass = false;
        }
        if (!pass) {
            throw new Exception("testCDIInjectionOfMDBWithTopicReplyFromEjb failed");
        }
    }
}

