/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.callback.common;

import com.sun.ts.lib.util.TestUtil;
import ee.jakarta.tck.persistence.core.callback.common.CallbackStatusIF;

public class GenerictListenerImpl {
    public static void logTrace(String s, CallbackStatusIF b) {
        String ss = b.getEntityName() + ": " + s;
        TestUtil.logTrace((String)ss);
    }

    public void prePersist(CallbackStatusIF b) {
        GenerictListenerImpl.logTrace("In prePersist in class " + this, b);
        b.setPrePersistCalled(true);
        b.addPrePersistCall(b.getEntityName());
        String testName = b.getTestName();
        if ("prePersistRuntimeExceptionTest".equals(testName)) {
            throw new ArithmeticException("RuntimeException from PrePersist.");
        }
    }

    public void postPersist(Object b) {
        CallbackStatusIF p = (CallbackStatusIF)b;
        GenerictListenerImpl.logTrace("In postPersist.", p);
        if (!p.isPrePersistCalled()) {
            TestUtil.logTrace((String)"When calling postPersist, prePersist has not been called.");
            throw new IllegalStateException("When calling postPersist, prePersist has not been called.");
        }
        p.setPostPersistCalled(true);
        p.addPostPersistCall(p.getEntityName());
    }

    public void preRemove(CallbackStatusIF b) {
        GenerictListenerImpl.logTrace("In preRemove.", b);
        b.setPreRemoveCalled(true);
        b.addPreRemoveCall(b.getEntityName());
    }

    public void postRemove(Object b) {
        CallbackStatusIF p = (CallbackStatusIF)b;
        GenerictListenerImpl.logTrace("In postRemove.", p);
        if (!p.isPreRemoveCalled()) {
            TestUtil.logTrace((String)"When calling postRemove, preRemove has not been called.");
            throw new IllegalStateException("When calling postRemove, preRemove has not been called.");
        }
        p.setPostRemoveCalled(true);
        p.addPostRemoveCall(p.getEntityName());
    }

    public void preUpdate(CallbackStatusIF b) {
        GenerictListenerImpl.logTrace("In preUpdate.", b);
        b.setPreUpdateCalled(true);
        b.addPreUpdateCall(b.getEntityName());
    }

    public void postUpdate(Object b) {
        CallbackStatusIF p = (CallbackStatusIF)b;
        GenerictListenerImpl.logTrace("In postUpdate.", p);
        if (!p.isPreUpdateCalled()) {
            TestUtil.logErr((String)"When calling postUpdate, preUpdate has not been called.");
            throw new IllegalStateException("When calling postUpdate, preUpdate has not been called.");
        }
        p.setPostUpdateCalled(true);
        p.addPostUpdateCall(p.getEntityName());
    }

    public void postLoad(CallbackStatusIF b) {
        GenerictListenerImpl.logTrace("In postLoad.", b);
        b.setPostLoadCalled(true);
        b.addPostLoadCall(b.getEntityName());
    }
}

