/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.interview.Help;
import com.sun.javatest.Harness;
import com.sun.javatest.ProductInfo;
import com.sun.javatest.TestSuite;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.tool.ToolManager;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.tool.jthelp.HelpBroker;
import com.sun.javatest.tool.jthelp.HelpSet;
import com.sun.javatest.tool.jthelp.JTHelpBroker;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.TreeSet;
import java.util.WeakHashMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

class HelpMenu
extends JMenu {
    private static final String HELP = "help";
    private static final String ABOUT_JAVA = "aboutJava";
    private static final String ABOUT_JAVATEST = "aboutJavaTest";
    private static Map<TestSuite, HelpSet[]> docTable = new WeakHashMap<TestSuite, HelpSet[]>();
    private static Map<HelpSet, HelpBroker> helpBrokerTable = new WeakHashMap<HelpSet, HelpBroker>();
    private Component parent;
    private Desktop desktop;
    private UIFactory uif;
    private Listener listener;

    HelpMenu(Component parent, Desktop desktop, UIFactory uif) {
        this.parent = parent;
        this.desktop = desktop;
        this.uif = uif;
        this.listener = new Listener();
        String[] items = new String[]{HELP, null, ABOUT_JAVATEST, ABOUT_JAVA};
        uif.initMenu(this, "hm", items, this.listener);
        this.addMenuListener(this.listener);
    }

    private void addTestSuiteItems() {
        ToolManager[] mgrs;
        int insertPoint;
        Tool[] tools = this.desktop.getTools();
        if (tools == null || tools.length == 0) {
            return;
        }
        TreeSet<Object> loadedTestSuites = new TreeSet<Object>((o1, o2) -> o1.getName().compareTo(o2.getName()));
        Tool selTool = this.desktop.getSelectedTool();
        if (selTool != null) {
            Object[] tss = selTool.getLoadedTestSuites();
            if (tss != null) {
                loadedTestSuites.addAll(Arrays.asList(tss));
            }
        } else {
            for (Tool tool : tools) {
                TestSuite[] tss = tool.getLoadedTestSuites();
                if (tss == null) continue;
                loadedTestSuites.addAll(Arrays.asList(tss));
            }
        }
        for (insertPoint = this.getItemCount() - 1; insertPoint > 0 && this.getItem(insertPoint - 1) != null; --insertPoint) {
        }
        int count = 0;
        for (TestSuite testSuite : loadedTestSuites) {
            JMenuItem[] menuItems = this.getMenuItems(testSuite, count);
            if (menuItems == null || menuItems.length <= 0) continue;
            for (JMenuItem mi : menuItems) {
                mi.putClientProperty(this.getClass(), this);
                this.insert(mi, insertPoint++);
            }
            JPopupMenu.Separator sep = new JPopupMenu.Separator();
            sep.putClientProperty(this.getClass(), this);
            JPopupMenu p = this.getPopupMenu();
            p.insert(sep, insertPoint++);
            count += menuItems.length + 1;
        }
        for (ToolManager mgr2 : mgrs = this.desktop.getToolManagers()) {
            JMenuItem[] jmi = mgr2.getHelpPrimaryMenus();
            if (jmi == null) continue;
            for (JMenuItem aJmi : jmi) {
                aJmi.putClientProperty(this.getClass(), this);
                this.insert(aJmi, insertPoint++);
            }
        }
        for (ToolManager mgr1 : mgrs) {
            JMenuItem[] jmi = mgr1.getHelpTestSuiteMenus();
            if (jmi == null) continue;
            for (JMenuItem aJmi : jmi) {
                aJmi.putClientProperty(this.getClass(), this);
                this.insert(aJmi, insertPoint++);
            }
        }
        for (ToolManager mgr : mgrs) {
            JMenuItem[] jmi = mgr.getHelpAboutMenus();
            if (jmi == null) continue;
            for (JMenuItem aJmi : jmi) {
                aJmi.putClientProperty(this.getClass(), this);
                this.add(aJmi);
            }
        }
    }

    private void removeTestSuiteItems() {
        for (Component c : this.getMenuComponents()) {
            JComponent comp;
            if (!(c instanceof JComponent) || (comp = (JComponent)c).getClientProperty(this.getClass()) != this) continue;
            this.remove(comp);
        }
    }

    private void showAbout(String title, String s, String contKey, String fieldKey) {
        ArrayList<String> v = new ArrayList<String>();
        int start = 0;
        int end = 0;
        while ((end = s.indexOf(10, start)) != -1) {
            v.add(s.substring(start, end));
            start = end + 1;
        }
        v.add(s.substring(start));
        ArrayList<JComponent> tfs = new ArrayList<JComponent>();
        for (String aV : v) {
            JTextField tf = new JTextField(aV);
            tf.setBorder(null);
            tf.setHorizontalAlignment(0);
            tf.setOpaque(false);
            tf.setBackground(UIFactory.Colors.TRANSPARENT.getValue());
            tf.setEditable(false);
            this.uif.setAccessibleInfo(tf, fieldKey);
            tfs.add(tf);
        }
        JTextArea ta = this.uif.createMessageArea("hm.aboutJavaTest.copy");
        ta.setRows(15);
        tfs.add(this.uif.createScrollPane(ta, 20, 30));
        Object[] fields = tfs.toArray();
        JOptionPane pane = new JOptionPane(fields, 1);
        pane.setIcon(this.desktop.getLogo());
        pane.setOptionType(0);
        this.uif.setAccessibleInfo(pane, contKey);
        JButton okBtn = this.uif.createCloseButton("hm.about.ok", false);
        pane.setOptions(new Object[]{okBtn});
        JDialog d = pane.createDialog(this.parent, title);
        d.getRootPane().setDefaultButton(okBtn);
        d.setVisible(true);
    }

    private void showHelpSet(HelpSet hs) {
        HelpBroker hb = this.getHelpBroker(hs);
        if (hb == null) {
            System.err.println("Unable to display help, the help set isn't available.");
        }
    }

    private HelpBroker getHelpBroker(HelpSet hs) {
        HelpBroker hb = helpBrokerTable.get(hs);
        if (hb == null) {
            hb = new JTHelpBroker();
            helpBrokerTable.put(hs, hb);
        }
        return hb;
    }

    private JMenuItem[] getMenuItems(TestSuite ts, int count) {
        HelpSet[] docs = docTable.get(ts);
        if (docs == null) {
            try {
                docs = Help.getAdditionalDocs(ts);
            }
            catch (Help.Fault e2) {
                String msg = this.uif.getI18NString("hm.cantLoadDocs", ts.getName(), e2.getMessage());
                System.err.println(msg);
            }
            if (docs == null) {
                docs = new HelpSet[]{};
            }
            docTable.put(ts, docs);
        }
        if (docs.length == 0) {
            return null;
        }
        ArrayList<JMenuItem> v = new ArrayList<JMenuItem>();
        for (int i = 0; i < docs.length; ++i) {
            JMenuItem mi;
            HelpSet doc = docs[i];
            if (count + i < 10) {
                mi = new JMenuItem(count + i + " " + doc.getTitle());
                mi.setMnemonic(48 + count + i);
            } else {
                mi = new JMenuItem("  " + doc.getTitle());
            }
            mi.addActionListener(e -> this.showHelpSet(doc));
            v.add(mi);
        }
        JMenuItem[] items = new JMenuItem[v.size()];
        v.toArray(items);
        return items;
    }

    private class Listener
    implements MenuListener,
    ActionListener {
        private Listener() {
        }

        @Override
        public void menuSelected(MenuEvent e) {
            HelpMenu.this.removeTestSuiteItems();
            HelpMenu.this.addTestSuiteItems();
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals(HelpMenu.ABOUT_JAVATEST)) {
                JMenuItem src = (JMenuItem)e.getSource();
                DateFormat df = DateFormat.getDateInstance(1);
                String date = null;
                Date dt = ProductInfo.getBuildDate();
                date = dt != null ? df.format(dt) : HelpMenu.this.uif.getI18NString("hm.aboutBadDate");
                String aboutJavaTest = HelpMenu.this.uif.getI18NString("hm.aboutJavaTest", ProductInfo.getName(), ProductInfo.getVersion(), ProductInfo.getMilestone(), ProductInfo.getBuildNumber(), Harness.getClassDir().getPath(), ProductInfo.getBuildJavaVersion(), date);
                HelpMenu.this.showAbout(src.getText(), aboutJavaTest, "hm.aboutJavaTest", "hm.aboutJavaTest.text");
            } else if (cmd.equals(HelpMenu.ABOUT_JAVA)) {
                JMenuItem src = (JMenuItem)e.getSource();
                String aboutJava = HelpMenu.this.uif.getI18NString("hm.aboutJava", System.getProperty("java.version"), System.getProperty("java.vendor"), System.getProperty("java.home"), System.getProperty("java.vendor.url"));
                HelpMenu.this.showAbout(src.getText(), aboutJava, "hm.aboutJava", "hm.aboutJava.text");
            } else if (cmd.equals(HelpMenu.HELP)) {
                HelpBroker helpBroker = HelpMenu.this.desktop.getHelpBroker();
                if (helpBroker != null) {
                    helpBroker.displayCurrentID("jthelp.csh");
                } else {
                    System.err.println("Unable to display help, the help system isn't available.");
                }
            }
        }
    }
}

