/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.lib;

import com.sun.javatest.Script;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestResult;
import com.sun.javatest.util.StringArray;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import java.util.Vector;

public class KeywordScript
extends Script {
    private boolean debug = false;

    private static void printStrArr(PrintWriter pw, String ... data) {
        if (data == null) {
            return;
        }
        for (String aData : data) {
            pw.println(aData);
        }
    }

    @Override
    public void run() {
        String s;
        String envName;
        PrintWriter trOut = this.getTestResult().getTestCommentWriter();
        TestDescription td = this.getTestDescription();
        for (String scriptArg : this.scriptArgs) {
            if (!scriptArg.equals("-debug")) {
                this.setStatus(Status.error("bad args for script: " + scriptArg));
                return;
            }
            this.debug = true;
        }
        String prefix = "script.";
        Set<String> testKeys = td.getKeywordTable();
        Vector<String> choices = new Vector<String>();
        Vector<String> matches = new Vector<String>();
        int wordsMatchingInMatches = 0;
        block8: for (String key : this.env.keys()) {
            if (!key.startsWith(prefix)) continue;
            if (this.debug) {
                trOut.println("CHECKING " + key);
            }
            String keyList = key.substring(prefix.length()).replace('_', ' ').toLowerCase();
            String[] keys = StringArray.split(keyList);
            choices.add(keyList);
            if (this.debug) {
                trOut.println("keys: " + StringArray.join(keys));
            }
            if (keys == null || keys.length < wordsMatchingInMatches) continue;
            for (Object object : keys) {
                if (testKeys.contains(object)) continue;
                if (!this.debug) continue block8;
                trOut.println("discarding, because of " + (String)object);
                continue block8;
            }
            if (keys.length > wordsMatchingInMatches) {
                if (this.debug) {
                    trOut.println("new best match, " + keys.length + " keys");
                }
                matches = new Vector();
                wordsMatchingInMatches = keys.length;
            }
            matches.add(key);
        }
        String name = this.env.getName();
        String string = envName = name.isEmpty() ? "The anonymous environment" : "Environment `" + this.env.getName() + "'";
        if (matches.isEmpty()) {
            if (choices.isEmpty()) {
                s = envName + " has no `script' entries";
                trOut.println(s);
                this.setStatus(Status.error(s));
                return;
            }
            s = envName + " has no suitable `script' entry";
            trOut.println(s);
            trOut.println("The keyword combinations for scripts in this environment are: ");
            for (String choice : choices) {
                trOut.println(choice);
            }
            this.setStatus(Status.error(s));
            return;
        }
        if (matches.size() > 1) {
            s = envName + " has ambiguous `script' entries";
            trOut.println(s);
            for (int i = 0; i < matches.size(); ++i) {
                trOut.println(i + ": " + (String)matches.get(i));
            }
            this.setStatus(Status.error(s));
            return;
        }
        String bestScript = (String)matches.get(0);
        try {
            String[] command = this.env.lookup(bestScript);
            if (command.length == 0) {
                String s2 = "INTERNAL ERROR: failed to lookup key: " + bestScript;
                trOut.println(s2);
                this.setStatus(Status.error(s2));
                return;
            }
            trOut.println("test: " + td.getRootRelativeURL());
            trOut.println("script: " + this.getClass().getName() + " " + StringArray.join(this.scriptArgs));
            String[] msgs = new String[]{"Based on these keywords:    " + bestScript.substring(prefix.length()).replace('_', ' ').toLowerCase(), "this script has now been selected:    " + StringArray.join(command)};
            KeywordScript.printStrArr(trOut, msgs);
            try {
                Class<Script> c = Class.forName(command[0]).asSubclass(Script.class);
                Script script = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                String[] stringArray = new String[command.length - 1];
                System.arraycopy(command, 1, stringArray, 0, stringArray.length);
                this.initDelegate(script, stringArray);
                script.run();
            }
            catch (ClassNotFoundException ex) {
                this.setStatus(Status.error("Can't find class `" + command[0] + "' for `" + this.env.getName() + "'"));
            }
            catch (NoSuchMethodException ex) {
                this.setStatus(Status.error("Can't find no-arg constructor `" + command[0] + "' for `" + this.env.getName() + "'"));
            }
            catch (IllegalAccessException ex) {
                this.setStatus(Status.error("Illegal access to class `" + command[0] + "' for `" + this.env.getName() + "'"));
            }
            catch (InstantiationException | InvocationTargetException ex) {
                this.setStatus(Status.error("Can't instantiate class`" + command[0] + "' for `" + this.env.getName() + "'"));
            }
        }
        catch (TestEnvironment.Fault ex) {
            this.setStatus(Status.error("environment `" + this.env.getName() + "' has bad `script' entry for `" + bestScript + "'"));
        }
    }

    @Override
    public Status run(String[] args, TestDescription td, TestEnvironment env) {
        throw new Error("Method not applicable.");
    }

    private void setStatus(Status s) {
        TestResult tr = this.getTestResult();
        tr.setEnvironment(this.env);
        tr.setStatus(s);
        try {
            tr.writeResults(this.workDir, this.backupPolicy);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

