/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */


/*
 *  @(#)ValidationException.test.xml	1.1 02/11/11 Evgueni Rouban
 * Generated from : api/jakarta_xml/bind/ValidationException/ValidationException.test.xml
 *
 * General tests of constructors and methods
 * General tests of constructors and methods.
 */

package javasoft.sqe.tests.api.jakarta.xml.bind.ValidationException;

import jakarta.xml.bind.ValidationException;
import javasoft.sqe.javatest.Status;
import javasoft.sqe.javatest.lib.MultiTest;


public class ValidationExceptionTests extends MultiTest {

    static final String msg = "test message";
    static final String err = "error code";
    static final Throwable linkedException = new Throwable();

    /* standalone interface */
    public static void main(String argv[]) {
        ValidationExceptionTests test = new ValidationExceptionTests();
        test.run(argv, System.err, System.out).exit();
    }

    /**
     * Assertion testing
     * for public ValidationException(java.lang.String message),
     * Construct a ValidationException with the specified detail message..
     * <br><b>Expected results</b>: the message is what set
     */
    public Status Ctor001() {
        ValidationException ve = new ValidationException(msg);
        if (ve.getMessage() != msg) {
            return Status.failed("getMessage() != msg: \""
                               + ve.getMessage() + "\", expected is \"" + msg + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public ValidationException(java.lang.String message),
     * The errorCode will default to null..
     * <br><b>Expected results</b>: errorCode is null
     */
    public Status Ctor002() {
        ValidationException ve = new ValidationException(msg);
        if (ve.getErrorCode() != null) {
            return Status.failed("getErrorCode() != null: \""
                               + ve.getErrorCode() + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public ValidationException(java.lang.String message),
     * The linkedException will default to null..
     * <br><b>Expected results</b>: linkedException is null
     */
    public Status Ctor003() {
        ValidationException ve = new ValidationException(msg);
        if (ve.getLinkedException() != null) {
            return Status.failed("getLinkedException() != null: \""
                               + ve.getLinkedException() + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public ValidationException(java.lang.String message, java.lang.String errorCode),
     * Construct a ValidationException with the specified detail message..
     * <br><b>Expected results</b>: the message is what set
     */
    public Status Ctor004() {
        ValidationException ve = new ValidationException(msg, err);
        if (ve.getMessage() != msg) {
            return Status.failed("getMessage() != msg: \""
                               + ve.getMessage() + "\", expected is \"" + msg + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public ValidationException(java.lang.String message, java.lang.String errorCode),
     * Construct a ValidationException with the specified errorCode..
     * <br><b>Expected results</b>: the errorCode is what set
     */
    public Status Ctor005() {
        ValidationException ve = new ValidationException(msg, err);
        if (ve.getErrorCode() != err) {
            return Status.failed("getErrorCode() != err: \""
                               + ve.getErrorCode() + "\", expected is \"" + err + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public ValidationException(java.lang.String message, java.lang.String errorCode),
     * The linkedException will default to null..
     * <br><b>Expected results</b>: linkedException is null
     */
    public Status Ctor006() {
        ValidationException ve = new ValidationException(msg, err);
        if (ve.getLinkedException() != null) {
            return Status.failed("getLinkedException() != null: \""
                               + ve.getLinkedException() + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public ValidationException(java.lang.String message, java.lang.String errorCode, java.lang.Throwable exception),
     * Construct a ValidationException with the specified detail message..
     * <br><b>Expected results</b>: the message is what set
     */
    public Status Ctor007() {
        ValidationException ve = new ValidationException(msg, err, linkedException);
        if (ve.getMessage() != msg) {
            return Status.failed("getMessage() != msg: \""
                               + ve.getMessage() + "\", expected is \"" + msg + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public ValidationException(java.lang.String message, java.lang.String errorCode, java.lang.Throwable exception),
     * Construct a ValidationException with the specified errorCode..
     * <br><b>Expected results</b>: the errorCode is what set
     */
    public Status Ctor008() {
        ValidationException ve = new ValidationException(msg, err, linkedException);
        if (ve.getErrorCode() != err) {
            return Status.failed("getErrorCode() != err: \""
                               + ve.getErrorCode() + "\", expected is \"" + err + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public ValidationException(java.lang.String message, java.lang.String errorCode, java.lang.Throwable exception),
     * Construct a ValidationException with the specified linkedException..
     * <br><b>Expected results</b>: linkedException is what set
     */
    public Status Ctor009() {
        ValidationException ve = new ValidationException(msg, err, linkedException);
        if (ve.getLinkedException() != linkedException) {
            return Status.failed("getLinkedException() != linkedException: \""
                               + ve.getLinkedException() + "\", expected is \"" + linkedException + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public ValidationException(java.lang.String message, java.lang.Throwable exception),
     * Construct a ValidationException with the specified detail message..
     * <br><b>Expected results</b>: the message is what set
     */
    public Status Ctor010() {
        ValidationException ve = new ValidationException(msg, linkedException);
        if (ve.getMessage() != msg) {
            return Status.failed("getMessage() != msg: \""
                               + ve.getMessage() + "\", expected is \"" + msg + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public ValidationException(java.lang.String message, java.lang.Throwable exception),
     * The errorCode will default to null..
     * <br><b>Expected results</b>: errorCode is null
     */
    public Status Ctor011() {
        ValidationException ve = new ValidationException(msg, linkedException);
        if (ve.getErrorCode() != null) {
            return Status.failed("getErrorCode() != null: \""
                               + ve.getErrorCode() + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public ValidationException(java.lang.String message, java.lang.Throwable exception),
     * Construct a ValidationException with the specified linkedException..
     * <br><b>Expected results</b>: linkedException is what set
     */
    public Status Ctor012() {
        ValidationException ve = new ValidationException(msg, linkedException);
        if (ve.getLinkedException() != linkedException) {
            return Status.failed("getLinkedException() != linkedException: \""
                               + ve.getLinkedException() + "\", expected is \"" + linkedException + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public ValidationException(java.lang.Throwable exception),
     * The detail message will default to null..
     * <br><b>Expected results</b>: the message is null
     */
    public Status Ctor013() {
        ValidationException ve = new ValidationException(linkedException);
        if (ve.getMessage() != null) {
            return Status.failed("getMessage() != null: \""
                               + ve.getMessage() + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public ValidationException(java.lang.Throwable exception),
     * The errorCode will default to null..
     * <br><b>Expected results</b>: errorCode is null
     */
    public Status Ctor014() {
        ValidationException ve = new ValidationException(linkedException);
        if (ve.getErrorCode() != null) {
            return Status.failed("getErrorCode() != null: \""
                               + ve.getErrorCode() + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public ValidationException(java.lang.Throwable exception),
     * Construct a ValidationException with the specified linkedException..
     * <br><b>Expected results</b>: linkedException is what set
     */
    public Status Ctor015() {
        ValidationException ve = new ValidationException(linkedException);
        if (ve.getLinkedException() != linkedException) {
            return Status.failed("getLinkedException() != linkedException: \""
                               + ve.getLinkedException() + "\", expected is \"" + linkedException + "\"");
        }

        return Status.passed("OKAY");
    }
}
