/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.provider.visibility;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.spec.provider.visibility.DummyClass;
import ee.jakarta.tck.ws.rs.spec.provider.visibility.DummyWriter;
import ee.jakarta.tck.ws.rs.spec.provider.visibility.HolderClass;
import ee.jakarta.tck.ws.rs.spec.provider.visibility.HolderResolver;
import ee.jakarta.tck.ws.rs.spec.provider.visibility.Resource;
import ee.jakarta.tck.ws.rs.spec.provider.visibility.StringReader;
import ee.jakarta.tck.ws.rs.spec.provider.visibility.TSAppConfig;
import ee.jakarta.tck.ws.rs.spec.provider.visibility.VisibilityException;
import ee.jakarta.tck.ws.rs.spec.provider.visibility.VisibilityExceptionMapper;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JAXRSCommonClient {
    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_spec_provider_visibility_web/resource");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/spec/provider/visibility/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_spec_provider_visibility_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, DummyClass.class, DummyWriter.class, HolderClass.class, HolderResolver.class, StringReader.class, VisibilityException.class, VisibilityExceptionMapper.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void contextResolverTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "contextresolver"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "11111");
        this.invoke();
    }

    @Test
    public void exceptionMapperTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "exceptionmapper"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "11111");
        this.invoke();
    }

    @Test
    public void bodyWriterTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "bodywriter"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "11111");
        this.invoke();
    }

    @Test
    public void bodyReaderTest() throws JAXRSCommonClient.Fault {
        MediaType type = new MediaType("text", "tck");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "bodyreader"));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "text");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(type));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "11111");
        this.invoke();
    }
}

