/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb32.lite.timer.schedule.tx;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb30.timer.common.TimerInfo;
import com.sun.ts.tests.ejb32.lite.timer.schedule.tx.ScheduleTxBeanBase;
import jakarta.annotation.Resource;
import jakarta.ejb.Timer;
import jakarta.ejb.TimerConfig;
import jakarta.transaction.UserTransaction;
import java.io.Serializable;
import java.util.List;

public abstract class ClientBase
extends com.sun.ts.tests.ejb30.timer.common.ClientBase {
    protected ScheduleTxBeanBase scheduleBean;
    protected ScheduleTxBeanBase scheduleBMTBean;
    @Resource
    private UserTransaction ut;

    protected TimerConfig getTimerConfig() {
        TimerConfig timerConfig = new TimerConfig((Serializable)new TimerInfo(this.getTestName()), false);
        return timerConfig;
    }

    public void createRollback() {
        this.createRollback(this.scheduleBean);
    }

    public void createRollbackBMT() {
        this.createRollback(this.scheduleBMTBean);
    }

    public void createRollbackTxPropagation() throws Exception {
        this.ut.begin();
        Timer timer = this.scheduleBean.createSecondLaterTimer(this.getTimerConfig(), 2);
        TestUtil.sleep((int)3000);
        this.ut.rollback();
        this.assertEquals("contains the timer? " + timer, false, this.scheduleBean.getTimers().contains(timer));
        this.passIfNoTimeout(new long[0]);
    }

    public void createRollbackTxPropagationBMT() throws Exception {
        this.ut.begin();
        this.scheduleBMTBean.createSecondLaterTimer(this.getTimerConfig(), 2);
        TestUtil.sleep((int)3000);
        this.ut.rollback();
        this.passIfTimeout(new long[0]);
    }

    public void cancelRollback() {
        this.cancelRollback(this.scheduleBean);
    }

    public void cancelRollbackBMT() {
        this.cancelRollback(this.scheduleBMTBean);
    }

    public void cancelRollbackPropagation() throws Exception {
        Timer timer = this.scheduleBean.createFarFutureTimer(this.getTimerConfig());
        String result = "This timer must still be present, since the tx within which cancellation occurs is rolled back: " + timer;
        this.ut.begin();
        this.scheduleBean.cancelTimer(timer);
        this.ut.rollback();
        this.assertEquals(result, true, this.scheduleBean.getTimers().contains(timer));
        this.scheduleBean.cancelTimer(timer);
        this.assertEquals("contains the timer? " + timer, false, this.scheduleBean.getTimers().contains(timer));
    }

    public void cancelRollbackPropagationBMT() throws Exception {
        Timer timer = this.scheduleBMTBean.createSecondLaterTimer(this.getTimerConfig());
        String result = "This timer must not be present, since the tx is not propagated to BMT bean: " + timer;
        this.ut.begin();
        this.scheduleBMTBean.cancelTimer(timer);
        this.ut.rollback();
        this.assertEquals(result, false, this.scheduleBMTBean.getTimers().contains(timer));
    }

    public void timeoutRollback() {
        this.timeoutRollback(this.scheduleBean);
    }

    public void timeoutSystemException() {
        this.timeoutRollback();
    }

    public void timeoutSystemExceptionBMT() {
        this.timeoutRollback(this.scheduleBMTBean);
    }

    public void createTimerWithoutTx() {
        this.scheduleBMTBean.createSecondLaterTimer(this.getTimerConfig(), 2);
        this.passIfTimeout(new long[0]);
    }

    public void createTimerWithoutTxHavingClientTx() throws Exception {
        this.ut.begin();
        this.scheduleBMTBean.createSecondLaterTimer(this.getTimerConfig(), 2);
        this.ut.commit();
        this.passIfTimeout(new long[0]);
    }

    private void createRollback(ScheduleTxBeanBase b) {
        String result = b.createRollback(this.getTimerConfig());
        this.appendReason(result);
        this.passIfNoTimeout(new long[0]);
    }

    private void cancelRollback(ScheduleTxBeanBase b) {
        Timer timer = b.createFarFutureTimer(this.getTimerConfig());
        String result = b.cancelRollback(this.getTestName());
        this.assertEquals(result, true, b.getTimers().contains(timer));
        b.cancelTimer(timer);
        this.passIfNoTimeout(new long[0]);
    }

    private void timeoutRollback(ScheduleTxBeanBase b) {
        this.appendReason("If the transaction rolls back in timeout method, must retry at least once.");
        Timer timer = b.createSecondLaterTimer(this.getTimerConfig(), 2);
        TestUtil.sleep((int)60000);
        List<String> a = this.statusSingleton.getRecords(this.getTestName());
        this.appendReason("timeout callback result: ", a);
        this.assertGreaterThan(null, a.size(), 1L);
    }
}

