/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.connector.whitebox;

import com.sun.ts.tests.common.connector.util.ConnectorStatus;
import com.sun.ts.tests.common.connector.util.TSMessageListenerInterface;
import com.sun.ts.tests.common.connector.whitebox.Debug;
import com.sun.ts.tests.common.connector.whitebox.LocalTxMessageListener;
import com.sun.ts.tests.common.connector.whitebox.TestBootstrapContext;
import com.sun.ts.tests.common.connector.whitebox.TestWorkManager;
import com.sun.ts.tests.common.connector.whitebox.Util;
import jakarta.resource.spi.ActivationSpec;
import jakarta.resource.spi.BootstrapContext;
import jakarta.resource.spi.ResourceAdapter;
import jakarta.resource.spi.ResourceAdapterInternalException;
import jakarta.resource.spi.endpoint.MessageEndpointFactory;
import jakarta.resource.spi.work.Work;
import jakarta.resource.spi.work.WorkException;
import jakarta.resource.spi.work.WorkManager;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.transaction.xa.XAResource;

public class NoTxResourceAdapterImpl
implements ResourceAdapter,
Serializable {
    private transient TestWorkManager twm;
    private transient TestBootstrapContext tbs;
    private transient LocalTxMessageListener ml;
    private String RAName;
    private Boolean useSecurityMapping = null;
    private int counter = 0;
    private transient XAResource xaresource;
    private transient WorkManager wm;
    private int mefcount = 0;
    private transient MessageEndpointFactory mef1;
    private transient MessageEndpointFactory mef2;
    private transient BootstrapContext bsc;

    public NoTxResourceAdapterImpl() {
        ConnectorStatus.getConnectorStatus().logState("NoTxResourceAdapterImpl Constructor");
        System.out.println("NoTxResourceAdapterImpl Constructor");
    }

    public void start(final BootstrapContext bsc) throws ResourceAdapterInternalException {
        ++this.counter;
        this.bsc = bsc;
        System.out.println("NoTxResourceAdapter Started " + this.counter);
        String str1 = "NoTxResourceAdapter Started " + this.counter;
        ConnectorStatus.getConnectorStatus().logState(str1);
        WorkManager wm = bsc.getWorkManager();
        if (bsc != null) {
            ConnectorStatus.getConnectorStatus().logState("NoTxResourceAdapter BootstrapContext Not Null ");
        }
        if (wm != null) {
            ConnectorStatus.getConnectorStatus().logState("NoTxResourceAdapter WorkManager Not Null ");
        }
        try {
            this.checkAssociation();
            bsc.getWorkManager().startWork(new Work(){

                public void run() {
                    NoTxResourceAdapterImpl.this.myStart(bsc);
                }

                public void release() {
                }
            });
        }
        catch (WorkException we) {
            throw new ResourceAdapterInternalException();
        }
    }

    private void myStart(BootstrapContext ctx) {
        this.wm = ctx.getWorkManager();
        this.twm = new TestWorkManager(ctx);
        if (this.useSecurityMapping.booleanValue()) {
            Debug.trace("NoTxResourceAdapterImpl ; calling setUseSecurityMapping(true)");
            this.twm.setUseSecurityMapping(true);
        } else {
            Debug.trace("NoTxResourceAdapterImpl ; calling setUseSecurityMapping(false)");
            this.twm.setUseSecurityMapping(false);
        }
        this.twm.runTests();
        this.tbs = new TestBootstrapContext(ctx);
        this.tbs.runTests();
    }

    public void endpointActivation(MessageEndpointFactory mef, ActivationSpec as) {
    }

    public void stop() {
    }

    public void endpointDeactivation(MessageEndpointFactory mef, ActivationSpec as) {
    }

    public XAResource[] getXAResources(ActivationSpec[] as) {
        return null;
    }

    private Method getOnMessageMethod() {
        Method onMessageMethod = null;
        try {
            Class<TSMessageListenerInterface> msgListenerClass = TSMessageListenerInterface.class;
            Class[] paramTypes = new Class[]{String.class};
            onMessageMethod = msgListenerClass.getMethod("onMessage", paramTypes);
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        return onMessageMethod;
    }

    private void chkUniqueMessageEndpointFactory() {
        if (this.mef1 != null && !this.mef1.equals(this.mef2)) {
            Debug.trace("NoTx MessageEndpointFactory is Unique");
            Debug.trace("NoTx MessageEndpointFactory equals implemented correctly");
        }
    }

    public void checkAssociation() {
        Vector vLog = ConnectorStatus.getConnectorStatus().getStateLogVector();
        String toCheck1 = "NoTxManagedConnectionFactory setResourceAdapter 1";
        for (int i = 0; i < vLog.size(); ++i) {
            String str = (String)vLog.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            ConnectorStatus.getConnectorStatus().logState("NoTxResourceAdapter - association exists between RA and work");
            break;
        }
    }

    public void setRAName(String name) {
        ConnectorStatus.getConnectorStatus().logState("NoTxResourceAdapter.setRAName");
        this.RAName = name;
    }

    public String getRAName() {
        Debug.trace("NoTxResourceAdapter.getRAName");
        return this.RAName;
    }

    public void setUseSecurityMapping(Boolean val) {
        this.useSecurityMapping = val;
    }

    public Boolean getUseSecurityMapping() {
        return this.useSecurityMapping;
    }

    public void setCounter(int val) {
        this.counter = val;
    }

    public int getCounter() {
        return this.counter;
    }

    public void setMefcount(int val) {
        this.mefcount = val;
    }

    public int getMefcount() {
        return this.mefcount;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof NoTxResourceAdapterImpl)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        NoTxResourceAdapterImpl that = (NoTxResourceAdapterImpl)obj;
        if (this.counter != that.getCounter()) {
            return false;
        }
        if (this.mefcount != that.getMefcount()) {
            return false;
        }
        if (!Util.isEqual(this.RAName, that.getRAName())) {
            return false;
        }
        return this.getUseSecurityMapping().booleanValue() == that.getUseSecurityMapping().booleanValue();
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

