/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.discriminatorValue;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.discriminatorValue.PartProduct;
import ee.jakarta.tck.persistence.core.annotations.discriminatorValue.PricedPartProduct2;
import ee.jakarta.tck.persistence.core.annotations.discriminatorValue.Product;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    private PricedPartProduct2 newPricedPartProduct(String testName) {
        PricedPartProduct2 product = new PricedPartProduct2();
        product.setId(testName);
        product.setName(testName);
        product.setPartNumber(1L);
        product.setPrice(1.0);
        product.setQuantity(1);
        return product;
    }

    private PartProduct newPartProduct(String testName) {
        PartProduct product = new PartProduct();
        product.setId(testName);
        product.setName(testName);
        product.setPartNumber(1L);
        product.setQuantity(1);
        return product;
    }

    private Product newProduct(String testName) {
        Product product = new Product();
        product.setId(testName);
        product.setName(testName);
        product.setQuantity(1);
        return product;
    }

    public void integerDiscriminatorValueTest() throws Exception {
        boolean pass = false;
        String testName = "integerDiscriminatorValueTest";
        try {
            this.getEntityTransaction().begin();
            PricedPartProduct2 p1 = this.newPricedPartProduct("integerDiscriminatorValueTest");
            this.getEntityManager().persist((Object)p1);
            this.getEntityManager().flush();
            this.clearCache();
            PricedPartProduct2 p2 = (PricedPartProduct2)this.getEntityManager().find(PricedPartProduct2.class, (Object)"integerDiscriminatorValueTest");
            this.logTrace("finding PricedPartProduct2 with id 'integerDiscriminatorValueTest'");
            if (p1.equals(p2)) {
                this.logTrace("Received expected PricedPartProduct2:" + p2);
                pass = true;
            } else {
                this.logErr("Did not get expected result.");
                this.logErr("Expected:" + p1);
                this.logErr("Actual:" + p2);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("integerDiscriminatorValueTest Failed");
        }
    }

    public void discriminatorValueTest() throws Exception {
        boolean pass1 = false;
        String testName = "discriminatorValueTest";
        try {
            this.getEntityTransaction().begin();
            PartProduct p1 = this.newPartProduct("discriminatorValueTest");
            this.getEntityManager().persist((Object)p1);
            this.getEntityManager().flush();
            this.clearCache();
            PartProduct p2 = (PartProduct)this.getEntityManager().find(PartProduct.class, (Object)"discriminatorValueTest");
            this.logTrace("finding PartProduct with id 'discriminatorValueTest'");
            if (p1.equals(p2)) {
                this.logTrace("Received expected PartProduct:" + p2);
                pass1 = true;
            } else {
                this.logErr("Did not get expected result.");
                this.logErr("Expected:" + p1);
                this.logErr("Actual:" + p2);
            }
            Product p3 = this.newProduct("discriminatorValueTest");
            this.getEntityManager().persist((Object)p3);
            this.getEntityManager().flush();
            this.clearCache();
            Product p4 = (Product)this.getEntityManager().find(Product.class, (Object)"discriminatorValueTest");
            this.logTrace("finding Product with id 'discriminatorValueTest'");
            if (p3.equals(p4)) {
                this.logTrace("Received expected Product:" + p2);
                pass1 = true;
            } else {
                this.logErr("Did not get expected result.");
                this.logErr("Expected:" + p3);
                this.logErr("Actual:" + p4);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass1) {
            throw new Exception("discriminatorValueTest Failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM PRODUCT_TABLE_DISCRIMINATOR").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PRODUCT_TABLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

