/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jta.ee.transactional;

import com.sun.ts.lib.harness.Fault;
import com.sun.ts.lib.harness.SetupException;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.tests.common.base.EETest;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.common.vehicle.VehicleClient;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;
import com.sun.ts.tests.common.vehicle.VehicleRunnerFactory;
import com.sun.ts.tests.common.vehicle.ejbliteshare.EJBLiteClientIF;
import com.sun.ts.tests.common.vehicle.ejbliteshare.ReasonableStatus;
import com.sun.ts.tests.ejb30.common.lite.EJBLiteJsfClientBase;
import com.sun.ts.tests.ejb30.common.lite.NumberEnum;
import com.sun.ts.tests.ejb30.common.lite.NumberIF;
import com.sun.ts.tests.jta.ee.transactional.CTSDontRollbackException;
import com.sun.ts.tests.jta.ee.transactional.CTSRollbackException;
import com.sun.ts.tests.jta.ee.transactional.Helper;
import com.sun.ts.tests.jta.ee.transactional.HttpServletDelegate;
import com.sun.ts.tests.jta.ee.transactional.OneManagedBean;
import com.sun.ts.tests.jta.ee.transactional.OneManagedQualifier;
import com.sun.ts.tests.jta.ee.transactional.TransactionScopedBean;
import com.sun.ts.tests.jta.ee.transactional.TwoManagedBean;
import com.sun.ts.tests.jta.ee.transactional.TwoManagedQualifier;
import jakarta.annotation.Resource;
import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionRequiredException;
import jakarta.transaction.TransactionalException;
import jakarta.transaction.UserTransaction;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import tck.arquillian.protocol.common.TargetVehicle;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jta"), @Tag(value="platform"), @Tag(value="web"), @Tag(value="tck-javatest")})
@Named(value="client")
@RequestScoped
public class ClientEjblitejsfTest
extends EJBLiteJsfClientBase
implements Serializable {
    static final String VEHICLE_ARCHIVE = "transactional_ejblitejsf_vehicle";
    private static final System.Logger logger = System.getLogger(ClientEjblitejsfTest.class.getName());
    private static final long serialVersionUID = 1L;
    private static StringBuilder callRecords = new StringBuilder();
    @Inject
    @OneManagedQualifier
    OneManagedBean one;
    @Inject
    TransactionScopedBean tscopedBean;
    @Resource(lookup="java:comp/UserTransaction")
    private UserTransaction ut;
    @Inject
    @TwoManagedQualifier
    TwoManagedBean two;

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Override
    @AfterEach
    public void cleanup() {
        logger.log(System.Logger.Level.INFO, "cleanup ok");
    }

    public static void main(String[] args) {
        ClientEjblitejsfTest theTests = new ClientEjblitejsfTest();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @TargetsContainer(value="tck-javatest")
    @OverProtocol(value="javatest")
    @Deployment(name="transactional_ejblitejsf_vehicle", order=2)
    public static WebArchive createDeploymentVehicle() {
        WebArchive transactional_ejblitejsf_vehicle_web = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"transactional_ejblitejsf_vehicle_web.war");
        transactional_ejblitejsf_vehicle_web.addClasses(new Class[]{VehicleRunnerFactory.class, VehicleRunnable.class, VehicleClient.class, EJBLiteClientIF.class, ReasonableStatus.class, com.sun.ts.tests.ejb30.common.helper.Helper.class, NumberEnum.class, EJBLiteJsfClientBase.class, NumberIF.class, Fault.class, EETest.class, SetupException.class, ServiceEETest.class, OneManagedQualifier.class, TwoManagedQualifier.class, TwoManagedBean.class, CTSRollbackException.class, TransactionScopedBean.class, Helper.class, CTSDontRollbackException.class, OneManagedBean.class, HttpServletDelegate.class, ClientEjblitejsfTest.class});
        URL warResURL = ClientEjblitejsfTest.class.getResource("/vehicle/ejblitejsf/ejblitejsf_vehicle_web.xml");
        if (warResURL != null) {
            transactional_ejblitejsf_vehicle_web.addAsWebInfResource(warResURL, "web.xml");
        }
        if ((warResURL = ClientEjblitejsfTest.class.getResource("/vehicle/ejblitejsf/faces-config.xml")) != null) {
            transactional_ejblitejsf_vehicle_web.addAsWebInfResource(warResURL, "faces-config.xml");
        }
        if ((warResURL = ClientEjblitejsfTest.class.getResource("/vehicle/ejblitejsf/beans.xml")) != null) {
            transactional_ejblitejsf_vehicle_web.addAsWebInfResource(warResURL, "beans.xml");
        }
        warResURL = ClientEjblitejsfTest.class.getResource("/vehicle/ejblitejsf/ejblitejsf_vehicle.xhtml");
        transactional_ejblitejsf_vehicle_web.addAsWebResource(warResURL, "/ejblitejsf_vehicle.xhtml");
        return transactional_ejblitejsf_vehicle_web;
    }

    @Test
    @TargetVehicle(value="ejblitejsf")
    public void txTypeRequired_withoutTransaction() throws Exception {
        Helper.assertEquals("\n", "txTypeRequired called successfully", this.one.txTypeRequired(), callRecords);
        this.appendReason(Helper.compareResult("txTypeRequired called successfully", this.one.txTypeRequired()));
    }

    @Test
    @TargetVehicle(value="ejblitejsf")
    public void txTypeRequired_withTransaction() throws Exception {
        try {
            this.ut.begin();
            Helper.assertEquals(null, "txTypeRequired called successfully", this.one.txTypeRequired(), callRecords);
            this.appendReason(Helper.compareResult("txTypeRequired called successfully", this.one.txTypeRequired()));
            this.ut.commit();
        }
        catch (Exception e) {
            Helper.getLogger().log(Level.INFO, null, e);
            throw new Exception("txTypeRequired_withTransaction failed");
        }
    }

    @Test
    @TargetVehicle(value="ejblitejsf")
    public void txTypeRequired_IllegalStateException() throws Exception {
        Helper.assertEquals(null, "IllegalStateException", this.one.txTypeRequiredIllegalStateException(), callRecords);
        this.appendReason(Helper.compareResult("IllegalStateException", this.one.txTypeRequiredIllegalStateException()));
    }

    @Test
    @TargetVehicle(value="ejblitejsf")
    public void txTypeRequiresNew() throws Exception {
        Helper.assertEquals(null, "txTypeRequiresNew called successfully", this.one.txTypeRequiresNew(), callRecords);
        this.appendReason(Helper.compareResult("txTypeRequiresNew called successfully", this.one.txTypeRequiresNew()));
    }

    @Test
    @TargetVehicle(value="ejblitejsf")
    public void txTypeRequiresNew_withTransaction() throws Exception {
        try {
            this.ut.begin();
            Helper.assertEquals(null, "txTypeRequiresNew called successfully", this.one.txTypeRequiresNew(), callRecords);
            this.appendReason(Helper.compareResult("txTypeRequiresNew called successfully", this.one.txTypeRequiresNew()));
            this.ut.commit();
        }
        catch (Exception e) {
            Helper.getLogger().log(Level.INFO, null, e);
            throw new Exception("txTypeRequiresNew_withTransaction failed");
        }
    }

    @Test
    @TargetVehicle(value="ejblitejsf")
    public void txTypeMandatory_withoutTransaction() throws Exception {
        Object result = "TransactionalException not received";
        try {
            Helper.getLogger().info("Invoking OneManagedBean.txTypeManadatory() without a transaction Context");
            this.one.txTypeMandatory();
        }
        catch (TransactionalException te) {
            if (te.getCause() instanceof TransactionRequiredException) {
                result = "Received expected TransactionalException with nested TransactionRequiredException";
            }
            throw new Exception("Received TransactionalException without nested TransactionRequiredExecption");
        }
        catch (Exception e) {
            e.printStackTrace();
            result = "Received unexcepted Exception :" + e.getMessage();
        }
        if (!((String)result).equals("Received expected TransactionalException with nested TransactionRequiredException")) {
            throw new Exception((String)result);
        }
        Helper.getLogger().log(Level.INFO, (String)result);
        this.appendReason("Received expected TransactionalException with nested TransactionRequiredException");
    }

    @Test
    @TargetVehicle(value="ejblitejsf")
    public void txTypeMandatory_withTransaction() throws Exception {
        try {
            this.ut.begin();
            Helper.assertEquals(null, "txTypeMandatory called successfully", this.one.txTypeMandatory(), callRecords);
            this.appendReason(Helper.compareResult("txTypeMandatory called successfully", this.one.txTypeMandatory()));
            this.ut.commit();
        }
        catch (Exception e) {
            Helper.getLogger().log(Level.INFO, null, e);
            throw new Exception("txTypeRequiresNew_withTransaction failed");
        }
    }

    @Test
    @TargetVehicle(value="ejblitejsf")
    public void txTypeSupports_withoutTransaction() throws Exception {
        Helper.assertEquals(null, "txTypeSupports run without active transaction", this.one.txTypeSupportsWithoutTransaction(), callRecords);
        this.appendReason(Helper.compareResult("txTypeSupports run without active transaction", this.one.txTypeSupportsWithoutTransaction()));
    }

    @Test
    @TargetVehicle(value="ejblitejsf")
    public void txTypeSupports_withTransaction() throws Exception {
        try {
            this.ut.begin();
            Helper.assertEquals(null, "txTypeSupports called successfully", this.one.txTypeSupports(), callRecords);
            this.appendReason(Helper.compareResult("txTypeSupports called successfully", this.one.txTypeSupports()));
            this.ut.commit();
        }
        catch (Exception e) {
            Helper.getLogger().log(Level.INFO, null, e);
            throw new Exception("txTypeSupports failed");
        }
    }

    @Test
    @TargetVehicle(value="ejblitejsf")
    public void txTypeNotSupported_withoutTransaction() throws Exception {
        Helper.assertEquals(null, "txTypeNotSupported run without active transaction", this.one.txTypeNotSupported(), callRecords);
        this.appendReason(Helper.compareResult("txTypeNotSupported run without active transaction", this.one.txTypeNotSupported()));
    }

    @Test
    @TargetVehicle(value="ejblitejsf")
    public void txTypeNotSupported_withTransaction() throws Exception {
        try {
            this.ut.begin();
            Helper.assertEquals(null, "txTypeNotSupported run without active transaction", this.one.txTypeNotSupported(), callRecords);
            this.appendReason(Helper.compareResult("txTypeNotSupported run without active transaction", this.one.txTypeNotSupported()));
            this.ut.commit();
        }
        catch (Exception e) {
            Helper.getLogger().log(Level.INFO, null, e);
            throw new Exception("txTypeSupports failed");
        }
    }

    @Test
    @TargetVehicle(value="ejblitejsf")
    public void txTypeNever_withoutTransaction() throws Exception {
        Helper.assertEquals(null, "txTypeNever run without active transaction", this.one.txTypeNever(), callRecords);
        this.appendReason(Helper.compareResult("txTypeNever run without active transaction", this.one.txTypeNever()));
    }

    @Test
    @TargetVehicle(value="ejblitejsf")
    public void txTypeNever_withTransaction() throws Exception {
        Object result = "Expected TransactionalException not received";
        try {
            Helper.getLogger().info("Invoking OneManagedBean.txTypeNever() with a transaction Context");
            this.ut.begin();
            this.one.txTypeNever();
            this.ut.commit();
        }
        catch (TransactionalException te) {
            if (te.getCause() instanceof InvalidTransactionException) {
                result = "Received expected TransactionalException with nested InvalidTransactionException";
            }
            throw new Exception("Received expected TransactionalException without nested InvalidTransactionException");
        }
        catch (Exception e) {
            e.printStackTrace();
            result = "Received unexcepted Exception :" + e.getMessage();
        }
        if (!((String)result).equals("Received expected TransactionalException with nested InvalidTransactionException")) {
            throw new Exception((String)result);
        }
        Helper.getLogger().log(Level.INFO, (String)result);
        this.appendReason("Received expected TransactionalException with nested InvalidTransactionException");
    }

    @Test
    @TargetVehicle(value="ejblitejsf")
    public void rollbackOnException() throws Exception {
        Object result = "failed to set STATUS_MARKED_ROLLBACK on CTSRollbackException";
        try {
            this.ut.begin();
            if (this.ut.getStatus() == 0) {
                Helper.getLogger().info("Current Transaction Status is = " + this.ut.getStatus());
                Helper.getLogger().info("Transaction Status value for Status.STATUS_ACTIVE = 0");
                Helper.getLogger().info("Transaction Status value for Status.STATUS_NO_TRANSACTION = 6");
                Helper.getLogger().info("Transaction Status value for Status.STATUS_MARKED_ROLLBACK = 1");
                Helper.getLogger().info("Calling one.rollbackOnException()");
                this.one.rollbackOnException();
            }
        }
        catch (CTSRollbackException ce) {
            Helper.getLogger().info("Received Expected CTSRollbackException");
            try {
                if (this.ut.getStatus() == 1) {
                    result = "Transaction STATUS_MARKED_ROLLBACK on CTSRollbackException";
                }
                result = "Transaction Status is set to : " + this.ut.getStatus();
            }
            catch (SystemException se) {
                result = "failed to get transaction status";
            }
        }
        catch (Exception e) {
            result = "Received unexpected exception :" + e.getClass();
        }
        if (!((String)result).equals("Transaction STATUS_MARKED_ROLLBACK on CTSRollbackException")) {
            this.appendReason(result);
            throw new Exception((String)result);
        }
        Helper.getLogger().log(Level.INFO, (String)result);
        this.appendReason(result);
    }

    @Test
    @TargetVehicle(value="ejblitejsf")
    public void rollbackOnExceptionTwo() throws Exception {
        Object result = "failed to set STATUS_MARKED_ROLLBACK on CTSRollbackException";
        try {
            this.ut.begin();
            if (this.ut.getStatus() == 0) {
                Helper.getLogger().info("Current Transaction Status is = " + this.ut.getStatus());
                Helper.getLogger().info("Transaction Status value for Status.STATUS_ACTIVE = 0");
                Helper.getLogger().info("Transaction Status value for Status.STATUS_NO_TRANSACTION = 6");
                Helper.getLogger().info("Transaction Status value for Status.STATUS_MARKED_ROLLBACK = 1");
                Helper.getLogger().info("Calling one.rollbackOnException()");
                this.two.rollbackOnException();
            }
        }
        catch (CTSRollbackException ce) {
            Helper.getLogger().info("Received Expected CTSRollbackException");
            try {
                if (this.ut.getStatus() == 1) {
                    result = "Transaction STATUS_MARKED_ROLLBACK on CTSRollbackException";
                }
                result = "Transaction Status is set to : " + this.ut.getStatus();
            }
            catch (SystemException se) {
                result = "failed to get transaction status";
            }
        }
        catch (Exception e) {
            result = "Received unexpected exception :" + e.getClass();
        }
        if (!((String)result).equals("Transaction STATUS_MARKED_ROLLBACK on CTSRollbackException")) {
            this.appendReason(result);
            throw new Exception((String)result);
        }
        Helper.getLogger().log(Level.INFO, (String)result);
        this.appendReason(result);
    }

    @Test
    @TargetVehicle(value="ejblitejsf")
    public void dontRollbackOnException() throws Exception {
        Object result = "";
        try {
            this.ut.begin();
            if (this.ut.getStatus() == 0) {
                Helper.getLogger().info("Current Transaction Status is = " + this.ut.getStatus());
                Helper.getLogger().info("Transaction Status value for Status.STATUS_ACTIVE = 0");
                Helper.getLogger().info("Transaction Status value for Status.STATUS_NO_TRANSACTION = 6");
                Helper.getLogger().info("Transaction Status value for Status.STATUS_MARKED_ROLLBACK = 1");
                Helper.getLogger().info("Calling one.dontRollbackOnException()");
                this.one.dontRollbackOnException();
            }
        }
        catch (CTSDontRollbackException ce) {
            Helper.getLogger().info("Received Expected CTSDontRollbackException");
            try {
                if (this.ut.getStatus() == 0) {
                    result = "Transaction Status not changed on CTSDontRollbackException";
                }
                result = "Transaction Status is set to : " + this.ut.getStatus();
            }
            catch (SystemException se) {
                result = "failed to get transaction status";
            }
        }
        catch (Exception e) {
            result = "Received unexpected exception :" + e.getClass();
            e.printStackTrace();
        }
        if (!((String)result).equals("Transaction Status not changed on CTSDontRollbackException")) {
            this.appendReason(result);
            throw new Exception((String)result);
        }
        Helper.getLogger().log(Level.INFO, (String)result);
        this.appendReason(result);
    }

    @Test
    @TargetVehicle(value="ejblitejsf")
    public void dontRollbackOnExceptionTwo() throws Exception {
        Object result = "";
        try {
            this.ut.begin();
            if (this.ut.getStatus() == 0) {
                Helper.getLogger().info("Current Transaction Status is = " + this.ut.getStatus());
                Helper.getLogger().info("Transaction Status value for Status.STATUS_ACTIVE = 0");
                Helper.getLogger().info("Transaction Status value for Status.STATUS_NO_TRANSACTION = 6");
                Helper.getLogger().info("Transaction Status value for Status.STATUS_MARKED_ROLLBACK = 1");
                Helper.getLogger().info("Calling two.dontRollbackOnException()");
                this.two.dontRollbackOnException();
            }
        }
        catch (CTSDontRollbackException ce) {
            Helper.getLogger().info("Received Expected CTSDontRollbackException");
            try {
                if (this.ut.getStatus() == 0) {
                    result = "Transaction Status not changed on CTSDontRollbackException";
                }
                result = "Transaction Status is set to : " + this.ut.getStatus();
            }
            catch (SystemException se) {
                result = "failed to get transaction status";
            }
        }
        catch (Exception e) {
            result = "Received unexpected exception :" + e.getClass();
            e.printStackTrace();
        }
        if (!((String)result).equals("Transaction Status not changed on CTSDontRollbackException")) {
            this.appendReason(result);
            throw new Exception((String)result);
        }
        Helper.getLogger().log(Level.INFO, (String)result);
        this.appendReason(result);
    }

    @Test
    @TargetVehicle(value="ejblitejsf")
    public void rollbackAndDontRollback() throws Exception {
        Object result = "";
        try {
            this.ut.begin();
            if (this.ut.getStatus() == 0) {
                Helper.getLogger().info("Current Transaction Status is = " + this.ut.getStatus());
                Helper.getLogger().info("Transaction Status value for Status.STATUS_ACTIVE = 0");
                Helper.getLogger().info("Transaction Status value for Status.STATUS_NO_TRANSACTION = 6");
                Helper.getLogger().info("Transaction Status value for Status.STATUS_MARKED_ROLLBACK = 1");
                Helper.getLogger().info("Calling one.rollbackAndDontRollback()");
                this.one.rollbackAndDontRollback();
            }
        }
        catch (CTSRollbackException ce) {
            Helper.getLogger().info("Received Expected CTSRollbackException");
            try {
                if (this.ut.getStatus() == 0) {
                    result = "Transaction Status not changed on CTSRollbackException";
                }
                result = "Transaction Status is set to : " + this.ut.getStatus();
            }
            catch (SystemException se) {
                result = "failed to get transaction status";
            }
        }
        catch (Exception e) {
            result = "Received unexpected exception :" + e.getClass();
        }
        if (!((String)result).equals("Transaction Status not changed on CTSRollbackException")) {
            this.appendReason(result);
            throw new Exception((String)result);
        }
        Helper.getLogger().log(Level.INFO, (String)result);
        this.appendReason(result);
    }

    @Test
    @TargetVehicle(value="ejblitejsf")
    public void rollbackAndDontRollbackTwo() throws Exception {
        Object result = "";
        try {
            this.ut.begin();
            if (this.ut.getStatus() == 0) {
                Helper.getLogger().info("Current Transaction Status is = " + this.ut.getStatus());
                Helper.getLogger().info("Transaction Status value for Status.STATUS_ACTIVE = 0");
                Helper.getLogger().info("Transaction Status value for Status.STATUS_NO_TRANSACTION = 6");
                Helper.getLogger().info("Transaction Status value for Status.STATUS_MARKED_ROLLBACK = 1");
                Helper.getLogger().info("Calling two.rollbackAndDontRollback()");
                this.two.rollbackAndDontRollback();
            }
        }
        catch (CTSRollbackException ce) {
            Helper.getLogger().info("Received Expected CTSRollbackException");
            try {
                if (this.ut.getStatus() == 0) {
                    result = "Transaction Status not changed on CTSRollbackException";
                }
                result = "Transaction Status is set to : " + this.ut.getStatus();
            }
            catch (SystemException se) {
                result = "failed to get transaction status";
            }
        }
        catch (Exception e) {
            result = "Received unexpected exception :" + e.getClass();
        }
        if (!((String)result).equals("Transaction Status not changed on CTSRollbackException")) {
            this.appendReason(result);
            throw new Exception((String)result);
        }
        Helper.getLogger().log(Level.INFO, (String)result);
        this.appendReason(result);
    }

    @Test
    @TargetVehicle(value="ejblitejsf")
    public void transactionScopedBean_withoutTransaction() throws Exception {
        Object result = "ContextNotActiveException not received";
        try {
            Helper.getLogger().info("Invoking TransactionScopedBean.test() without a transaction Context");
            this.tscopedBean.test();
        }
        catch (ContextNotActiveException te) {
            result = "Received expected ContextNotActiveException";
        }
        catch (Exception e) {
            result = "Received unexcepted Exception :" + e.getClass();
            e.printStackTrace();
        }
        if (!((String)result).equals("Received expected ContextNotActiveException")) {
            throw new Exception((String)result);
        }
        Helper.getLogger().log(Level.INFO, (String)result);
        this.appendReason(result);
    }

    @Test
    @TargetVehicle(value="ejblitejsf")
    public void transactionScopedBean_withTransaction() throws Exception {
        Object result = "";
        try {
            this.ut.begin();
            Helper.getLogger().info("Invoking TransactionScopedBean.test() with a transaction Context");
            result = this.tscopedBean.test();
            this.ut.commit();
        }
        catch (Exception e) {
            result = "Received unexcepted Exception :" + e.getClass();
            e.printStackTrace();
        }
        if (!((String)result).equals("TransactionScopedBean.test called with active transaction")) {
            throw new Exception((String)result);
        }
        Helper.getLogger().log(Level.INFO, (String)result);
        this.appendReason(result);
    }

    @Test
    @TargetVehicle(value="ejblitejsf")
    public void getInterceptorPriorityForTxTypeRequired() throws Exception {
        String methodName = "txTypeRequired";
        List<Integer> priorityList = this.one.getPriority(methodName);
        this.verifyInterceptorPriority(priorityList, "TxType.REQUIRED");
    }

    @Test
    @TargetVehicle(value="ejblitejsf")
    public void getInterceptorPriorityForTxTypeRequiresNew() throws Exception {
        String methodName = "txTypeRequiresNew";
        List<Integer> priorityList = this.one.getPriority(methodName);
        this.verifyInterceptorPriority(priorityList, "TxType.REQUIRES_NEW");
    }

    @Test
    @TargetVehicle(value="ejblitejsf")
    public void getInterceptorPriorityForTxTypeMandatory() throws Exception {
        String methodName = "txTypeMandatory";
        List<Integer> priorityList = this.one.getPriority(methodName);
        this.verifyInterceptorPriority(priorityList, "TxType.MANDATORY");
    }

    @Test
    @TargetVehicle(value="ejblitejsf")
    public void getInterceptorPriorityForTxTypeSupports() throws Exception {
        String methodName = "txTypeSupports";
        List<Integer> priorityList = this.one.getPriority(methodName);
        this.verifyInterceptorPriority(priorityList, "TxType.SUPPORTS");
    }

    @Test
    @TargetVehicle(value="ejblitejsf")
    public void getInterceptorPriorityForTxTypeNotSupported() throws Exception {
        String methodName = "txTypeNotSupported";
        List<Integer> priorityList = this.one.getPriority(methodName);
        this.verifyInterceptorPriority(priorityList, "TxType.NOT_SUPPORTED");
    }

    @Test
    @TargetVehicle(value="ejblitejsf")
    public void getInterceptorPriorityForTxTypeNever() throws Exception {
        String methodName = "txTypeNever";
        List<Integer> priorityList = this.one.getPriority(methodName);
        this.verifyInterceptorPriority(priorityList, "TxType.NEVER");
    }

    private void verifyInterceptorPriority(List<Integer> priorityList, String txType) throws Exception {
        String result = null;
        if (!priorityList.contains(200)) {
            throw new Exception("Transactional Interceptor for " + txType + " has incorrect interceptor priority : " + Arrays.toString(priorityList.toArray()) + " Excpected value is :0200");
        }
        Helper.getLogger().log(Level.INFO, "Transactional Interceptor for " + txType + " has right interceptor priority");
        result = "Transactional Interceptor for " + txType + " has right interceptor priority";
        if (result != null) {
            this.appendReason(result);
        }
    }
}

