/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.callStmt.callStmt21;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.Utils;
import com.sun.ts.tests.jdbc.ee.common.csSchema;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class callStmtClient21
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.callStmt.callStmt21";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private DataSource ds1 = null;
    private csSchema csSch = null;
    private rsSchema rsSch = null;
    private String drManager = null;
    private Properties sqlp = null;
    private CallableStatement cstmt = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        callStmtClient21 theTests = new callStmtClient21();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                this.sqlp = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.rsSch = new rsSchema();
                this.csSch = new csSchema();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter29() throws Exception {
        byte[] retByteArr = null;
        boolean byteArrFlag = false;
        String longvarbinarySize = null;
        try {
            this.rsSch.createTab("Longvarbinary_Tab", this.sqlp, this.conn);
            longvarbinarySize = this.sqlp.getProperty("longvarbinarySize");
            this.msg.setMsg("Longvarbinary Table Size : " + longvarbinarySize);
            int bytearrsize = Integer.parseInt(longvarbinarySize);
            this.msg.setMsg("Varbinary Size : " + bytearrsize);
            byte[] bytearr = new byte[bytearrsize];
            String sbyteval = null;
            for (int count = 0; count < bytearrsize; ++count) {
                sbyteval = Integer.toString(count % 255);
                bytearr[count] = Byte.parseByte(sbyteval);
            }
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Longvarbinary_Io(?)}");
            this.cstmt.setBytes(1, bytearr);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -4);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getBytes method");
            retByteArr = this.cstmt.getBytes(1);
            for (int i = 0; i < bytearrsize; ++i) {
                this.msg.addOutputMsg(Byte.toString(bytearr[i]), Byte.toString(retByteArr[i]));
                if (retByteArr[i] == bytearr[i]) continue;
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed!");
            }
            this.msg.setMsg("registerOutParameter registers the OUT parameter");
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Longvarbinary_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter30() throws Exception {
        try {
            this.rsSch.createTab("Double_Tab", this.sqlp, this.conn);
            String sMaxDoubleVal = this.rsSch.extractVal("Double_Tab", 1, this.sqlp, this.conn);
            Double maxDoubleVal = new Double(sMaxDoubleVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Double_Io_Null(?)}");
            this.cstmt.setDouble(1, (double)maxDoubleVal);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 8);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            Double oRetVal = (Double)this.cstmt.getObject(1);
            this.msg.addOutputMsg("" + maxDoubleVal, "" + oRetVal);
            if (maxDoubleVal.equals(oRetVal)) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Double_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter31() throws Exception {
        try {
            this.rsSch.createTab("Double_Tab", this.sqlp, this.conn);
            String sMinDoubleVal = this.rsSch.extractVal("Double_Tab", 2, this.sqlp, this.conn);
            Double minDoubleVal = new Double(sMinDoubleVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Double_Io_Max(?)}");
            this.cstmt.setDouble(1, (double)minDoubleVal);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 8);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            Double oRetVal = (Double)this.cstmt.getObject(1);
            this.msg.addOutputMsg("" + minDoubleVal, "" + oRetVal);
            if (minDoubleVal.equals(oRetVal)) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Double_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter32() throws Exception {
        try {
            this.rsSch.createTab("Float_Tab", this.sqlp, this.conn);
            String sMaxFloatVal = this.rsSch.extractVal("Float_Tab", 1, this.sqlp, this.conn);
            Float maxFloatVal = Float.valueOf(sMaxFloatVal);
            Double doubleVal = Double.valueOf(sMaxFloatVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Float_Io_Null(?)}");
            this.cstmt.setDouble(1, (double)doubleVal);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 6);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            Double oRetVal = (Double)this.cstmt.getObject(1);
            this.msg.addOutputMsg("" + doubleVal, "" + oRetVal);
            if (Utils.isMatchingFloatingPointVal(doubleVal, oRetVal)) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Float_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter33() throws Exception {
        try {
            this.rsSch.createTab("Float_Tab", this.sqlp, this.conn);
            String sMinFloatVal = this.rsSch.extractVal("Float_Tab", 2, this.sqlp, this.conn);
            Double minFloatVal = Double.valueOf(sMinFloatVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Float_Io_Max(?)}");
            this.cstmt.setDouble(1, (double)minFloatVal);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 8);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            Double oRetVal = (Double)this.cstmt.getObject(1);
            this.msg.addOutputMsg("" + minFloatVal, "" + oRetVal);
            if (Utils.isMatchingFloatingPointVal(minFloatVal, oRetVal)) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Float_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter34() throws Exception {
        try {
            this.rsSch.createTab("Real_Tab", this.sqlp, this.conn);
            String sMaxRealVal = this.rsSch.extractVal("Real_Tab", 1, this.sqlp, this.conn);
            Float maxRealVal = new Float(sMaxRealVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Real_Io_Null(?)}");
            this.cstmt.setFloat(1, maxRealVal.floatValue());
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 7);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            Float oRetVal = (Float)this.cstmt.getObject(1);
            this.msg.addOutputMsg("" + maxRealVal, "" + oRetVal);
            if (maxRealVal.equals(oRetVal)) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Real_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter35() throws Exception {
        try {
            this.rsSch.createTab("Real_Tab", this.sqlp, this.conn);
            String sMinRealVal = this.rsSch.extractVal("Real_Tab", 2, this.sqlp, this.conn);
            Float minRealVal = new Float(sMinRealVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Real_Io_Max(?)}");
            this.cstmt.setFloat(1, minRealVal.floatValue());
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 7);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            Float oRetVal = (Float)this.cstmt.getObject(1);
            this.msg.addOutputMsg("" + minRealVal, "" + oRetVal);
            if (minRealVal.equals(oRetVal)) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Real_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter36() throws Exception {
        Boolean oMaxBooleanVal = null;
        String smaxBooleanVal = null;
        String rStringVal = null;
        try {
            this.rsSch.createTab("Bit_Tab", this.sqlp, this.conn);
            smaxBooleanVal = this.rsSch.extractValAsNumericString("Bit_Tab", 1, this.sqlp, this.conn);
            oMaxBooleanVal = this.rsSch.extractValAsBoolObj("Bit_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Bit_Io_Null(?)}");
            this.cstmt.setBoolean(1, (boolean)oMaxBooleanVal);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -7);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            rStringVal = this.cstmt.getObject(1).toString();
            rStringVal = rStringVal.trim();
            if (rStringVal.equals(oMaxBooleanVal.toString()) || rStringVal.equals(smaxBooleanVal.trim())) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Bit_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter37() throws Exception {
        String sminBooleanVal = null;
        Boolean oMinBooleanVal = null;
        String rStringVal = null;
        try {
            this.rsSch.createTab("Bit_Tab", this.sqlp, this.conn);
            sminBooleanVal = this.rsSch.extractValAsNumericString("Bit_Tab", 2, this.sqlp, this.conn);
            oMinBooleanVal = this.rsSch.extractValAsBoolObj("Bit_Tab", 2, this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Bit_Io_Max(?)}");
            this.cstmt.setBoolean(1, (boolean)oMinBooleanVal);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -7);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            rStringVal = this.cstmt.getObject(1).toString();
            rStringVal = rStringVal.trim();
            if (rStringVal.equals(oMinBooleanVal.toString()) || rStringVal.equals(sminBooleanVal.trim())) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Bit_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter38() throws Exception {
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            String sMaxByteVal = this.rsSch.extractVal("Smallint_Tab", 1, this.sqlp, this.conn);
            Short maxByteVal = new Short(sMaxByteVal);
            Integer imaxByteVal = new Integer(sMaxByteVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Smallint_Io_Null(?)}");
            this.cstmt.setShort(1, (short)maxByteVal);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 5);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            String sRetVal = "" + this.cstmt.getObject(1);
            this.msg.addOutputMsg(sMaxByteVal, sRetVal);
            if (sMaxByteVal.trim().equals(sRetVal.trim())) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter39() throws Exception {
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            String sMinByteVal = this.rsSch.extractVal("Smallint_Tab", 2, this.sqlp, this.conn);
            Short minByteVal = new Short(sMinByteVal);
            Integer iminByteVal = new Integer(sMinByteVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Smallint_Io_Max(?)}");
            this.cstmt.setShort(1, (short)minByteVal);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 5);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            String sRetVal = "" + this.cstmt.getObject(1);
            this.msg.addOutputMsg(sMinByteVal, sRetVal);
            if (sMinByteVal.trim().equals(sRetVal.trim())) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter40() throws Exception {
        try {
            this.rsSch.createTab("Tinyint_Tab", this.sqlp, this.conn);
            String sMaxShortVal = this.rsSch.extractVal("Tinyint_Tab", 1, this.sqlp, this.conn);
            Byte maxShortVal = new Byte(sMaxShortVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Tinyint_Io_Null(?)}");
            this.cstmt.setByte(1, (byte)maxShortVal);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -6);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            Object obj = this.cstmt.getObject(1);
            Byte oRetVal = new Byte(obj.toString());
            this.msg.addOutputMsg("" + maxShortVal, "" + oRetVal);
            if (maxShortVal.compareTo(oRetVal) == 0) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Tinyint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter41() throws Exception {
        try {
            this.rsSch.createTab("Tinyint_Tab", this.sqlp, this.conn);
            String sMinShortVal = this.rsSch.extractVal("Tinyint_Tab", 2, this.sqlp, this.conn);
            Byte minShortVal = new Byte(sMinShortVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Tinyint_Io_Max(?)}");
            this.cstmt.setByte(1, (byte)minShortVal);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -6);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            Object obj = this.cstmt.getObject(1);
            Byte oRetVal = new Byte(obj.toString());
            this.msg.addOutputMsg("" + minShortVal, "" + oRetVal);
            if (minShortVal.compareTo(oRetVal) == 0) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Tinyint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter42() throws Exception {
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            String sMaxIntegerVal = this.rsSch.extractVal("Integer_Tab", 1, this.sqlp, this.conn);
            Integer maxIntegerVal = new Integer(sMaxIntegerVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Integer_Io_Null(?)}");
            this.cstmt.setInt(1, (int)maxIntegerVal);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 4);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            Integer oRetVal = (Integer)this.cstmt.getObject(1);
            this.msg.addOutputMsg("" + maxIntegerVal, "" + oRetVal);
            if (maxIntegerVal.equals(oRetVal)) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter43() throws Exception {
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            String sMinIntegerVal = this.rsSch.extractVal("Integer_Tab", 2, this.sqlp, this.conn);
            Integer minIntegerVal = new Integer(sMinIntegerVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Integer_Io_Max(?)}");
            this.cstmt.setInt(1, (int)minIntegerVal);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 4);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            Integer oRetVal = (Integer)this.cstmt.getObject(1);
            this.msg.addOutputMsg("" + minIntegerVal, "" + oRetVal);
            if (minIntegerVal.equals(oRetVal)) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter44() throws Exception {
        try {
            this.rsSch.createTab("Bigint_Tab", this.sqlp, this.conn);
            String sMaxLongVal = this.rsSch.extractVal("Bigint_Tab", 1, this.sqlp, this.conn);
            Long maxLongVal = new Long(sMaxLongVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Bigint_Io_Null(?)}");
            this.cstmt.setLong(1, (long)maxLongVal);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -5);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            Long oRetVal = (Long)this.cstmt.getObject(1);
            this.msg.addOutputMsg("" + maxLongVal, "" + oRetVal);
            if (maxLongVal.equals(oRetVal)) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Bigint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter45() throws Exception {
        try {
            this.rsSch.createTab("Bigint_Tab", this.sqlp, this.conn);
            String sMinLongVal = this.rsSch.extractVal("Bigint_Tab", 2, this.sqlp, this.conn);
            Long minLongVal = new Long(sMinLongVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Bigint_Io_Max(?)}");
            this.cstmt.setLong(1, (long)minLongVal);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -5);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            Long oRetVal = (Long)this.cstmt.getObject(1);
            this.msg.addOutputMsg("" + minLongVal, "" + oRetVal);
            if (minLongVal.equals(oRetVal)) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Bigint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter46() throws Exception {
        try {
            this.rsSch.createTab("Char_Tab", this.sqlp, this.conn);
            String sCoffeeName = this.rsSch.extractVal("Char_Tab", 1, this.sqlp, this.conn);
            sCoffeeName = sCoffeeName.substring(1, sCoffeeName.length() - 1);
            sCoffeeName = sCoffeeName.trim();
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Char_Io_Null(?)}");
            this.cstmt.setString(1, sCoffeeName.toString());
            int precision = sCoffeeName.length();
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 1, precision);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            String oRetVal = (String)this.cstmt.getObject(1);
            oRetVal = oRetVal.trim();
            this.msg.addOutputMsg(sCoffeeName, oRetVal);
            if (sCoffeeName.equals(oRetVal)) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Char_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testRegisterOutParameter47() throws Exception {
        try {
            this.rsSch.createTab("Varchar_Tab", this.sqlp, this.conn);
            String sCoffeeName = this.rsSch.extractVal("Varchar_Tab", 1, this.sqlp, this.conn);
            sCoffeeName = sCoffeeName.substring(1, sCoffeeName.length() - 1);
            sCoffeeName = sCoffeeName.trim();
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Varchar_Io_Null(?)}");
            this.cstmt.setString(1, sCoffeeName.toString());
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 12);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            String oRetVal = (String)this.cstmt.getObject(1);
            oRetVal = oRetVal.trim();
            this.msg.addOutputMsg(sCoffeeName, oRetVal);
            if (sCoffeeName.equals(oRetVal)) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Varchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testRegisterOutParameter48() throws Exception {
        try {
            this.rsSch.createTab("Longvarcharnull_Tab", this.sqlp, this.conn);
            String sCoffeeName = this.rsSch.extractVal("Longvarchar_Tab", 1, this.sqlp, this.conn);
            sCoffeeName = sCoffeeName.substring(1, sCoffeeName.length() - 1);
            sCoffeeName = sCoffeeName.trim();
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Lvarchar_Io_Null(?)}");
            this.cstmt.setString(1, sCoffeeName.toString());
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -1);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            String oRetVal = (String)this.cstmt.getObject(1);
            oRetVal = oRetVal.trim();
            this.msg.addOutputMsg(sCoffeeName, oRetVal);
            if (sCoffeeName.equals(oRetVal)) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Longvarcharnull_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void cleanup() throws Exception {
        try {
            this.rsSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

