/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.timer.schedule.lifecycle;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.timer.common.ClientBase;
import com.sun.ts.tests.ejb30.timer.schedule.lifecycle.ScheduleBean;
import jakarta.ejb.EJB;
import jakarta.ejb.NoSuchObjectLocalException;
import jakarta.ejb.ScheduleExpression;
import jakarta.ejb.Timer;
import jakarta.ejb.TimerHandle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;

public class Client
extends ClientBase {
    public static final String TIMER_STORE_DIR = System.getProperty("java.io.tmpdir");
    public static final String TIMER_STORE_NAME = "ts-ejb30-timer.ser";
    public static final File TIMER_STORE = new File(TIMER_STORE_DIR, "ts-ejb30-timer.ser");
    @EJB(beanName="ScheduleBean")
    private ScheduleBean scheduleBean;

    private void deleteTimerStore() {
        if (TIMER_STORE.exists()) {
            boolean deleted = TIMER_STORE.delete();
            if (deleted) {
                Helper.getLogger().info("Deleted existing TIMER_STORE file: " + TIMER_STORE.getAbsolutePath());
            } else {
                Helper.getLogger().info("Failed to delete TIMER_STORE: " + TIMER_STORE.getAbsolutePath());
            }
        }
    }

    private void writeTimerHandle(TimerHandle handle) throws IOException {
        try (ObjectOutputStream out = null;){
            out = new ObjectOutputStream(new FileOutputStream(TIMER_STORE));
            out.writeObject(handle);
        }
    }

    private TimerHandle readTimerHandle() throws IOException, ClassNotFoundException {
        Object obj;
        try (ObjectInputStream in = null;){
            in = new ObjectInputStream(new FileInputStream(TIMER_STORE));
            obj = in.readObject();
        }
        return (TimerHandle)obj;
    }

    public void timerHandle() throws IOException, ClassNotFoundException {
        this.deleteTimerStore();
        Timer t = this.scheduleBean.findTimer("year5000");
        TimerHandle handle = this.scheduleBean.getTimerHandle(t);
        this.appendReason(" Got TimerHandle: " + handle);
        this.writeTimerHandle(handle);
        this.appendReason(" Serialized it to " + TIMER_STORE.getAbsolutePath());
        handle = this.readTimerHandle();
        this.appendReason(" Read it from TIMER_STORE ");
        this.appendReason(this.scheduleBean.compareTimer(handle));
        this.scheduleBean.cancelTimer(handle);
        this.appendReason(" Auto timer cancelled.");
        this.assertEquals("Confirm the timer no long exists", null, this.scheduleBean.findTimer("year5000"));
        this.appendReason(this.scheduleBean.getTimerExpired(handle));
    }

    public void timerHandleIllegalStateException() {
        this.appendReason(this.scheduleBean.timerHandleIllegalStateException());
    }

    public void isCalendarTimerAndGetSchedule() {
        this.appendReason(this.scheduleBean.isCalendarTimerAndGetSchedule());
    }

    public void timerEquals() {
        ScheduleExpression exp = new ScheduleExpression();
        Timer t2 = this.scheduleBean.createFarFutureTimer(this.getTestName());
        Timer t3 = this.scheduleBean.createTimer(exp, this.getTestName());
        Timer t4 = this.scheduleBean.createTimer(exp, this.getTestName());
        String t1Name = this.getTestName() + "t1";
        Timer t1 = this.scheduleBean.createSecondLaterTimer(t1Name);
        Timer t1Found = this.scheduleBean.findTimer(t1Name);
        this.assertEquals("Compare timer to itself.", t1, t1);
        this.assertEquals("Compare timer to t1Found.", t1, t1Found);
        this.assertNotEquals("Compare timer to null.", t1, null);
        this.assertNotEquals("Compare timer to 1.", t1, 1);
        this.assertNotEquals("Compare timer to true.", t1, true);
        try {
            TimerHandle timerHandle = this.scheduleBean.getTimerHandle(t1);
            this.assertNotEquals("Compare timer to TimerHandle.", t1, timerHandle);
            this.assertNotEquals("Compare TimerHandle to timer.", timerHandle, t1);
        }
        catch (NoSuchObjectLocalException ex) {
            ex.printStackTrace();
        }
        this.assertNotEquals("Compare 2 timers.", t1, t2);
        this.assertNotEquals("Compare timer 3 to timer 4.", t3, t4);
        try {
            this.scheduleBean.cancelTimer(t1, t2, t3, t4);
        }
        catch (NoSuchObjectLocalException ex) {
            ex.printStackTrace();
        }
    }

    public void timerHash() throws IOException, ClassNotFoundException {
        this.deleteTimerStore();
        Timer t = this.scheduleBean.createSecondLaterTimer(this.getTestName());
        TimerHandle handle = this.scheduleBean.getTimerHandle(t);
        HashSet<Timer> h = new HashSet<Timer>();
        h.add(t);
        this.appendReason(" Got TimerHandle: " + handle);
        this.writeTimerHandle(handle);
        this.appendReason(" Serialized it to " + TIMER_STORE.getAbsolutePath());
        handle = this.readTimerHandle();
        this.appendReason(" Read it from TIMER_STORE ");
        if (!h.contains(this.scheduleBean.getTimer(handle))) {
            throw new RuntimeException("Failed to find the deserialize timer in the HashSet.");
        }
        this.appendReason("Found the deserialize timer in the HashSet.");
        this.scheduleBean.cancelTimer(t);
    }

    public void createAndComplete() {
        this.scheduleBean.createSecondLaterTimer(this.getTestName());
        this.appendReason("Created a timer and wait for its completion.");
        this.passIfTimeoutOnce(new long[0]);
    }

    public void completeAndNoSuchObjectLocalException() {
        Timer t = this.scheduleBean.createSecondLaterTimer(this.getTestName());
        this.passIfTimeoutOnce(new long[0]);
        this.appendReason(this.scheduleBean.passIfNoSuchObjectLocalException(t));
    }

    public void cancelAndNoSuchObjectLocalException() {
        Timer t = this.scheduleBean.createFarFutureTimer(this.getTestName());
        this.scheduleBean.cancelTimerWithNoTransaction(t);
        this.appendReason(this.scheduleBean.passIfNoSuchObjectLocalException(t));
    }

    public void cancelWithTxAndNoSuchObjectLocalException() {
        Timer t = this.scheduleBean.createFarFutureTimer(this.getTestName());
        this.scheduleBean.cancelTimer(t);
        this.appendReason(this.scheduleBean.passIfNoSuchObjectLocalException(t));
    }
}

