/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.common.allowed.stateful;

import com.sun.ts.tests.ejb30.common.allowed.stateful.TimerLocalIF;
import com.sun.ts.tests.ejb30.common.helper.TLogger;
import jakarta.annotation.Resource;
import jakarta.ejb.EJBException;
import jakarta.ejb.Local;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Stateless;
import jakarta.ejb.Timeout;
import jakarta.ejb.Timer;
import jakarta.ejb.TimerHandle;
import jakarta.ejb.TimerService;
import jakarta.ejb.TransactionAttribute;
import jakarta.ejb.TransactionAttributeType;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

@Stateless(name="TimerEJB")
@Local(value={TimerLocalIF.class})
public class TimerEJB
implements TimerLocalIF {
    private SessionContext sessionContext;

    @Resource
    public void setSessionContext(SessionContext sc) {
        this.sessionContext = sc;
    }

    @Timeout
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    private void ejbTimeout(Timer timer) {
    }

    @Override
    public TimerHandle startTimer(long duration, String info) {
        try {
            TimerService ts = this.sessionContext.getTimerService();
            TLogger.logTrace("create Timer");
            Timer t = ts.createTimer(duration, (Serializable)((Object)info));
            return t.getHandle();
        }
        catch (Exception e) {
            TLogger.printStackTrace(e);
            throw new EJBException("startTimer:" + e);
        }
    }

    @Override
    public void findAndCancelTimer() {
        Collection ccol = null;
        try {
            TLogger.logTrace("findAndCancelTimer method entered");
            TimerService ts = this.sessionContext.getTimerService();
            TLogger.logTrace("getTimers");
            ccol = ts.getTimers();
            if (!ccol.isEmpty()) {
                TLogger.logTrace("Timer Collection Not Empty");
                Iterator i = ccol.iterator();
                while (i.hasNext()) {
                    TLogger.logTrace("Looking up next timer");
                    Timer t = (Timer)i.next();
                    TLogger.logTrace("Cancel timer with info: " + t.getInfo());
                    t.cancel();
                }
            } else {
                TLogger.logTrace("Timer Collection is Empty");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

