/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.shared.common.error.StandardException;

class DropViewNode
extends DDLStatementNode {
    DropViewNode(TableName tableName, ContextManager contextManager) {
        super(tableName, contextManager);
    }

    @Override
    String statementToString() {
        return "DROP VIEW";
    }

    @Override
    public void bindStatement() throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        CompilerContext compilerContext = this.getCompilerContext();
        TableDescriptor tableDescriptor = dataDictionary.getTableDescriptor(this.getRelativeName(), this.getSchemaDescriptor(), this.getLanguageConnectionContext().getTransactionCompile());
        if (tableDescriptor != null) {
            compilerContext.createDependency(tableDescriptor);
        }
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getDropViewConstantAction(this.getFullName(), this.getRelativeName(), this.getSchemaDescriptor());
    }
}

