/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.security.services.common;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.security.services.common.SecurityAccessPermissionCollection;

public class SecureServiceAccessPermission
extends BasicPermission {
    private static final long serialVersionUID = -274181305911341984L;
    public static final String RW_ACTION = "read,write";
    public static final String READ_ACTION = "read";
    public static final String WRITE_ACTION = "write";
    private static final Logger _log = Logger.getLogger("org.glassfish.security.services");
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SecureServiceAccessPermission.class);
    private static final int READ = 1;
    private static final int WRITE = 2;
    private static final int ALL = 3;
    private static final int NONE = 0;
    private transient int mask;
    private transient boolean wildcard;
    private transient String path;
    private String target;
    private String actions;

    public SecureServiceAccessPermission(String accessPermissionName) {
        this(accessPermissionName, null);
    }

    public SecureServiceAccessPermission(String accessPermissionName, String actions) {
        super(accessPermissionName, actions);
        this.actions = actions;
        this.initWildCardPath(accessPermissionName);
        this.init(SecureServiceAccessPermission.getMask(actions));
    }

    public SecureServiceAccessPermission(String accessPermissionName, String actions, String targetName) {
        this(accessPermissionName, actions);
        this.target = targetName;
    }

    private void init(int mask) {
        if ((mask & 3) != mask) {
            throw new IllegalArgumentException(localStrings.getLocalString("perm.invalid.action", "invalid actions mask"));
        }
        if (this.getName() == null) {
            throw new NullPointerException(localStrings.getLocalString("perm.null.name", "name can't be null"));
        }
        this.mask = mask;
    }

    private static int getMask(String actions) {
        int mask = 0;
        if (actions == null) {
            return mask;
        }
        if (actions.equalsIgnoreCase(READ_ACTION)) {
            return 1;
        }
        if (actions.equalsIgnoreCase(WRITE_ACTION)) {
            return 2;
        }
        if (actions.equalsIgnoreCase(RW_ACTION)) {
            return 3;
        }
        char[] a = actions.toCharArray();
        int i = a.length - 1;
        if (i < 0) {
            return mask;
        }
        while (i != -1) {
            int matchlen;
            char c;
            while (i != -1 && ((c = a[i]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) {
                --i;
            }
            if (!(i < 3 || a[i - 3] != 'r' && a[i - 3] != 'R' || a[i - 2] != 'e' && a[i - 2] != 'E' || a[i - 1] != 'a' && a[i - 1] != 'A' || a[i] != 'd' && a[i] != 'D')) {
                matchlen = 4;
                mask |= 1;
            } else if (!(i < 4 || a[i - 4] != 'w' && a[i - 4] != 'W' || a[i - 3] != 'r' && a[i - 3] != 'R' || a[i - 2] != 'i' && a[i - 2] != 'I' || a[i - 1] != 't' && a[i - 1] != 'T' || a[i] != 'e' && a[i] != 'E')) {
                matchlen = 5;
                mask |= 2;
            } else {
                throw new IllegalArgumentException(localStrings.getLocalString("perm.invalid.action", "invalid actions: {0}", new Object[]{actions}));
            }
            boolean seencomma = false;
            while (i >= matchlen && !seencomma) {
                switch (a[i - matchlen]) {
                    case ',': {
                        seencomma = true;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(localStrings.getLocalString("perm.invalid.actions", "invalid actions: {0}", new Object[]{actions}));
                    }
                }
                --i;
            }
            i -= matchlen;
        }
        return mask;
    }

    @Override
    public String getActions() {
        return this.actions;
    }

    int getActionMask() {
        return this.mask;
    }

    public String getTarget() {
        return this.target;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SecureServiceAccessPermission sp = (SecureServiceAccessPermission)obj;
        return SecureServiceAccessPermission.twoStringEq(this.getName(), sp.getName()) && this.mask == sp.getActionMask() && SecureServiceAccessPermission.twoStringEq(this.getTarget(), sp.getTarget());
    }

    private static boolean twoStringEq(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public boolean implies(Permission p) {
        boolean result;
        if (p == null || p.getClass() != this.getClass()) {
            return false;
        }
        if (!(p instanceof SecureServiceAccessPermission)) {
            return false;
        }
        SecureServiceAccessPermission that = (SecureServiceAccessPermission)p;
        boolean bl = result = (this.mask & that.mask) == that.mask && this.nameImplies(that);
        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, "Implies for permission " + String.valueOf(p) + " return " + result);
        }
        return result;
    }

    private boolean nameImplies(SecureServiceAccessPermission that) {
        if (this.wildcard) {
            if (that.wildcard) {
                return that.path.startsWith(this.path);
            }
            return that.path.length() > this.path.length() && that.path.startsWith(this.path);
        }
        if (that.wildcard) {
            return false;
        }
        return this.path.equals(that.path);
    }

    private void initWildCardPath(String name) {
        if (name == null) {
            throw new NullPointerException(localStrings.getLocalString("perm.null.name", "name can't be null"));
        }
        int len = name.length();
        if (len == 0) {
            throw new IllegalArgumentException(localStrings.getLocalString("perm.empty.name", "name can't be empty"));
        }
        char last = name.charAt(len - 1);
        if (last == '*' && (len == 1 || name.charAt(len - 2) == '/')) {
            this.wildcard = true;
            this.path = len == 1 ? "" : name.substring(0, len - 1);
        } else {
            this.path = name;
        }
    }

    final String getCanonicalName() {
        return this.getName();
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new SecurityAccessPermissionCollection(this.getClass(), _log, localStrings);
    }
}

