/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor.jvm;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="memory-mon", group="monitoring")
@ManagedObject
@Description(value="JVM Memory Statistics")
public class JVMMemoryStatsProvider {
    private MemoryMXBean memBean = ManagementFactory.getMemoryMXBean();
    private CountStatisticImpl committedHeap = new CountStatisticImpl("CommittedHeapSize", "bytes", "Amount of memory in bytes that is committed for the Java virtual machine to use");
    private CountStatisticImpl initHeap = new CountStatisticImpl("InitialHeapSize", "bytes", "Amount of memory in bytes that the Java virtual machine initially requests from the operating system for memory management");
    private CountStatisticImpl maxHeap = new CountStatisticImpl("MaxHeapSize", "bytes", "Maximum amount of memory in bytes that can be used for memory management");
    private CountStatisticImpl usedHeap = new CountStatisticImpl("UsedHeapSize", "bytes", "Amount of used memory in bytes");
    private CountStatisticImpl committedNonHeap = new CountStatisticImpl("CommittedNonHeapSize", "bytes", "Amount of memory in bytes that is committed for the Java virtual machine to use");
    private CountStatisticImpl initNonHeap = new CountStatisticImpl("InitialNonHeapSize", "bytes", "Amount of memory in bytes that the Java virtual machine initially requests from the operating system for memory management");
    private CountStatisticImpl maxNonHeap = new CountStatisticImpl("MaxNonHeapSize", "bytes", "Maximum amount of memory in bytes that can be used for memory management");
    private CountStatisticImpl usedNonHeap = new CountStatisticImpl("UsedNonHeapSize", "bytes", "Amount of used memory in bytes");
    private CountStatisticImpl objectPendingFinalizationCount = new CountStatisticImpl("ObjectsPendingFinalization", "count", "Approximate number of objects for which finalization is pending");

    @ManagedAttribute(id="committedheapsize-count")
    @Description(value="amount of memory in bytes that is committed for the Java virtual machine to use")
    public CountStatistic getCommittedHeap() {
        this.committedHeap.setCount(this.memBean.getHeapMemoryUsage().getCommitted());
        return this.committedHeap;
    }

    @ManagedAttribute(id="initheapsize-count")
    @Description(value="amount of memory in bytes that the Java virtual machine initially requests from the operating system for memory management")
    public CountStatistic getInitHeap() {
        this.initHeap.setCount(this.memBean.getHeapMemoryUsage().getInit());
        return this.initHeap;
    }

    @ManagedAttribute(id="maxheapsize-count")
    @Description(value="maximum amount of memory in bytes that can be used for memory management")
    public CountStatistic getMaxHeap() {
        this.maxHeap.setCount(this.memBean.getHeapMemoryUsage().getMax());
        return this.maxHeap;
    }

    @ManagedAttribute(id="usedheapsize-count")
    @Description(value="amount of used memory in bytes")
    public CountStatistic getUsedHeap() {
        this.usedHeap.setCount(this.memBean.getHeapMemoryUsage().getUsed());
        return this.usedHeap;
    }

    @ManagedAttribute(id="committednonheapsize-count")
    @Description(value="amount of memory in bytes that is committed for the Java virtual machine to use")
    public CountStatistic getCommittedNonHeap() {
        this.committedNonHeap.setCount(this.memBean.getNonHeapMemoryUsage().getCommitted());
        return this.committedNonHeap;
    }

    @ManagedAttribute(id="initnonheapsize-count")
    @Description(value="amount of memory in bytes that the Java virtual machine initially requests from the operating system for memory management")
    public CountStatistic getInitNonHeap() {
        this.initNonHeap.setCount(this.memBean.getNonHeapMemoryUsage().getInit());
        return this.initNonHeap;
    }

    @ManagedAttribute(id="maxnonheapsize-count")
    @Description(value="maximum amount of memory in bytes that can be used for memory management")
    public CountStatistic getMaxNonHeap() {
        this.maxNonHeap.setCount(this.memBean.getNonHeapMemoryUsage().getMax());
        return this.maxNonHeap;
    }

    @ManagedAttribute(id="usednonheapsize-count")
    @Description(value="amount of used memory in bytes")
    public CountStatistic getUsedNonHeap() {
        this.usedNonHeap.setCount(this.memBean.getNonHeapMemoryUsage().getUsed());
        return this.usedNonHeap;
    }

    @ManagedAttribute(id="objectpendingfinalizationcount-count")
    @Description(value="approximate number of objects for which finalization is pending")
    public CountStatistic getObjectPendingFinalizationCount() {
        this.objectPendingFinalizationCount.setCount((long)this.memBean.getObjectPendingFinalizationCount());
        return this.objectPendingFinalizationCount;
    }
}

