/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.exousia.modules.def;

import jakarta.security.jacc.PolicyConfiguration;
import jakarta.security.jacc.PolicyConfigurationFactory;
import jakarta.security.jacc.PolicyContext;
import jakarta.security.jacc.PolicyContextException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.glassfish.exousia.modules.def.DefaultPolicyConfiguration;
import org.glassfish.exousia.modules.def.DefaultPolicyConfigurationStateMachine;

public class DefaultPolicyConfigurationFactory
extends PolicyConfigurationFactory {
    private static final ConcurrentMap<String, DefaultPolicyConfigurationStateMachine> configurators = new ConcurrentHashMap<String, DefaultPolicyConfigurationStateMachine>();

    public PolicyConfiguration getPolicyConfiguration(String contextID, boolean remove) throws PolicyContextException {
        DefaultPolicyConfigurationStateMachine defaultPolicyConfigurationStateMachine = configurators.computeIfAbsent(contextID, contextId -> new DefaultPolicyConfigurationStateMachine(new DefaultPolicyConfiguration(contextID)));
        if (remove) {
            defaultPolicyConfigurationStateMachine.delete();
        }
        defaultPolicyConfigurationStateMachine.open();
        return defaultPolicyConfigurationStateMachine;
    }

    public boolean inService(String contextID) throws PolicyContextException {
        DefaultPolicyConfigurationStateMachine defaultPolicyConfigurationStateMachine = (DefaultPolicyConfigurationStateMachine)configurators.get(contextID);
        if (defaultPolicyConfigurationStateMachine == null) {
            return false;
        }
        return defaultPolicyConfigurationStateMachine.inService();
    }

    public PolicyConfiguration getPolicyConfiguration(String contextID) {
        return (DefaultPolicyConfiguration)((DefaultPolicyConfigurationStateMachine)configurators.get(contextID)).getPolicyConfiguration();
    }

    public PolicyConfiguration getPolicyConfiguration() {
        String contextId = PolicyContext.getContextID();
        if (contextId == null) {
            return null;
        }
        return this.getPolicyConfiguration(contextId);
    }
}

