/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.protocol;

import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.protocol.RequestId;

public class RequestIdImpl
implements RequestId {
    private static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;
    private final int value;
    private final boolean defined;
    private static final String UNDEFINED = "?";
    public static final RequestId UNKNOWN_CORBA_REQUEST_ID = new RequestIdImpl();

    public RequestIdImpl(int requestId) {
        this.value = requestId;
        this.defined = true;
    }

    private RequestIdImpl() {
        this.defined = false;
        this.value = -1;
    }

    @Override
    public int getValue() {
        if (this.defined) {
            return this.value;
        }
        throw wrapper.undefinedCorbaRequestIdNotAllowed();
    }

    @Override
    public boolean isDefined() {
        return this.defined;
    }

    public boolean equals(Object requestId) {
        if (requestId == null || !(requestId instanceof RequestId)) {
            return false;
        }
        if (this.isDefined()) {
            if (((RequestId)requestId).isDefined()) {
                return this.value == ((RequestId)requestId).getValue();
            }
            return false;
        }
        return !((RequestId)requestId).isDefined();
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        if (this.defined) {
            return Integer.toString(this.value);
        }
        return UNDEFINED;
    }
}

